/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class CompositeView
extends View {
    private View[] children;
    private int numChildren;
    private final Rectangle insideAllocation = new Rectangle();
    private short top = 0;
    private short bottom = 0;
    private short left = 0;
    private short right = 0;

    public CompositeView(Element element) {
        super(element);
        this.children = new View[0];
    }

    protected void loadChildren(ViewFactory f) {
        if (f != null) {
            Element el = this.getElement();
            int count = el.getElementCount();
            View[] newChildren = new View[count];
            int i = 0;
            while (i < count) {
                View view;
                Element child = el.getElement(i);
                newChildren[i] = view = f.create(child);
                ++i;
            }
            this.replace(0, 0, newChildren);
        }
    }

    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null && this.numChildren == 0) {
            this.loadChildren(this.getViewFactory());
        }
    }

    public int getViewCount() {
        return this.numChildren;
    }

    public View getView(int n) {
        return this.children[n];
    }

    public void replace(int offset, int length, View[] views) {
        if (views == null) {
            views = new View[]{};
        }
        int endOffset = offset + length;
        int i = offset;
        while (i < endOffset) {
            if (this.children[i].getParent() == this) {
                this.children[i].setParent(null);
            }
            this.children[i] = null;
            ++i;
        }
        int delta = views.length - length;
        int src = offset + length;
        int numMove = this.numChildren - src;
        int dst = src + delta;
        if (this.numChildren + delta > this.children.length) {
            int newLength = Math.max(2 * this.children.length, this.numChildren + delta);
            View[] newChildren = new View[newLength];
            System.arraycopy(this.children, 0, newChildren, 0, offset);
            System.arraycopy(views, 0, newChildren, offset, views.length);
            System.arraycopy(this.children, src, newChildren, dst, numMove);
            this.children = newChildren;
        } else {
            System.arraycopy(this.children, src, this.children, dst, numMove);
            System.arraycopy(views, 0, this.children, offset, views.length);
        }
        this.numChildren += delta;
        int i2 = 0;
        while (i2 < views.length) {
            views[i2].setParent(this);
            ++i2;
        }
    }

    public Shape getChildAllocation(int index, Shape a) {
        Rectangle r = this.getInsideAllocation(a);
        this.childAllocation(index, r);
        return r;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias bias) throws BadLocationException {
        Shape childAlloc;
        View child;
        int childIndex;
        boolean backward = bias == Position.Bias.Backward;
        int testpos = backward ? Math.max(0, pos - 1) : pos;
        Shape ret = null;
        if (!(backward && testpos < this.getStartOffset() || (childIndex = this.getViewIndexAtPosition(testpos)) == -1 || childIndex >= this.getViewCount() || (child = this.getView(childIndex)) == null || testpos < child.getStartOffset() || testpos >= child.getEndOffset() || (childAlloc = this.getChildAllocation(childIndex, a)) == null || (ret = child.modelToView(pos, childAlloc, bias)) != null || child.getEndOffset() != pos || ++childIndex >= this.getViewCount())) {
            child = this.getView(childIndex);
            childAlloc = this.getChildAllocation(childIndex, a);
            ret = child.modelToView(pos, childAlloc, bias);
        }
        if (ret == null) {
            throw new BadLocationException("Position " + pos + " is not represented by view.", pos);
        }
        return ret;
    }

    public Shape modelToView(int p1, Position.Bias b1, int p2, Position.Bias b2, Shape a) throws BadLocationException {
        return super.modelToView(p1, b1, p2, b2, a);
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
        if (x >= 0.0f && y >= 0.0f) {
            Rectangle r = this.getInsideAllocation(a);
            View view = this.getViewAtPoint((int)x, (int)y, r);
            return view.viewToModel(x, y, r, b);
        }
        return 0;
    }

    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int retVal = -1;
        switch (direction) {
            case 3: 
            case 7: {
                retVal = this.getNextEastWestVisualPositionFrom(pos, b, a, direction, biasRet);
                break;
            }
            case 1: 
            case 5: {
                retVal = this.getNextNorthSouthVisualPositionFrom(pos, b, a, direction, biasRet);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for direction.");
            }
        }
        return retVal;
    }

    public int getViewIndex(int pos, Position.Bias b) {
        if (b == Position.Bias.Backward) {
            --pos;
        }
        int i = -1;
        if (pos >= this.getStartOffset() && pos < this.getEndOffset()) {
            i = this.getViewIndexAtPosition(pos);
        }
        return i;
    }

    protected abstract boolean isBefore(int var1, int var2, Rectangle var3);

    protected abstract boolean isAfter(int var1, int var2, Rectangle var3);

    protected abstract View getViewAtPoint(int var1, int var2, Rectangle var3);

    protected abstract void childAllocation(int var1, Rectangle var2);

    protected View getViewAtPosition(int pos, Rectangle a) {
        View view = null;
        int i = this.getViewIndexAtPosition(pos);
        if (i >= 0 && i < this.getViewCount() && a != null) {
            view = this.getView(i);
            this.childAllocation(i, a);
        }
        return view;
    }

    protected int getViewIndexAtPosition(int pos) {
        Element el = this.getElement();
        return el.getElementIndex(pos);
    }

    protected Rectangle getInsideAllocation(Shape a) {
        if (a == null) {
            return null;
        }
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        Rectangle inside = this.insideAllocation;
        inside.x = alloc.x + this.getLeftInset();
        inside.y = alloc.y + this.getTopInset();
        inside.width = alloc.width - this.getLeftInset() - this.getRightInset();
        inside.height = alloc.height - this.getTopInset() - this.getBottomInset();
        return inside;
    }

    protected void setParagraphInsets(AttributeSet attributes) {
        this.top = (short)StyleConstants.getSpaceAbove(attributes);
        this.bottom = (short)StyleConstants.getSpaceBelow(attributes);
        this.left = (short)StyleConstants.getLeftIndent(attributes);
        this.right = (short)StyleConstants.getRightIndent(attributes);
    }

    protected void setInsets(short t, short l, short b, short r) {
        this.top = t;
        this.left = l;
        this.bottom = b;
        this.right = r;
    }

    protected short getLeftInset() {
        return this.left;
    }

    protected short getRightInset() {
        return this.right;
    }

    protected short getTopInset() {
        return this.top;
    }

    protected short getBottomInset() {
        return this.bottom;
    }

    protected int getNextNorthSouthVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int index = this.getViewIndex(pos, b);
        View v = null;
        if (index == -1) {
            return pos;
        }
        switch (direction) {
            case 1: {
                if (index <= 0) {
                    return pos;
                }
                v = this.getView(index - 1);
                break;
            }
            case 5: {
                if (index >= this.getViewCount() - 1) {
                    return pos;
                }
                v = this.getView(index + 1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return v.getNextVisualPositionFrom(pos, b, a, direction, biasRet);
    }

    protected int getNextEastWestVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        View v = null;
        switch (direction) {
            case 3: {
                int index = this.getViewIndex(pos + 1, b);
                if (index == -1) {
                    return pos;
                }
                v = this.getView(index);
                break;
            }
            case 7: {
                int index = this.getViewIndex(pos - 1, b);
                if (index == -1) {
                    return pos;
                }
                v = this.getView(index);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return v.getNextVisualPositionFrom(pos, b, a, direction, biasRet);
    }

    protected boolean flipEastAndWestAtEnds(int pos, Position.Bias bias) {
        return false;
    }
}

