/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import gnu.java.util.jar.JarUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manifest
implements Cloneable {
    private final Attributes mainAttr;
    private final Map<String, Attributes> entries;

    public Manifest() {
        this.mainAttr = new Attributes();
        this.entries = new Hashtable<String, Attributes>();
    }

    public Manifest(InputStream in) throws IOException {
        this();
        this.read(in);
    }

    public Manifest(Manifest man) {
        this.mainAttr = new Attributes(man.getMainAttributes());
        this.entries = new Hashtable<String, Attributes>(man.getEntries());
    }

    public Attributes getMainAttributes() {
        return this.mainAttr;
    }

    public Map<String, Attributes> getEntries() {
        return this.entries;
    }

    public Attributes getAttributes(String entryName) {
        return this.getEntries().get(entryName);
    }

    public void clear() {
        this.mainAttr.clear();
        this.entries.clear();
    }

    public void read(InputStream in) throws IOException {
        JarUtils.readMFManifest(this.getMainAttributes(), this.getEntries(), in);
    }

    public void write(OutputStream out) throws IOException {
        JarUtils.writeMFManifest(this.getMainAttributes(), this.getEntries(), out);
    }

    public Object clone() {
        return new Manifest(this);
    }

    public boolean equals(Object o) {
        return o instanceof Manifest && this.mainAttr.equals(((Manifest)o).mainAttr) && this.entries.equals(((Manifest)o).entries);
    }

    public int hashCode() {
        return this.mainAttr.hashCode() ^ this.entries.hashCode();
    }
}

