/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ThreadInfo {
    private long threadId;
    private String threadName;
    private Thread.State threadState;
    private long blockedCount;
    private long blockedTime;
    private String lockName;
    private long lockOwnerId;
    private String lockOwnerName;
    private long waitedCount;
    private long waitedTime;
    private boolean isInNative;
    private boolean isSuspended;
    private StackTraceElement[] trace;
    private MonitorInfo[] lockedMonitors;
    private LockInfo[] lockedSynchronizers;
    private static ThreadMXBean bean = null;
    private static CompositeType seType;

    private ThreadInfo(long threadId, String threadName, Thread.State threadState, long blockedCount, long blockedTime, String lockName, long lockOwnerId, String lockOwnerName, long waitedCount, long waitedTime, boolean isInNative, boolean isSuspended, StackTraceElement[] trace, MonitorInfo[] lockedMonitors, LockInfo[] lockedSynchronizers) {
        this.threadId = threadId;
        this.threadName = threadName;
        this.threadState = threadState;
        this.blockedCount = blockedCount;
        this.blockedTime = blockedTime;
        this.lockName = lockName;
        this.lockOwnerId = lockOwnerId;
        this.lockOwnerName = lockOwnerName;
        this.waitedCount = waitedCount;
        this.waitedTime = waitedTime;
        this.isInNative = isInNative;
        this.isSuspended = isSuspended;
        this.trace = trace;
        this.lockedMonitors = lockedMonitors;
        this.lockedSynchronizers = lockedSynchronizers;
    }

    static void checkAttribute(CompositeType ctype, String name, OpenType type) throws IllegalArgumentException {
        OpenType<?> foundType = ctype.getType(name);
        if (foundType == null) {
            throw new IllegalArgumentException("Could not find a field named " + name);
        }
        if (!foundType.equals(type)) {
            throw new IllegalArgumentException("Field " + name + " is not of " + "type " + type.getClassName());
        }
    }

    static CompositeType getStackTraceType() {
        if (seType == null) {
            try {
                seType = new CompositeType(StackTraceElement.class.getName(), "An element of a stack trace", new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"}, new String[]{"Name of the class", "Name of the method", "Name of the source code file", "Line number", "True if this is a native method"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.BOOLEAN});
            }
            catch (OpenDataException e) {
                throw new IllegalStateException("Something went wrong in creating the composite data type for the stack trace element.", e);
            }
        }
        return seType;
    }

    public static ThreadInfo from(CompositeData data) {
        LockInfo[] lInfo;
        MonitorInfo[] mInfo;
        if (data == null) {
            return null;
        }
        CompositeType type = data.getCompositeType();
        ThreadInfo.checkAttribute(type, "ThreadId", SimpleType.LONG);
        ThreadInfo.checkAttribute(type, "ThreadName", SimpleType.STRING);
        ThreadInfo.checkAttribute(type, "ThreadState", SimpleType.STRING);
        ThreadInfo.checkAttribute(type, "Suspended", SimpleType.BOOLEAN);
        ThreadInfo.checkAttribute(type, "InNative", SimpleType.BOOLEAN);
        ThreadInfo.checkAttribute(type, "BlockedCount", SimpleType.LONG);
        ThreadInfo.checkAttribute(type, "BlockedTime", SimpleType.LONG);
        ThreadInfo.checkAttribute(type, "WaitedCount", SimpleType.LONG);
        ThreadInfo.checkAttribute(type, "WaitedTime", SimpleType.LONG);
        ThreadInfo.checkAttribute(type, "LockName", SimpleType.STRING);
        ThreadInfo.checkAttribute(type, "LockOwnerId", SimpleType.LONG);
        ThreadInfo.checkAttribute(type, "LockOwnerName", SimpleType.STRING);
        try {
            ThreadInfo.checkAttribute(type, "StackTrace", new ArrayType(1, ThreadInfo.getStackTraceType()));
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Something went wrong in creating the array for the stack trace element.", e);
        }
        OpenType<?> foundType = type.getType("LockedMonitors");
        if (foundType != null) {
            try {
                CompositeType mType = new CompositeType(MonitorInfo.class.getName(), "Information on a object monitor lock", new String[]{"ClassName", "IdentityHashCode", "LockedStackDepth", "LockedStackFrame"}, new String[]{"Name of the class", "Identity hash code of the class", "Stack depth at time of lock", "Stack frame at time of lock"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, ThreadInfo.getStackTraceType()});
                if (!foundType.equals(new ArrayType(1, mType))) {
                    throw new IllegalArgumentException("Field LockedMonitors is not of type " + mType.getClassName());
                }
            }
            catch (OpenDataException e) {
                throw new IllegalStateException("Something went wrong in creating the composite data type for the object monitor information array.", e);
            }
        }
        if ((foundType = type.getType("LockedSynchronizers")) != null) {
            try {
                CompositeType lType = new CompositeType(LockInfo.class.getName(), "Information on a lock", new String[]{"ClassName", "IdentityHashCode"}, new String[]{"Name of the class", "Identity hash code of the class"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER});
                if (!foundType.equals(new ArrayType(1, lType))) {
                    throw new IllegalArgumentException("Field LockedSynchronizers is not of type " + lType.getClassName());
                }
            }
            catch (OpenDataException e) {
                throw new IllegalStateException("Something went wrong in creating the composite data type for the ownable synchronizerinformation array.", e);
            }
        }
        CompositeData[] dTraces = (CompositeData[])data.get("StackTrace");
        StackTraceElement[] traces = new StackTraceElement[dTraces.length];
        int a = 0;
        while (a < dTraces.length) {
            traces[a] = new StackTraceElement((String)dTraces[a].get("ClassName"), (String)dTraces[a].get("MethodName"), (String)dTraces[a].get("FileName"), (Integer)dTraces[a].get("LineNumber"));
            ++a;
        }
        if (data.containsKey("LockedMonitors")) {
            CompositeData[] dmInfos = (CompositeData[])data.get("LockedMonitors");
            mInfo = new MonitorInfo[dmInfos.length];
            int a2 = 0;
            while (a2 < dmInfos.length) {
                mInfo[a2] = MonitorInfo.from(dmInfos[a2]);
                ++a2;
            }
        } else {
            mInfo = new MonitorInfo[]{};
        }
        if (data.containsKey("LockedSynchronizers")) {
            CompositeData[] dlInfos = (CompositeData[])data.get("LockedSynchronizers");
            lInfo = new LockInfo[dlInfos.length];
            int a3 = 0;
            while (a3 < dlInfos.length) {
                lInfo[a3] = new LockInfo((String)dlInfos[a3].get("ClassName"), (Integer)dlInfos[a3].get("IdentityHashCode"));
                ++a3;
            }
        } else {
            lInfo = new LockInfo[]{};
        }
        return new ThreadInfo((Long)data.get("ThreadId"), (String)data.get("ThreadName"), Thread.State.valueOf((String)data.get("ThreadState")), (Long)data.get("BlockedCount"), (Long)data.get("BlockedTime"), (String)data.get("LockName"), (Long)data.get("LockOwnerId"), (String)data.get("LockOwnerName"), (Long)data.get("WaitedCount"), (Long)data.get("WaitedTime"), (Boolean)data.get("InNative"), (Boolean)data.get("Suspended"), traces, mInfo, lInfo);
    }

    public long getBlockedCount() {
        return this.blockedCount;
    }

    public long getBlockedTime() {
        if (bean == null) {
            bean = ManagementFactory.getThreadMXBean();
        }
        if (bean.isThreadContentionMonitoringEnabled()) {
            return this.blockedTime;
        }
        return -1L;
    }

    public MonitorInfo[] getLockedMonitors() {
        return this.lockedMonitors;
    }

    public LockInfo[] getLockedSynchronizers() {
        return this.lockedSynchronizers;
    }

    public LockInfo getLockInfo() {
        String lockName = this.getLockName();
        int at = lockName.indexOf(64);
        return new LockInfo(lockName.substring(0, at), Integer.decode(lockName.substring(at + 1)));
    }

    public String getLockName() {
        if (!this.isThreadBlocked()) {
            return null;
        }
        return this.lockName;
    }

    public long getLockOwnerId() {
        if (!this.isThreadBlocked()) {
            return -1L;
        }
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        if (!this.isThreadBlocked()) {
            return null;
        }
        return this.lockOwnerName;
    }

    public StackTraceElement[] getStackTrace() {
        return this.trace;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Thread.State getThreadState() {
        return this.threadState;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    public long getWaitedTime() {
        if (bean == null) {
            bean = ManagementFactory.getThreadMXBean();
        }
        if (bean.isThreadContentionMonitoringEnabled()) {
            return this.waitedTime;
        }
        return -1L;
    }

    public boolean isInNative() {
        return this.isInNative;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[id=" + this.threadId + ", name=" + this.threadName + ", state=" + (Object)((Object)this.threadState) + ", blockedCount=" + this.blockedCount + ", waitedCount=" + this.waitedCount + ", isInNative=" + this.isInNative + ", isSuspended=" + this.isSuspended + (this.isThreadBlocked() ? ", lockOwnerId=" + this.lockOwnerId + ", lockOwnerName=" + this.lockOwnerName : "") + ", lockedMonitors=" + Arrays.toString(this.lockedMonitors) + ", lockedSynchronizers=" + Arrays.toString(this.lockedSynchronizers) + "]";
    }

    private boolean isThreadBlocked() {
        return this.threadState == Thread.State.BLOCKED || this.threadState == Thread.State.WAITING || this.threadState == Thread.State.TIMED_WAITING;
    }
}

