/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print;

import gnu.javax.print.CupsPrintService;
import gnu.javax.print.ipp.IppException;
import gnu.javax.print.ipp.IppPrintService;
import gnu.javax.print.ipp.IppRequest;
import gnu.javax.print.ipp.IppResponse;
import gnu.javax.print.ipp.attribute.RequestedAttributes;
import gnu.javax.print.ipp.attribute.supported.PrinterUriSupported;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CupsServer {
    private transient URI uri;
    private transient String username;
    private transient String password;

    public CupsServer(String username, String password) {
        this.username = username;
        this.password = password;
        this.uri = null;
        try {
            String serv = System.getProperty("gnu.javax.print.server");
            if (serv != null) {
                this.uri = new URI("http://" + serv + ":631");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("gnu.javax.print.CupsServer value is not a valid hostname.");
        }
        catch (SecurityException securityException) {}
        try {
            if (this.uri == null) {
                this.uri = new URI("http://localhost:631");
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
    }

    public CupsServer(URI uri, String username, String password) {
        this.uri = uri;
        this.username = username;
        this.password = password;
    }

    public IppPrintService getDefaultPrinter() throws IppException {
        IppResponse response = null;
        try {
            IppRequest request = new IppRequest(this.uri, this.username, this.password);
            request.setOperationID((short)16385);
            request.setOperationAttributeDefaults();
            RequestedAttributes requestedAttrs = new RequestedAttributes("printer-uri-supported");
            request.addOperationAttribute(requestedAttrs);
            response = request.send();
        }
        catch (IOException e) {
            throw new IppException("IOException in IPP request/response.", e);
        }
        Map printerAttributes = (Map)response.getPrinterAttributes().get(0);
        Set uris = (Set)printerAttributes.get(PrinterUriSupported.class);
        PrinterUriSupported uri = (PrinterUriSupported)uris.toArray()[0];
        CupsPrintService service = new CupsPrintService(uri.getURI(), this.username, this.password);
        return service;
    }

    public List getAllPrinters() throws IppException {
        IppResponse response = null;
        try {
            IppRequest request = new IppRequest(this.uri, this.username, this.password);
            request.setOperationID((short)16386);
            request.setOperationAttributeDefaults();
            RequestedAttributes requestedAttrs = new RequestedAttributes("printer-uri-supported");
            request.addOperationAttribute(requestedAttrs);
            response = request.send();
        }
        catch (IOException e) {
            throw new IppException("IOException in IPP request/response.", e);
        }
        List prAttr = response.getPrinterAttributes();
        ArrayList<CupsPrintService> services = new ArrayList<CupsPrintService>();
        int i = 0;
        while (i < prAttr.size()) {
            Map printerAttributes = (Map)prAttr.get(i);
            Set uris = (Set)printerAttributes.get(PrinterUriSupported.class);
            PrinterUriSupported uri = (PrinterUriSupported)uris.toArray()[0];
            try {
                CupsPrintService cups = new CupsPrintService(uri.getURI(), this.username, this.password);
                services.add(cups);
            }
            catch (IppException ippException) {}
            ++i;
        }
        return services;
    }

    public List getAllClasses() throws IppException {
        IppResponse response = null;
        try {
            IppRequest request = new IppRequest(this.uri, this.username, this.password);
            request.setOperationID((short)16389);
            request.setOperationAttributeDefaults();
            RequestedAttributes requestedAttrs = new RequestedAttributes("printer-uri-supported");
            request.addOperationAttribute(requestedAttrs);
            response = request.send();
        }
        catch (IOException e) {
            throw new IppException("IOException in IPP request/response.", e);
        }
        List prAttr = response.getPrinterAttributes();
        ArrayList<CupsPrintService> services = new ArrayList<CupsPrintService>();
        int i = 0;
        while (i < prAttr.size()) {
            Map printerAttributes = (Map)prAttr.get(i);
            Set uris = (Set)printerAttributes.get(PrinterUriSupported.class);
            PrinterUriSupported uri = (PrinterUriSupported)uris.toArray()[0];
            try {
                CupsPrintService cups = new CupsPrintService(uri.getURI(), this.username, this.password);
                services.add(cups);
            }
            catch (IppException ippException) {}
            ++i;
        }
        return services;
    }
}

