/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeRGB4
extends BMPDecoder {
    public DecodeRGB4(BMPFileHeader fh, BMPInfoHeader ih) {
        super(fh, ih);
    }

    public BufferedImage decode(ImageInputStream in) throws IOException, BMPException {
        IndexColorModel palette = this.readPalette(in);
        this.skipToImage(in);
        Dimension d = this.infoHeader.getSize();
        int h = (int)d.getHeight();
        int w = (int)d.getWidth();
        int wbytes = w + (w & 1) >> 1;
        int scansize = (wbytes & 3) != 0 ? wbytes + 4 - (wbytes & 3) : wbytes;
        byte[] data = new byte[wbytes * h];
        int y = h - 1;
        while (y >= 0) {
            byte[] scanline = new byte[scansize];
            if (in.read(scanline) != scansize) {
                throw new IOException("Couldn't read image data.");
            }
            int x = 0;
            while (x < wbytes) {
                data[x + y * wbytes] = scanline[x];
                ++x;
            }
            --y;
        }
        MultiPixelPackedSampleModel sm = new MultiPixelPackedSampleModel(0, w, h, 4);
        DataBufferByte db = new DataBufferByte(data, w * h, 0);
        WritableRaster raster = Raster.createWritableRaster(sm, db, null);
        return new BufferedImage(palette, raster, false, null);
    }
}

