/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl;

import gnu.java.security.Requires;
import gnu.javax.net.ssl.Session;
import gnu.javax.net.ssl.SessionStoreException;
import gnu.javax.net.ssl.provider.SimpleSessionContext;
import java.util.Enumeration;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionContext
implements SSLSessionContext {
    protected long timeout;
    private static Class<? extends AbstractSessionContext> implClass = SimpleSessionContext.class;

    public static AbstractSessionContext newInstance() throws SSLException {
        try {
            return implClass.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new SSLException(iae);
        }
        catch (InstantiationException ie) {
            throw new SSLException(ie);
        }
    }

    @Requires(permissionClass=SSLPermission.class, target="gnu.javax.net.ssl.AbstractSessionContext", action="setImplClass")
    public static synchronized void setImplClass(Class<? extends AbstractSessionContext> clazz) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSLPermission("gnu.javax.net.ssl.AbstractSessionContext", "setImplClass"));
        }
        implClass = clazz;
    }

    protected AbstractSessionContext(int timeout) {
        this.setSessionTimeout(timeout);
    }

    @Override
    public final SSLSession getSession(byte[] sessionId) {
        Session s = this.implGet(sessionId);
        if (s != null && System.currentTimeMillis() - s.getLastAccessedTime() > this.timeout) {
            this.remove(sessionId);
            return null;
        }
        return s;
    }

    public final SSLSession getSession(String host, int port) {
        Enumeration e = this.getIds();
        while (e.hasMoreElements()) {
            int port2;
            byte[] id = (byte[])e.nextElement();
            SSLSession s = this.getSession(id);
            if (s == null) continue;
            String host2 = s.getPeerHost();
            if ((host != null ? !host.equals(host2) : host2 != null) || port != (port2 = s.getPeerPort())) continue;
            return s;
        }
        return null;
    }

    protected abstract Session implGet(byte[] var1);

    @Override
    public int getSessionTimeout() {
        return (int)(this.timeout / 1000L);
    }

    public abstract void load(char[] var1) throws SessionStoreException;

    public abstract void put(Session var1);

    public abstract void remove(byte[] var1);

    @Override
    public final void setSessionTimeout(int seconds) {
        if (this.timeout < 0L) {
            throw new IllegalArgumentException("timeout may not be negative");
        }
        this.timeout = (long)seconds * 1000L;
    }

    public abstract void store(char[] var1) throws SessionStoreException;
}

