/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDOMException;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public final class DomIterator
implements NodeIterator,
EventListener {
    private Node reference;
    private boolean right;
    private boolean done;
    private final Node root;
    private final int whatToShow;
    private final NodeFilter filter;
    private final boolean expandEntityReferences;

    protected DomIterator(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) {
        if (!root.isSupported("MutationEvents", "2.0")) {
            throw new DomDOMException(9, "Iterator needs mutation events", root, 0);
        }
        this.root = root;
        this.whatToShow = whatToShow;
        this.filter = filter;
        this.expandEntityReferences = entityReferenceExpansion;
        this.reference = null;
        this.right = true;
        EventTarget target = (EventTarget)((Object)root);
        target.addEventListener("DOMNodeRemoved", this, false);
    }

    public void detach() {
        EventTarget target = (EventTarget)((Object)this.root);
        target.removeEventListener("DOMNodeRemoved", this, false);
        this.done = true;
    }

    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public Node nextNode() {
        if (this.done) {
            throw new DomDOMException(11);
        }
        this.right = true;
        return this.walk(true);
    }

    public Node previousNode() {
        if (this.done) {
            throw new DomDOMException(11);
        }
        Node previous = this.reference;
        this.right = false;
        this.walk(false);
        return previous;
    }

    private boolean shouldShow(Node node2) {
        if ((this.whatToShow & 1 << node2.getNodeType() - 1) == 0) {
            return false;
        }
        if (this.filter == null) {
            return true;
        }
        return this.filter.acceptNode(node2) == 1;
    }

    private Node walk(boolean forward) {
        Node here = this.reference;
        while ((here = this.successor(here, forward)) != null && !this.shouldShow(here)) {
        }
        if (here != null || !forward) {
            this.reference = here;
        }
        return here;
    }

    private boolean isLeaf(Node here) {
        boolean leaf;
        boolean bl = leaf = !here.hasChildNodes();
        if (!leaf && !this.expandEntityReferences) {
            leaf = here.getNodeType() == 5;
        }
        return leaf;
    }

    private Node successor(Node here, boolean forward) {
        Node next;
        if (here == null) {
            return forward ? this.root : null;
        }
        if (forward && !this.isLeaf(here)) {
            return here.getFirstChild();
        }
        if (here == this.root) {
            return null;
        }
        if (forward) {
            next = here.getNextSibling();
            if (next != null) {
                return next;
            }
        } else {
            next = here.getPreviousSibling();
            if (next != null) {
                if (this.isLeaf(next)) {
                    return next;
                }
                next = next.getLastChild();
                while (!this.isLeaf(next)) {
                    next = next.getLastChild();
                }
                return next;
            }
        }
        next = here.getParentNode();
        if (!forward) {
            return next;
        }
        Node temp = null;
        while (next != null && next != this.root && (temp = next.getNextSibling()) == null) {
            next = next.getParentNode();
        }
        if (next == this.root.getParentNode()) {
            return null;
        }
        return temp;
    }

    /*
     * Unable to fully structure code
     */
    public void handleEvent(Event e) {
        if (this.reference == null || !"DOMNodeRemoved".equals(e.getType()) || e.getEventPhase() != 3) {
            return;
        }
        event = (MutationEvent)e;
        removed = (Node)event.getTarget();
        ancestor = this.reference;
        while (ancestor != null && ancestor != this.root) {
            if (ancestor == removed) break;
            ancestor = ancestor.getParentNode();
        }
        if (ancestor == removed) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            ancestor = candidate;
            while (ancestor != null && ancestor != this.root) {
                if (ancestor == removed) continue block1;
                ancestor = ancestor.getParentNode();
            }
            return;
lbl18:
            // 2 sources

            ** while ((candidate = this.walk((boolean)(this.right == false))) != null)
        }
lbl19:
        // 1 sources

    }
}

