/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.ContentType;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Record {
    private final ByteBuffer buffer;

    public Record(ByteBuffer buffer) {
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public ContentType getContentType() {
        return this.contentType();
    }

    public ContentType contentType() {
        return ContentType.forInteger(this.buffer.get(0) & 0xFF);
    }

    public int fragment(ByteBuffer sink) {
        int length = this.length();
        sink.put(((ByteBuffer)this.buffer.limit(5 + length).position(5)).slice());
        return length;
    }

    public ByteBuffer fragment() {
        int length = this.length();
        return ((ByteBuffer)this.buffer.limit(5 + length).position(5)).slice();
    }

    public int length() {
        return this.buffer.getShort(3) & 0xFFFF;
    }

    public ProtocolVersion version() {
        int major = this.buffer.get(1) & 0xFF;
        int minor = this.buffer.get(2) & 0xFF;
        return ProtocolVersion.getInstance(major, minor);
    }

    public void setContentType(ContentType type) {
        this.buffer.put(0, (byte)type.getValue());
    }

    public void setLength(int length) {
        if (length < 0 || length > 16384) {
            throw new IllegalArgumentException("length " + length + " out of range; " + "must be between 0 and 16384");
        }
        this.buffer.putShort(3, (short)length);
    }

    public void setVersion(ProtocolVersion version) {
        this.buffer.put(1, (byte)version.major()).put(2, (byte)version.minor());
    }

    public String toString() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("struct {");
        out.print("  type:    ");
        out.print((Object)this.contentType());
        out.println(";");
        out.print("  version: ");
        out.print(this.version());
        out.println(";");
        out.print("  length: ");
        out.print(this.length());
        out.println(";");
        out.println("  fragment {");
        out.print(Util.hexDump(this.fragment(), "    "));
        out.println("  };");
        out.print("} Record;");
        return str.toString();
    }
}

