/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang;

import gnu.java.lang.CPStringBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ClassHelper {
    private static Map allMethods = new HashMap();
    private static Map allFields = new HashMap();

    public static String getTruncatedClassName(Class clazz) {
        return ClassHelper.getTruncatedName(clazz.getName());
    }

    public static String getTruncatedName(String name) {
        int lastInd = name.lastIndexOf(46);
        if (lastInd == -1) {
            return name;
        }
        return name.substring(lastInd + 1);
    }

    public static String getUserName(Class klass) {
        int arrayCount = 0;
        while (klass.isArray()) {
            ++arrayCount;
            klass = klass.getComponentType();
        }
        String name = klass.getName();
        if (arrayCount == 0) {
            return name;
        }
        CPStringBuilder b = new CPStringBuilder(name.length() + 2 * arrayCount);
        b.append(name);
        int i = 0;
        while (i < arrayCount) {
            b.append("[]");
            ++i;
        }
        return b.toString();
    }

    public static Method[] getAllMethods(Class clazz) {
        Method[] retval = (Method[])allMethods.get(clazz);
        if (retval == null) {
            HashSet<Method> methods = new HashSet<Method>();
            Class c = clazz;
            while (c != null) {
                Method[] currentMethods = c.getDeclaredMethods();
                int i = 0;
                while (i < currentMethods.length) {
                    block5: {
                        Method current = currentMethods[i];
                        int size = methods.size();
                        Iterator iter = methods.iterator();
                        while (--size >= 0) {
                            Method override = (Method)iter.next();
                            if (!current.getName().equals(override.getName()) || !Arrays.equals(current.getParameterTypes(), override.getParameterTypes()) || current.getReturnType() != override.getReturnType()) {
                                continue;
                            }
                            break block5;
                        }
                        methods.add(current);
                    }
                    ++i;
                }
                c = c.getSuperclass();
            }
            retval = new Method[methods.size()];
            methods.toArray(retval);
            allMethods.put(clazz, retval);
        }
        return retval;
    }

    public static Field[] getAllFields(Class clazz) {
        Field[] retval = (Field[])allFields.get(clazz);
        if (retval == null) {
            HashSet<Field> fields = new HashSet<Field>();
            Class c = clazz;
            while (c != null) {
                Field[] currentFields = c.getDeclaredFields();
                int i = 0;
                while (i < currentFields.length) {
                    block5: {
                        Field current = currentFields[i];
                        int size = fields.size();
                        Iterator iter = fields.iterator();
                        while (--size >= 0) {
                            Field override = (Field)iter.next();
                            if (!current.getName().equals(override.getName()) || current.getType() != override.getType()) {
                                continue;
                            }
                            break block5;
                        }
                        fields.add(current);
                    }
                    ++i;
                }
                c = c.getSuperclass();
            }
            retval = new Field[fields.size()];
            fields.toArray(retval);
            allFields.put(clazz, retval);
        }
        return retval;
    }
}

