/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.hash.IMessageDigest;
import gnu.javax.crypto.mac.HMac;
import java.security.InvalidKeyException;
import java.util.Map;

class TLSHMac
extends HMac {
    private static final byte IPAD_BYTE = 54;
    private static final byte OPAD_BYTE = 92;

    TLSHMac(IMessageDigest hash) {
        super(hash);
    }

    public void init(Map attributes) throws InvalidKeyException, IllegalStateException {
        Integer ts = (Integer)attributes.get("gnu.crypto.mac.truncated.size");
        int n = this.truncatedSize = ts == null ? this.macSize : ts;
        if (this.truncatedSize < this.macSize / 2) {
            throw new IllegalArgumentException("Truncated size too small");
        }
        if (this.truncatedSize < 10) {
            throw new IllegalArgumentException("Truncated size less than 80 bits");
        }
        byte[] K = (byte[])attributes.get("gnu.crypto.mac.key.material");
        if (K == null) {
            if (this.ipadHash == null) {
                throw new InvalidKeyException("Null key");
            }
            this.underlyingHash = (IMessageDigest)this.ipadHash.clone();
            return;
        }
        if (K.length > this.blockSize) {
            this.underlyingHash.update(K, 0, K.length);
            K = this.underlyingHash.digest();
        }
        if (K.length < this.blockSize) {
            int limit = K.length > this.blockSize ? this.blockSize : K.length;
            byte[] newK = new byte[this.blockSize];
            System.arraycopy(K, 0, newK, 0, limit);
            K = newK;
        }
        this.underlyingHash.reset();
        this.opadHash = (IMessageDigest)this.underlyingHash.clone();
        if (this.ipad == null) {
            this.ipad = new byte[this.blockSize];
        }
        int i = 0;
        while (i < this.blockSize) {
            this.ipad[i] = (byte)(K[i] ^ 0x36);
            ++i;
        }
        i = 0;
        while (i < this.blockSize) {
            this.opadHash.update((byte)(K[i] ^ 0x5C));
            ++i;
        }
        this.underlyingHash.update(this.ipad, 0, this.blockSize);
        this.ipadHash = (IMessageDigest)this.underlyingHash.clone();
        K = null;
    }
}

