/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.local;

import gnu.java.net.local.LocalSocketAddress;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;

final class LocalSocketImpl
extends SocketImpl {
    private boolean created;
    private InputStream in;
    private OutputStream out;
    private int socket_fd;
    private LocalSocketAddress local;
    private LocalSocketAddress remote;

    LocalSocketImpl() {
        this(false);
    }

    LocalSocketImpl(boolean nocreate) {
        this.created = nocreate;
        this.socket_fd = -1;
        this.fd = new FileDescriptor();
    }

    public void setOption(int opt, Object value) throws SocketException {
        throw new SocketException("local sockets do not support options");
    }

    public Object getOption(int opt) throws SocketException {
        throw new SocketException("local sockets do not support options");
    }

    protected void create(boolean stream) throws IOException {
    }

    protected void listen(int timeout) throws IOException {
    }

    protected void accept(LocalSocketImpl socket) throws IOException {
    }

    protected int available() throws IOException {
        return -1;
    }

    protected void close() throws IOException {
    }

    protected void sendUrgentData(int data) throws IOException {
    }

    protected void shutdownInput() throws IOException {
    }

    protected void shutdownOutput() throws IOException {
    }

    void unlink() throws IOException {
    }

    void localBind(LocalSocketAddress addr) throws IOException {
    }

    void localConnect(LocalSocketAddress addr) throws IOException {
    }

    int read(byte[] buf, int off, int len) throws IOException {
        return -1;
    }

    void write(byte[] buf, int off, int len) throws IOException {
    }

    void doCreate() throws IOException {
        if (!this.created) {
            this.create(true);
        }
    }

    LocalSocketAddress getLocalAddress() {
        return this.local;
    }

    LocalSocketAddress getRemoteAddress() {
        return this.remote;
    }

    protected InputStream getInputStream() {
        if (this.in == null) {
            this.in = new LocalInputStream(this);
        }
        return this.in;
    }

    protected OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = new LocalOutputStream(this);
        }
        return this.out;
    }

    protected void accept(SocketImpl impl) throws IOException {
        if (!(impl instanceof LocalSocketImpl)) {
            throw new IllegalArgumentException("not a local socket");
        }
        this.accept((LocalSocketImpl)impl);
    }

    protected void connect(String host, int port) throws IOException {
        throw new SocketException("this is a local socket");
    }

    protected void connect(InetAddress addr, int port) throws IOException {
        throw new SocketException("this is a local socket");
    }

    protected void connect(SocketAddress addr, int timeout) throws IOException {
        if (!(addr instanceof LocalSocketAddress)) {
            throw new SocketException("address is not local");
        }
        this.localConnect((LocalSocketAddress)addr);
    }

    protected void bind(InetAddress addr, int port) throws IOException {
        throw new SocketException("this is a local socket");
    }

    protected void bind(SocketAddress addr) throws IOException {
        if (!(addr instanceof LocalSocketAddress)) {
            throw new SocketException("address is not local");
        }
        this.localBind((LocalSocketAddress)addr);
    }

    class LocalInputStream
    extends InputStream {
        private final LocalSocketImpl impl;

        LocalInputStream(LocalSocketImpl impl) {
            this.impl = impl;
        }

        public int available() throws IOException {
            return this.impl.available();
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int readLimit) {
        }

        public void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        public void close() throws IOException {
            this.impl.close();
        }

        public int read() throws IOException {
            byte[] buf = new byte[1];
            int ret = this.read(buf);
            if (ret != -1) {
                return buf[0] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            int ret = this.impl.read(buf, off, len);
            if (ret == 0) {
                return -1;
            }
            return ret;
        }
    }

    class LocalOutputStream
    extends OutputStream {
        private final LocalSocketImpl impl;

        LocalOutputStream(LocalSocketImpl impl) {
            this.impl = impl;
        }

        public void close() throws IOException {
            this.impl.close();
        }

        public void flush() throws IOException {
        }

        public void write(int b) throws IOException {
            byte[] buf = new byte[]{(byte)b};
            this.write(buf);
        }

        public void write(byte[] buf) throws IOException {
            this.write(buf, 0, buf.length);
        }

        public void write(byte[] buf, int off, int len) throws IOException {
            this.impl.write(buf, off, len);
        }
    }
}

