/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;

public abstract class XPathFactory {
    public static final String DEFAULT_PROPERTY_NAME = "javax.xml.xpath.XPathFactory";
    public static final String DEFAULT_OBJECT_MODEL_URI = "http://java.sun.com/jaxp/xpath/dom";

    protected XPathFactory() {
    }

    public static final XPathFactory newInstance() {
        try {
            return XPathFactory.newInstance(DEFAULT_OBJECT_MODEL_URI);
        }
        catch (XPathFactoryConfigurationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static final XPathFactory newInstance(String uri) throws XPathFactoryConfigurationException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = XPathFactory.class.getClassLoader();
        }
        String className = null;
        int count = 0;
        do {
            if ((className = XPathFactory.getFactoryClassName(loader, count++)) == null) continue;
            try {
                Class<?> t = loader != null ? loader.loadClass(className) : Class.forName(className);
                XPathFactory ret = (XPathFactory)t.newInstance();
                if (ret.isObjectModelSupported(uri)) {
                    return ret;
                }
                className = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                className = null;
            }
            catch (Exception e) {
                throw new XPathFactoryConfigurationException(e);
            }
        } while (className == null && count < 4);
        String msg = "no factories with support for " + uri;
        throw new XPathFactoryConfigurationException(msg);
    }

    private static String getFactoryClassName(ClassLoader loader, int attempt) {
        switch (attempt) {
            case 0: {
                return System.getProperty(DEFAULT_PROPERTY_NAME);
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "jaxp.properties");
                    FileInputStream in = new FileInputStream(file);
                    Properties props = new Properties();
                    props.load(in);
                    ((InputStream)in).close();
                    return props.getProperty(DEFAULT_PROPERTY_NAME);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream in;
                    String serviceKey = "/META-INF/services/javax.xml.xpath.XPathFactory";
                    InputStream inputStream = in = loader != null ? loader.getResourceAsStream(serviceKey) : XPathFactory.class.getResourceAsStream(serviceKey);
                    if (in != null) {
                        BufferedReader r = new BufferedReader(new InputStreamReader(in));
                        String ret = r.readLine();
                        r.close();
                        return ret;
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
            case 3: {
                return "gnu.xml.xpath.XPathFactoryImpl";
            }
        }
        return null;
    }

    public abstract boolean isObjectModelSupported(String var1);

    public abstract void setFeature(String var1, boolean var2) throws XPathFactoryConfigurationException;

    public abstract boolean getFeature(String var1) throws XPathFactoryConfigurationException;

    public abstract void setXPathVariableResolver(XPathVariableResolver var1);

    public abstract void setXPathFunctionResolver(XPathFunctionResolver var1);

    public abstract XPath newXPath();
}

