/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.ComboBoxModel;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.Option;

public class HTMLWriter
extends AbstractWriter {
    private Writer outWriter = null;
    private HTMLDocument htmlDoc = null;
    private HashSet openEmbededTagHashSet = null;
    private String new_line_str = "\n";
    private char[] html_entity_char_arr = new char[]{'<', '>', '&', '\"'};
    private String[] html_entity_escape_str_arr = new String[]{"&lt;", "&gt;", "&amp;", "&quot;"};
    private int doc_pos = -1;
    private int doc_len = -1;
    private int doc_offset_remaining = -1;
    private int doc_len_remaining = -1;
    private HashSet htmlFragmentParentHashSet = null;
    private Element startElem = null;
    private Element endElem = null;
    private boolean fg_pass_start_elem = false;
    private boolean fg_pass_end_elem = false;

    public HTMLWriter(Writer writer, HTMLDocument doc) {
        super(writer, doc);
        this.outWriter = writer;
        this.htmlDoc = doc;
        this.openEmbededTagHashSet = new HashSet();
    }

    public HTMLWriter(Writer writer, HTMLDocument doc, int pos, int len) {
        super(writer, doc, pos, len);
        this.outWriter = writer;
        this.htmlDoc = doc;
        this.openEmbededTagHashSet = new HashSet();
        this.doc_pos = pos;
        this.doc_offset_remaining = pos;
        this.doc_len = len;
        this.doc_len_remaining = len;
        this.htmlFragmentParentHashSet = new HashSet();
    }

    public void write() throws IOException, BadLocationException {
        Element rootElem = this.htmlDoc.getDefaultRootElement();
        if (this.doc_pos == -1 && this.doc_len == -1) {
            this.traverse(rootElem);
        } else {
            if (this.doc_pos == -1 || this.doc_len == -1) {
                throw new BadLocationException("Bad Location(" + this.doc_pos + ", " + this.doc_len + ")", this.doc_pos);
            }
            this.startElem = this.htmlDoc.getCharacterElement(this.doc_pos);
            int start_offset = this.startElem.getStartOffset();
            if (start_offset > 0) {
                this.doc_offset_remaining -= start_offset;
            }
            Element tempParentElem = this.startElem;
            while ((tempParentElem = tempParentElem.getParentElement()) != null) {
                if (this.htmlFragmentParentHashSet.contains(tempParentElem)) continue;
                this.htmlFragmentParentHashSet.add(tempParentElem);
            }
            tempParentElem = this.endElem = this.htmlDoc.getCharacterElement(this.doc_pos + this.doc_len - 1);
            while ((tempParentElem = tempParentElem.getParentElement()) != null) {
                if (this.htmlFragmentParentHashSet.contains(tempParentElem)) continue;
                this.htmlFragmentParentHashSet.add(tempParentElem);
            }
            this.traverseHtmlFragment(rootElem);
        }
        Object[] tag_arr = this.openEmbededTagHashSet.toArray();
        int i = 0;
        while (i < tag_arr.length) {
            this.writeRaw("</" + tag_arr[i].toString() + ">");
            ++i;
        }
    }

    protected void writeAttributes(AttributeSet attrSet) throws IOException {
        Enumeration<?> attrNameEnum = attrSet.getAttributeNames();
        while (attrNameEnum.hasMoreElements()) {
            Object key = attrNameEnum.nextElement();
            Object value = attrSet.getAttribute(key);
            if (key instanceof HTML.Tag || key instanceof StyleConstants || key == HTML.Attribute.ENDTAG) continue;
            if (key == HTML.Attribute.SELECTED) {
                this.writeRaw(" selected");
                continue;
            }
            if (key == HTML.Attribute.CHECKED) {
                this.writeRaw(" checked");
                continue;
            }
            this.writeRaw(" " + key + "=\"" + value + "\"");
        }
    }

    protected void emptyTag(Element paramElem) throws IOException, BadLocationException {
        String elem_name = paramElem.getName();
        AttributeSet attrSet = paramElem.getAttributes();
        this.writeRaw("<" + elem_name);
        this.writeAttributes(attrSet);
        this.writeRaw(">");
        if (this.isBlockTag(attrSet)) {
            this.writeRaw("</" + elem_name + ">");
        }
    }

    protected boolean isBlockTag(AttributeSet attrSet) {
        return ((HTML.Tag)attrSet.getAttribute(StyleConstants.NameAttribute)).isBlock();
    }

    protected void startTag(Element paramElem) throws IOException, BadLocationException {
        String elem_name = paramElem.getName();
        AttributeSet attrSet = paramElem.getAttributes();
        this.indent();
        this.writeRaw("<" + elem_name);
        this.writeAttributes(attrSet);
        this.writeRaw(">");
        this.writeLineSeparator();
        this.incrIndent();
    }

    protected void textAreaContent(AttributeSet attrSet) throws IOException, BadLocationException {
        this.writeLineSeparator();
        this.indent();
        this.writeRaw("<textarea");
        this.writeAttributes(attrSet);
        this.writeRaw(">");
        Document tempDocument = (Document)attrSet.getAttribute(StyleConstants.ModelAttribute);
        this.writeRaw(tempDocument.getText(0, tempDocument.getLength()));
        this.indent();
        this.writeRaw("</textarea>");
    }

    protected void text(Element paramElem) throws IOException, BadLocationException {
        int offset = paramElem.getStartOffset();
        int len = paramElem.getEndOffset() - paramElem.getStartOffset();
        String txt_value = this.htmlDoc.getText(offset, len);
        this.writeContent(txt_value);
    }

    protected void selectContent(AttributeSet attrSet) throws IOException {
        this.writeLineSeparator();
        this.indent();
        this.writeRaw("<select");
        this.writeAttributes(attrSet);
        this.writeRaw(">");
        this.incrIndent();
        this.writeLineSeparator();
        ComboBoxModel comboBoxModel = (ComboBoxModel)attrSet.getAttribute(StyleConstants.ModelAttribute);
        int i = 0;
        while (i < comboBoxModel.getSize()) {
            this.writeOption((Option)comboBoxModel.getElementAt(i));
            ++i;
        }
        this.decrIndent();
        this.indent();
        this.writeRaw("</select>");
    }

    protected void writeOption(Option option) throws IOException {
        this.indent();
        this.writeRaw("<option");
        this.writeAttributes(option.getAttributes());
        this.writeRaw(">");
        this.writeContent(option.getLabel());
        this.writeRaw("</option>");
        this.writeLineSeparator();
    }

    protected void endTag(Element paramElem) throws IOException {
        String elem_name = paramElem.getName();
        this.decrIndent();
        this.indent();
        this.writeRaw("</" + elem_name + ">");
        this.writeLineSeparator();
    }

    protected void comment(Element paramElem) throws IOException, BadLocationException {
        AttributeSet attrSet = paramElem.getAttributes();
        String comment_str = (String)attrSet.getAttribute(HTML.Attribute.COMMENT);
        this.writeRaw("<!--" + comment_str + "-->");
    }

    protected boolean synthesizedElement(Element element) {
        AttributeSet attrSet = element.getAttributes();
        Object tagType = attrSet.getAttribute(StyleConstants.NameAttribute);
        return tagType == HTML.Tag.CONTENT || tagType == HTML.Tag.COMMENT || tagType == HTML.Tag.IMPLIED;
    }

    protected boolean matchNameAttribute(AttributeSet attrSet, HTML.Tag tag) {
        Object tagType = attrSet.getAttribute(StyleConstants.NameAttribute);
        return tagType == tag;
    }

    protected void writeEmbeddedTags(AttributeSet attrSet) throws IOException {
        Enumeration<?> attrNameEnum = attrSet.getAttributeNames();
        while (attrNameEnum.hasMoreElements()) {
            Object key = attrNameEnum.nextElement();
            Object value = attrSet.getAttribute(key);
            if (!(key instanceof HTML.Tag) || this.openEmbededTagHashSet.contains(key)) continue;
            this.writeRaw("<" + key);
            this.writeAttributes((AttributeSet)value);
            this.writeRaw(">");
            this.openEmbededTagHashSet.add(key);
        }
    }

    protected void closeOutUnwantedEmbeddedTags(AttributeSet attrSet) throws IOException {
        Object[] tag_arr = this.openEmbededTagHashSet.toArray();
        int i = 0;
        while (i < tag_arr.length) {
            HTML.Tag key = (HTML.Tag)tag_arr[i];
            if (!attrSet.isDefined(key)) {
                this.writeRaw("</" + key.toString() + ">");
                this.openEmbededTagHashSet.remove(key);
            }
            ++i;
        }
    }

    protected void writeLineSeparator() throws IOException {
        this.writeRaw(this.new_line_str);
    }

    protected void output(char[] chars, int off, int len) throws IOException {
        CPStringBuilder strBuffer = new CPStringBuilder();
        int i = 0;
        while (i < chars.length) {
            if (this.isCharHtmlEntity(chars[i])) {
                strBuffer.append(this.escapeCharHtmlEntity(chars[i]));
            } else {
                strBuffer.append(chars[i]);
            }
            ++i;
        }
        this.writeRaw(strBuffer.toString());
    }

    private void traverse(Element paramElem) throws IOException, BadLocationException {
        Element currElem = paramElem;
        AttributeSet attrSet = currElem.getAttributes();
        this.closeOutUnwantedEmbeddedTags(attrSet);
        if (this.synthesizedElement(paramElem)) {
            int child_elem_count;
            if (this.matchNameAttribute(attrSet, HTML.Tag.CONTENT)) {
                this.writeEmbeddedTags(attrSet);
                this.text(currElem);
            } else if (this.matchNameAttribute(attrSet, HTML.Tag.COMMENT)) {
                this.comment(currElem);
            } else if (this.matchNameAttribute(attrSet, HTML.Tag.IMPLIED) && (child_elem_count = currElem.getElementCount()) > 0) {
                int i = 0;
                while (i < child_elem_count) {
                    Element childElem = paramElem.getElement(i);
                    this.traverse(childElem);
                    ++i;
                }
            }
        } else if (this.matchNameAttribute(attrSet, HTML.Tag.TITLE)) {
            boolean fg_is_end_tag = false;
            Enumeration<?> attrNameEnum = attrSet.getAttributeNames();
            while (attrNameEnum.hasMoreElements()) {
                Object key = attrNameEnum.nextElement();
                Object value = attrSet.getAttribute(key);
                if (key != HTML.Attribute.ENDTAG || !value.equals("true")) continue;
                fg_is_end_tag = true;
            }
            if (fg_is_end_tag) {
                this.writeRaw("</title>");
            } else {
                this.indent();
                this.writeRaw("<title>");
                String title_str = (String)this.htmlDoc.getProperty("title");
                if (title_str != null) {
                    this.writeContent(title_str);
                }
            }
        } else if (this.matchNameAttribute(attrSet, HTML.Tag.PRE)) {
            attrSet = paramElem.getAttributes();
            this.indent();
            this.writeRaw("<pre");
            this.writeAttributes(attrSet);
            this.writeRaw(">");
            int child_elem_count = currElem.getElementCount();
            int i = 0;
            while (i < child_elem_count) {
                Element childElem = paramElem.getElement(i);
                this.traverse(childElem);
                ++i;
            }
            this.writeRaw("</pre>");
        } else if (this.matchNameAttribute(attrSet, HTML.Tag.SELECT)) {
            this.selectContent(attrSet);
        } else if (this.matchNameAttribute(attrSet, HTML.Tag.TEXTAREA)) {
            this.textAreaContent(attrSet);
        } else {
            int child_elem_count = currElem.getElementCount();
            if (child_elem_count > 0) {
                this.startTag(currElem);
                int i = 0;
                while (i < child_elem_count) {
                    Element childElem = paramElem.getElement(i);
                    this.traverse(childElem);
                    ++i;
                }
                this.endTag(currElem);
            } else {
                this.emptyTag(currElem);
            }
        }
    }

    private void traverseHtmlFragment(Element paramElem) throws IOException, BadLocationException {
        Element currElem = paramElem;
        boolean fg_is_fragment_parent_elem = false;
        boolean fg_is_start_and_end_elem = false;
        if (this.htmlFragmentParentHashSet.contains(paramElem)) {
            fg_is_fragment_parent_elem = true;
        }
        if (paramElem == this.startElem) {
            this.fg_pass_start_elem = true;
        }
        if (paramElem == this.startElem && paramElem == this.endElem) {
            fg_is_start_and_end_elem = true;
        }
        AttributeSet attrSet = currElem.getAttributes();
        this.closeOutUnwantedEmbeddedTags(attrSet);
        if (fg_is_fragment_parent_elem || this.fg_pass_start_elem && !this.fg_pass_end_elem || fg_is_start_and_end_elem) {
            if (this.synthesizedElement(paramElem)) {
                int child_elem_count;
                if (this.matchNameAttribute(attrSet, HTML.Tag.CONTENT)) {
                    this.writeEmbeddedTags(attrSet);
                    int content_offset = paramElem.getStartOffset();
                    int content_length = currElem.getEndOffset() - content_offset;
                    if (this.doc_offset_remaining > 0) {
                        if (content_length > this.doc_offset_remaining) {
                            int split_len = content_length;
                            if ((split_len -= this.doc_offset_remaining) > this.doc_len_remaining) {
                                split_len = this.doc_len_remaining;
                            }
                            String txt_value = this.htmlDoc.getText(content_offset + this.doc_offset_remaining, split_len);
                            this.writeContent(txt_value);
                            this.doc_offset_remaining = 0;
                            this.doc_len_remaining -= split_len;
                        } else {
                            this.doc_offset_remaining -= content_length;
                        }
                    } else if (content_length <= this.doc_len_remaining) {
                        this.text(currElem);
                        this.doc_len_remaining -= content_length;
                    } else {
                        String txt_value = this.htmlDoc.getText(content_offset, this.doc_len_remaining);
                        this.writeContent(txt_value);
                        this.doc_len_remaining = 0;
                    }
                } else if (this.matchNameAttribute(attrSet, HTML.Tag.COMMENT)) {
                    this.comment(currElem);
                } else if (this.matchNameAttribute(attrSet, HTML.Tag.IMPLIED) && (child_elem_count = currElem.getElementCount()) > 0) {
                    int i = 0;
                    while (i < child_elem_count) {
                        Element childElem = paramElem.getElement(i);
                        this.traverseHtmlFragment(childElem);
                        ++i;
                    }
                }
            } else {
                if (paramElem.isLeaf()) {
                    if (this.doc_offset_remaining > 0) {
                        --this.doc_offset_remaining;
                    } else if (this.doc_len_remaining > 0) {
                        --this.doc_len_remaining;
                    }
                }
                if (this.matchNameAttribute(attrSet, HTML.Tag.TITLE)) {
                    boolean fg_is_end_tag = false;
                    Enumeration<?> attrNameEnum = attrSet.getAttributeNames();
                    while (attrNameEnum.hasMoreElements()) {
                        Object key = attrNameEnum.nextElement();
                        Object value = attrSet.getAttribute(key);
                        if (key != HTML.Attribute.ENDTAG || !value.equals("true")) continue;
                        fg_is_end_tag = true;
                    }
                    if (fg_is_end_tag) {
                        this.writeRaw("</title>");
                    } else {
                        this.indent();
                        this.writeRaw("<title>");
                        String title_str = (String)this.htmlDoc.getProperty("title");
                        if (title_str != null) {
                            this.writeContent(title_str);
                        }
                    }
                } else if (this.matchNameAttribute(attrSet, HTML.Tag.PRE)) {
                    attrSet = paramElem.getAttributes();
                    this.indent();
                    this.writeRaw("<pre");
                    this.writeAttributes(attrSet);
                    this.writeRaw(">");
                    int child_elem_count = currElem.getElementCount();
                    int i = 0;
                    while (i < child_elem_count) {
                        Element childElem = paramElem.getElement(i);
                        this.traverseHtmlFragment(childElem);
                        ++i;
                    }
                    this.writeRaw("</pre>");
                } else if (this.matchNameAttribute(attrSet, HTML.Tag.SELECT)) {
                    this.selectContent(attrSet);
                } else if (this.matchNameAttribute(attrSet, HTML.Tag.TEXTAREA)) {
                    this.textAreaContent(attrSet);
                } else {
                    int child_elem_count = currElem.getElementCount();
                    if (child_elem_count > 0) {
                        this.startTag(currElem);
                        int i = 0;
                        while (i < child_elem_count) {
                            Element childElem = paramElem.getElement(i);
                            this.traverseHtmlFragment(childElem);
                            ++i;
                        }
                        this.endTag(currElem);
                    } else {
                        this.emptyTag(currElem);
                    }
                }
            }
        }
        if (paramElem == this.endElem) {
            this.fg_pass_end_elem = true;
        }
    }

    private void writeRaw(String param_str) throws IOException {
        super.output(param_str.toCharArray(), 0, param_str.length());
    }

    private void writeContent(String param_str) throws IOException {
        char[] str_char_arr = param_str.toCharArray();
        if (this.hasHtmlEntity(param_str)) {
            this.output(str_char_arr, 0, str_char_arr.length);
        } else {
            super.output(str_char_arr, 0, str_char_arr.length);
        }
    }

    private void writeAllAttributes(AttributeSet attrSet) throws IOException {
        Enumeration<?> attrNameEnum = attrSet.getAttributeNames();
        while (attrNameEnum.hasMoreElements()) {
            Object key = attrNameEnum.nextElement();
            Object value = attrSet.getAttribute(key);
            this.writeRaw(" " + key + "=\"" + value + "\"");
            this.writeRaw(" " + key.getClass().toString() + "=\"" + value.getClass().toString() + "\"");
        }
    }

    private boolean hasHtmlEntity(String param_str) {
        boolean ret_bool = false;
        int i = 0;
        while (i < this.html_entity_char_arr.length) {
            if (param_str.indexOf(this.html_entity_char_arr[i]) != -1) {
                ret_bool = true;
                break;
            }
            ++i;
        }
        return ret_bool;
    }

    private boolean isCharHtmlEntity(char param_char) {
        boolean ret_bool = false;
        int i = 0;
        while (i < this.html_entity_char_arr.length) {
            if (param_char == this.html_entity_char_arr[i]) {
                ret_bool = true;
                break;
            }
            ++i;
        }
        return ret_bool;
    }

    private String escapeCharHtmlEntity(char param_char) {
        String ret_str = "" + param_char;
        int i = 0;
        while (i < this.html_entity_char_arr.length) {
            if (param_char == this.html_entity_char_arr[i]) {
                ret_str = this.html_entity_escape_str_arr[i];
                break;
            }
            ++i;
        }
        return ret_str;
    }
}

