/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

import gnu.javax.imageio.jpeg.DCT;
import gnu.javax.imageio.jpeg.HuffmanTable;
import gnu.javax.imageio.jpeg.JPEGException;
import gnu.javax.imageio.jpeg.JPEGFrame;
import gnu.javax.imageio.jpeg.JPEGImageInputStream;
import gnu.javax.imageio.jpeg.JPEGMarkerFoundException;
import gnu.javax.imageio.jpeg.YCbCr_ColorSpace;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.stream.ImageInputStream;

public class JPEGDecoder {
    byte majorVersion;
    byte minorVersion;
    byte units;
    short Xdensity;
    short Ydensity;
    byte Xthumbnail;
    byte Ythumbnail;
    byte[] thumbnail;
    BufferedImage image;
    int width;
    int height;
    byte marker;
    public static final byte MAJOR_VERSION = 1;
    public static final byte MINOR_VERSION = 2;
    public static final short JFIF_FIXED_LENGTH = 16;
    public static final short JFXX_FIXED_LENGTH = 8;
    private JPEGImageInputStream jpegStream;
    ArrayList jpegFrames = new ArrayList();
    JPEGHuffmanTable[] dcTables = new JPEGHuffmanTable[4];
    JPEGHuffmanTable[] acTables = new JPEGHuffmanTable[4];
    JPEGQTable[] qTables = new JPEGQTable[4];

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public JPEGDecoder(ImageInputStream in) throws IOException, JPEGException {
        this.jpegStream = new JPEGImageInputStream(in);
        this.jpegStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        if (this.jpegStream.findNextMarker() != -40) {
            throw new JPEGException("Failed to find SOI marker.");
        }
        if (this.jpegStream.findNextMarker() != -32) {
            throw new JPEGException("Failed to find APP0 marker.");
        }
        short length = this.jpegStream.readShort();
        if (length < 16) {
            throw new JPEGException("Failed to find JFIF field.");
        }
        byte[] identifier = new byte[5];
        this.jpegStream.read(identifier);
        if (identifier[0] != 74 || identifier[1] != 70 || identifier[2] != 73 || identifier[3] != 70 || identifier[4] != 0) {
            throw new JPEGException("Failed to read JFIF identifier.");
        }
        this.majorVersion = this.jpegStream.readByte();
        this.minorVersion = this.jpegStream.readByte();
        if (this.majorVersion != 1 || this.majorVersion == 1 && this.minorVersion < 2) {
            throw new JPEGException("Unsupported JFIF version.");
        }
        this.units = this.jpegStream.readByte();
        if (this.units > 2) {
            throw new JPEGException("Units field is out of range.");
        }
        this.Xdensity = this.jpegStream.readShort();
        this.Ydensity = this.jpegStream.readShort();
        this.Xthumbnail = this.jpegStream.readByte();
        this.Ythumbnail = this.jpegStream.readByte();
        int thumbnailLength = 3 * this.Xthumbnail * this.Ythumbnail;
        if (length > 16 && thumbnailLength != length - 16) {
            throw new JPEGException("Invalid length, Xthumbnail or Ythumbnail field.");
        }
        if (thumbnailLength > 0) {
            this.thumbnail = new byte[thumbnailLength];
            if (this.jpegStream.read(this.thumbnail) != thumbnailLength) {
                throw new IOException("Failed to read thumbnail.");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void decode() throws IOException {
        System.out.println("DECODE!!!");
        frame = null;
        resetInterval = 0;
        marker = this.jpegStream.findNextMarker();
        this.decodeJFIFExtension();
        while (true) {
            block1 : switch (marker) {
                case -32: 
                case -31: 
                case -30: 
                case -29: 
                case -28: 
                case -27: 
                case -26: 
                case -25: 
                case -24: 
                case -23: 
                case -22: 
                case -21: 
                case -20: 
                case -19: 
                case -18: 
                case -17: {
                    this.jpegStream.skipBytes(this.jpegStream.readShort() - 2);
                    break;
                }
                case -64: {
                    this.jpegFrames.add(new JPEGFrame());
                    frame = (JPEGFrame)this.jpegFrames.get(this.jpegFrames.size() - 1);
                    this.jpegStream.readShort();
                    frame.setPrecision(this.jpegStream.readByte());
                    frame.setScanLines(this.jpegStream.readShort());
                    frame.setSamplesPerLine(this.jpegStream.readShort());
                    frame.setComponentCount(this.jpegStream.readByte());
                    if (frame.getComponentCount() == 1) {
                        frame.setColorMode((byte)1);
                    } else {
                        frame.setColorMode((byte)3);
                    }
                    i = 0;
                    while (i < frame.getComponentCount()) {
                        frame.addComponent(this.jpegStream.readByte(), this.jpegStream.readByte(), this.jpegStream.readByte());
                        ++i;
                    }
                    break;
                }
                case -62: {
                    this.jpegFrames.add(new JPEGFrame());
                    frame = (JPEGFrame)this.jpegFrames.get(this.jpegFrames.size() - 1);
                    this.jpegStream.readShort();
                    frame.setPrecision(this.jpegStream.readByte());
                    frame.setScanLines(this.jpegStream.readShort());
                    frame.setSamplesPerLine(this.jpegStream.readShort());
                    frame.setComponentCount(this.jpegStream.readByte());
                    if (frame.getComponentCount() == 1) {
                        frame.setColorMode((byte)1);
                    } else {
                        frame.setColorMode((byte)3);
                    }
                    i = 0;
                    while (i < frame.getComponentCount()) {
                        frame.addComponent(this.jpegStream.readByte(), this.jpegStream.readByte(), this.jpegStream.readByte());
                        ++i;
                    }
                    break;
                }
                case -60: {
                    index = huffmanLength = this.jpegStream.readShort() - 2;
                    while (index > 0) {
                        huffmanInfo = this.jpegStream.readByte();
                        tableClass = (byte)(huffmanInfo >> 4);
                        huffmanIndex = (byte)(huffmanInfo & 15);
                        codeLength = new short[16];
                        this.jpegStream.readFully(codeLength, 0, codeLength.length);
                        huffmanValueLen = 0;
                        i = 0;
                        while (i < 16) {
                            huffmanValueLen += codeLength[i];
                            ++i;
                        }
                        index -= huffmanValueLen + 17;
                        huffmanVal = new short[huffmanValueLen];
                        i = 0;
                        while (i < huffmanVal.length) {
                            huffmanVal[i] = this.jpegStream.readByte();
                            ++i;
                        }
                        if (tableClass == HuffmanTable.JPEG_DC_TABLE) {
                            this.dcTables[huffmanIndex] = new JPEGHuffmanTable(codeLength, huffmanVal);
                            continue;
                        }
                        if (tableClass != HuffmanTable.JPEG_AC_TABLE) continue;
                        this.acTables[huffmanIndex] = new JPEGHuffmanTable(codeLength, huffmanVal);
                    }
                    break;
                }
                case -37: {
                    quantizationLength = (short)(this.jpegStream.readShort() - 2);
                    j = 0;
                    while (j < quantizationLength / 65) {
                        quantSpecs = this.jpegStream.readByte();
                        quantData = new int[64];
                        if ((byte)(quantSpecs >> 4) == 0) {
                            i = 0;
                            while (i < 64) {
                                quantData[i] = this.jpegStream.readByte();
                                ++i;
                            }
                        } else if ((byte)(quantSpecs >> 4) == 1) {
                            i = 0;
                            while (i < 64) {
                                quantData[i] = this.jpegStream.readShort();
                                ++i;
                            }
                        }
                        this.qTables[quantSpecs & 15] = new JPEGQTable(quantData);
                        ++j;
                    }
                    break;
                }
                case -38: {
                    this.jpegStream.readShort();
                    numberOfComponents = this.jpegStream.readByte();
                    componentSelector = new byte[numberOfComponents];
                    i = 0;
                    while (i < numberOfComponents) {
                        componentID = this.jpegStream.readByte();
                        tableInfo = this.jpegStream.readByte();
                        frame.setHuffmanTables(componentID, this.acTables[(byte)(tableInfo >> 4)], this.dcTables[(byte)(tableInfo & 15)]);
                        componentSelector[i] = componentID;
                        ++i;
                    }
                    this.jpegStream.readByte();
                    this.jpegStream.readByte();
                    this.jpegStream.readByte();
                    mcuIndex = 0;
                    mcuTotalIndex = 0;
                    while (true) {
                        try {
                            while (true) {
                                compIndex = 0;
                                while (compIndex < numberOfComponents) {
                                    comp = frame.components.getComponentByID(componentSelector[compIndex]);
                                    comp.readComponentMCU(this.jpegStream);
                                    ++compIndex;
                                }
                                ++mcuIndex;
                                ++mcuTotalIndex;
                            }
                        }
                        catch (JPEGMarkerFoundException v0) {
                            if (marker != -48 && marker != -47 && marker != -46 && marker != -45 && marker != -44 && marker != -43 && marker != -42 && marker != -41) break block1;
                            compIndex = 0;
                            ** while (compIndex < numberOfComponents)
                        }
lbl-1000:
                        // 1 sources

                        {
                            comp = frame.components.getComponentByID(componentSelector[compIndex]);
                            if (compIndex > 1) {
                                comp.padMCU(mcuTotalIndex, resetInterval - mcuIndex);
                            }
                            comp.resetInterval();
                            ++compIndex;
                            continue;
                        }
lbl146:
                        // 1 sources

                        mcuTotalIndex += resetInterval - mcuIndex;
                        mcuIndex = 0;
                    }
                }
                case -35: {
                    this.jpegStream.skipBytes(2);
                    resetInterval = this.jpegStream.readShort();
                    break;
                }
                case -2: {
                    this.jpegStream.skipBytes(this.jpegStream.readShort() - 2);
                    break;
                }
                case -36: {
                    frame.setScanLines(this.jpegStream.readShort());
                    break;
                }
                case -39: {
                    if (this.jpegFrames.size() == 0) {
                        return;
                    }
                    if (this.jpegFrames.size() == 1) {
                        myDCT = new DCT();
                        raster = Raster.createInterleavedRaster(0, frame.width, frame.height, frame.getComponentCount(), new Point(0, 0));
                        i = 0;
                        while (i < frame.getComponentCount()) {
                            comp = frame.components.get(i);
                            comp.setQuantizationTable(this.qTables[comp.quant_id].getTable());
                            comp.quantitizeData();
                            comp.idctData(myDCT);
                            ++i;
                        }
                        i = 0;
                        while (i < frame.getComponentCount()) {
                            comp = frame.components.get(i);
                            comp.scaleByFactors();
                            comp.writeData(raster, i);
                            comp = null;
                            ++i;
                        }
                        if (frame.getComponentCount() == 1) {
                            cs = ColorSpace.getInstance(1003);
                            ccm = new ComponentColorModel(cs, false, false, 1, 0);
                            this.image = new BufferedImage(ccm, raster, false, new Hashtable<K, V>());
                        } else if (frame.getComponentCount() == 3) {
                            ccm = new ComponentColorModel(new YCbCr_ColorSpace(), false, false, 1, 0);
                            this.image = new BufferedImage(ccm, raster, false, new Hashtable<K, V>());
                        } else {
                            throw new JPEGException("Unsupported Color Mode: 4 Component Color Mode found.");
                        }
                        this.height = frame.height;
                        this.width = frame.width;
                        break;
                    }
                    throw new JPEGException("Unsupported Codec Type: Hierarchial JPEG");
                }
                case -63: {
                    throw new JPEGException("Unsupported Codec Type: Extended Sequential DCT JPEG's Not-Supported");
                }
                case -61: {
                    throw new JPEGException("Unsupported Codec Type: Lossless (sequential)");
                }
                case -59: {
                    throw new JPEGException("Unsupported Codec Type: Differential sequential DCT");
                }
                case -58: {
                    throw new JPEGException("Unsupported Codec Type: Differential progressive DCT");
                }
                case -57: {
                    throw new JPEGException("Unsupported Codec Type: Differential lossless");
                }
                case -55: 
                case -54: 
                case -53: 
                case -51: 
                case -50: 
                case -49: {
                    throw new JPEGException("Unsupported Codec Type: Arithmetic Coding Frame");
                }
            }
            marker = this.jpegStream.findNextMarker();
        }
    }

    private void decodeJFIFExtension() throws IOException {
        if (this.marker == -32) {
            short length = this.jpegStream.readShort();
            if (length >= 8) {
                byte[] identifier = new byte[5];
                this.jpegStream.read(identifier);
                if (identifier[0] != 74 || identifier[1] != 70 || identifier[2] != 70 || identifier[3] != 70 || identifier[4] != 0) {
                    this.jpegStream.skipBytes(length - 7);
                } else {
                    byte extension_code = this.jpegStream.readByte();
                    switch (extension_code) {
                        case 16: {
                            this.jpegStream.skipBytes(length - 8);
                        }
                        case 17: {
                            this.jpegStream.skipBytes(length - 8);
                        }
                        case 19: {
                            this.jpegStream.skipBytes(length - 8);
                        }
                    }
                }
            } else {
                this.jpegStream.skipBytes(length - 2);
            }
            this.marker = this.jpegStream.findNextMarker();
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

