/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    Timer enterTimer = new Timer(750, new insideTimerAction());
    Timer exitTimer;
    Timer insideTimer;
    private transient boolean enabled = true;
    protected boolean lightWeightPopupEnabled = true;
    protected boolean heavyWeightPopupEnabled = false;
    private static ToolTipManager shared;
    private JComponent currentComponent;
    private JToolTip currentTip;
    private String toolTipText;
    private Point currentPoint;
    private Popup popup;

    ToolTipManager() {
        this.enterTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
    }

    public static ToolTipManager sharedInstance() {
        if (shared == null) {
            shared = new ToolTipManager();
        }
        return shared;
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.enterTimer.stop();
            this.exitTimer.stop();
            this.insideTimer.stop();
        }
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setLightWeightPopupEnabled(boolean enabled) {
        this.lightWeightPopupEnabled = enabled;
        this.heavyWeightPopupEnabled = !enabled;
    }

    public int getInitialDelay() {
        return this.enterTimer.getDelay();
    }

    public void setInitialDelay(int delay) {
        this.enterTimer.setDelay(delay);
    }

    public int getDismissDelay() {
        return this.insideTimer.getDelay();
    }

    public void setDismissDelay(int delay) {
        this.insideTimer.setDelay(delay);
    }

    public int getReshowDelay() {
        return this.exitTimer.getDelay();
    }

    public void setReshowDelay(int delay) {
        this.exitTimer.setDelay(delay);
    }

    public void registerComponent(JComponent component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    public void unregisterComponent(JComponent component) {
        component.removeMouseMotionListener(this);
        component.removeMouseListener(this);
    }

    public void mouseEntered(MouseEvent event) {
        if (this.currentComponent != null && this.getContentPaneDeepestComponent(event) == this.currentComponent) {
            return;
        }
        this.currentPoint = event.getPoint();
        this.currentComponent = (JComponent)event.getSource();
        this.toolTipText = this.currentComponent.getToolTipText(event);
        if (this.exitTimer.isRunning()) {
            this.exitTimer.stop();
            this.showTip();
            return;
        }
        if (!this.enterTimer.isRunning()) {
            this.enterTimer.start();
        }
    }

    public void mouseExited(MouseEvent event) {
        if (this.getContentPaneDeepestComponent(event) == this.currentComponent) {
            return;
        }
        this.currentPoint = event.getPoint();
        this.currentComponent = null;
        this.hideTip();
        if (!this.enterTimer.isRunning()) {
            this.exitTimer.start();
        }
        if (this.enterTimer.isRunning()) {
            this.enterTimer.stop();
        }
        if (this.insideTimer.isRunning()) {
            this.insideTimer.stop();
        }
    }

    public void mousePressed(MouseEvent event) {
        this.currentPoint = event.getPoint();
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        } else if (this.insideTimer.isRunning()) {
            this.insideTimer.stop();
            this.hideTip();
        }
    }

    public void mouseDragged(MouseEvent event) {
        this.currentPoint = event.getPoint();
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        }
    }

    public void mouseMoved(MouseEvent event) {
        this.currentPoint = event.getPoint();
        if (this.currentTip != null && this.currentTip.isShowing()) {
            this.checkTipUpdate(event);
        } else if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        }
    }

    private void checkTipUpdate(MouseEvent ev) {
        JComponent comp = (JComponent)ev.getSource();
        String newText = comp.getToolTipText(ev);
        String oldText = this.toolTipText;
        if (newText != null) {
            if (newText != null && newText.equals(oldText) || newText == null) {
                if (this.popup == null) {
                    this.enterTimer.restart();
                } else {
                    this.insideTimer.restart();
                }
            } else {
                this.toolTipText = newText;
                this.hideTip();
                this.showTip();
                this.exitTimer.stop();
            }
        } else {
            this.currentTip = null;
            this.currentPoint = null;
            this.hideTip();
            this.enterTimer.stop();
            this.exitTimer.stop();
        }
    }

    void showTip() {
        if (!(this.enabled && this.currentComponent != null && this.currentComponent.isEnabled() && this.currentComponent.isShowing())) {
            this.popup = null;
            return;
        }
        if (this.currentTip == null || this.currentTip.getComponent() != this.currentComponent) {
            this.currentTip = this.currentComponent.createToolTip();
        }
        this.currentTip.setTipText(this.toolTipText);
        Point p = this.currentPoint;
        Point cP = this.currentComponent.getLocationOnScreen();
        Dimension dims = this.currentTip.getPreferredSize();
        JLayeredPane pane = null;
        JRootPane r = (JRootPane)SwingUtilities.getAncestorOfClass(JRootPane.class, this.currentComponent);
        if (r != null) {
            pane = r.getLayeredPane();
        }
        if (pane == null) {
            return;
        }
        p.translate(cP.x, cP.y);
        this.adjustLocation(p, pane, dims);
        this.currentTip.setBounds(0, 0, dims.width, dims.height);
        PopupFactory factory = PopupFactory.getSharedInstance();
        this.popup = factory.getPopup(this.currentComponent, this.currentTip, p.x, p.y);
        this.popup.show();
    }

    private Point adjustLocation(Point p, Component c, Dimension d) {
        if (p.x + d.width > c.getWidth()) {
            p.x -= d.width;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y + d.height < c.getHeight()) {
            p.y += d.height;
        }
        if (p.y + d.height > c.getHeight()) {
            p.y -= d.height;
        }
        return p;
    }

    void hideTip() {
        if (this.popup != null) {
            this.popup.hide();
        }
    }

    private Component getContentPaneDeepestComponent(MouseEvent e) {
        Component source = (Component)e.getSource();
        Container parent = SwingUtilities.getAncestorOfClass(JRootPane.class, this.currentComponent);
        if (parent == null) {
            return null;
        }
        parent = ((JRootPane)parent).getContentPane();
        Point p = e.getPoint();
        p = SwingUtilities.convertPoint(source, p, parent);
        Component target = SwingUtilities.getDeepestComponentAt(parent, p.x, p.y);
        return target;
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        public void actionPerformed(ActionEvent event) {
            ToolTipManager.this.showTip();
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        protected stillInsideTimerAction() {
        }

        public void actionPerformed(ActionEvent event) {
            ToolTipManager.this.hideTip();
        }
    }
}

