/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakHashMap<K, V>
extends AbstractMap<K, V> {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final Object NULL_KEY = new Object(){

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return o == null || this == o;
        }
    };
    private final ReferenceQueue queue;
    int size;
    private float loadFactor;
    private int threshold;
    int modCount;
    private final WeakEntrySet theEntrySet;
    WeakBucket[] buckets;

    public WeakHashMap() {
        this(11, 0.75f);
    }

    public WeakHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.theEntrySet = new WeakEntrySet();
        this.queue = new ReferenceQueue();
        this.buckets = new WeakBucket[initialCapacity];
    }

    public WeakHashMap(Map<? extends K, ? extends V> m) {
        this(m.size(), 0.75f);
        this.putAll(m);
    }

    private int hash(Object key) {
        return Math.abs(key.hashCode() % this.buckets.length);
    }

    void cleanQueue() {
        Reference bucket = this.queue.poll();
        while (bucket != null) {
            this.internalRemove((WeakBucket)bucket);
            bucket = this.queue.poll();
        }
    }

    private void rehash() {
        WeakBucket[] oldBuckets = this.buckets;
        int newsize = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)newsize * this.loadFactor);
        this.buckets = new WeakBucket[newsize];
        int i = 0;
        while (i < oldBuckets.length) {
            WeakBucket bucket = oldBuckets[i];
            while (bucket != null) {
                WeakBucket nextBucket = bucket.next;
                Object key = bucket.get();
                if (key == null) {
                    bucket.slot = -1;
                    --this.size;
                } else {
                    int slot;
                    bucket.slot = slot = this.hash(key);
                    bucket.next = this.buckets[slot];
                    this.buckets[slot] = bucket;
                }
                bucket = nextBucket;
            }
            ++i;
        }
    }

    private WeakBucket.WeakEntry internalGet(Object key) {
        if (key == null) {
            key = NULL_KEY;
        }
        int slot = this.hash(key);
        WeakBucket bucket = this.buckets[slot];
        while (bucket != null) {
            WeakBucket.WeakEntry entry = bucket.getEntry();
            if (entry != null && WeakHashMap.equals(key, entry.key)) {
                return entry;
            }
            bucket = bucket.next;
        }
        return null;
    }

    private void internalAdd(Object key, Object value) {
        if (key == null) {
            key = NULL_KEY;
        }
        int slot = this.hash(key);
        WeakBucket<Object, Object> bucket = new WeakBucket<Object, Object>(key, this.queue, value, slot);
        bucket.next = this.buckets[slot];
        this.buckets[slot] = bucket;
        ++this.size;
    }

    void internalRemove(WeakBucket bucket) {
        int slot = bucket.slot;
        if (slot == -1) {
            return;
        }
        bucket.slot = -1;
        WeakBucket prev = null;
        WeakBucket next = this.buckets[slot];
        while (next != bucket) {
            if (next == null) {
                throw new InternalError("WeakHashMap in incosistent state");
            }
            prev = next;
            next = prev.next;
        }
        if (prev == null) {
            this.buckets[slot] = bucket.next;
        } else {
            prev.next = bucket.next;
        }
        --this.size;
    }

    @Override
    public int size() {
        this.cleanQueue();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        this.cleanQueue();
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        this.cleanQueue();
        return this.internalGet(key) != null;
    }

    @Override
    public V get(Object key) {
        this.cleanQueue();
        WeakBucket.WeakEntry entry = this.internalGet(key);
        return entry == null ? null : (V)entry.getValue();
    }

    @Override
    public V put(K key, V value) {
        this.cleanQueue();
        WeakBucket.WeakEntry entry = this.internalGet(key);
        if (entry != null) {
            return entry.setValue(value);
        }
        ++this.modCount;
        if (this.size >= this.threshold) {
            this.rehash();
        }
        this.internalAdd(key, value);
        return null;
    }

    @Override
    public V remove(Object key) {
        this.cleanQueue();
        WeakBucket.WeakEntry entry = this.internalGet(key);
        if (entry == null) {
            return null;
        }
        ++this.modCount;
        this.internalRemove(entry.getBucket());
        return entry.getValue();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.cleanQueue();
        return this.theEntrySet;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        this.cleanQueue();
        return super.containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        this.cleanQueue();
        return super.keySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        super.putAll(m);
    }

    @Override
    public Collection<V> values() {
        this.cleanQueue();
        return super.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakBucket<K, V>
    extends WeakReference<K> {
        V value;
        WeakBucket<K, V> next;
        int slot;

        public WeakBucket(K key, ReferenceQueue queue, V value, int slot) {
            super(key, queue);
            this.value = value;
            this.slot = slot;
        }

        WeakEntry getEntry() {
            Object key = this.get();
            if (key == null) {
                return null;
            }
            return new WeakEntry(key);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WeakEntry
        implements Map.Entry<K, V> {
            K key;

            public WeakEntry(K key) {
                this.key = key;
            }

            public WeakBucket getBucket() {
                return WeakBucket.this;
            }

            @Override
            public K getKey() {
                return this.key == NULL_KEY ? null : (Object)this.key;
            }

            @Override
            public V getValue() {
                return WeakBucket.this.value;
            }

            @Override
            public V setValue(V newVal) {
                Object oldVal = WeakBucket.this.value;
                WeakBucket.this.value = newVal;
                return oldVal;
            }

            @Override
            public int hashCode() {
                return this.key.hashCode() ^ WeakHashMap.hashCode(WeakBucket.this.value);
            }

            @Override
            public boolean equals(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    return WeakHashMap.equals(this.getKey(), e.getKey()) && WeakHashMap.equals(WeakBucket.this.value, e.getValue());
                }
                return false;
            }

            public String toString() {
                return this.getKey() + "=" + WeakBucket.this.value;
            }
        }
    }

    private final class WeakEntrySet
    extends AbstractSet {
        WeakEntrySet() {
        }

        public int size() {
            return WeakHashMap.this.size;
        }

        public Iterator iterator() {
            return new Iterator(){
                WeakBucket.WeakEntry lastEntry;
                WeakBucket.WeakEntry nextEntry = this.findNext(null);
                int knownMod;
                {
                    this.knownMod = ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.modCount;
                }

                private void checkMod() {
                    WeakHashMap.this.cleanQueue();
                    if (this.knownMod != ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.modCount) {
                        throw new ConcurrentModificationException(String.valueOf(this.knownMod) + " != " + ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.modCount);
                    }
                }

                private WeakBucket.WeakEntry findNext(WeakBucket.WeakEntry lastEntry) {
                    int slot;
                    WeakBucket nextBucket;
                    if (lastEntry != null) {
                        nextBucket = lastEntry.getBucket().next;
                        slot = lastEntry.getBucket().slot;
                    } else {
                        nextBucket = ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.buckets[0];
                        slot = 0;
                    }
                    while (true) {
                        if (nextBucket != null) {
                            WeakBucket.WeakEntry entry = nextBucket.getEntry();
                            if (entry != null) {
                                return entry;
                            }
                            nextBucket = nextBucket.next;
                            continue;
                        }
                        if (++slot == ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.buckets.length) {
                            return null;
                        }
                        nextBucket = ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.buckets[slot];
                    }
                }

                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                public Object next() {
                    this.checkMod();
                    if (this.nextEntry == null) {
                        throw new NoSuchElementException();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.findNext(this.lastEntry);
                    return this.lastEntry;
                }

                public void remove() {
                    this.checkMod();
                    if (this.lastEntry == null) {
                        throw new IllegalStateException();
                    }
                    ++((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.modCount;
                    WeakHashMap.this.internalRemove(this.lastEntry.getBucket());
                    this.lastEntry = null;
                    ++this.knownMod;
                }
            };
        }
    }
}

