/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;

public final class TextMeasurer
implements Cloneable {
    private AttributedCharacterIterator text;
    private FontRenderContext frc;
    private TextLayout totalLayout;
    private int numChars;

    public TextMeasurer(AttributedCharacterIterator text, FontRenderContext frc) {
        this.text = text;
        this.frc = frc;
        this.totalLayout = new TextLayout(text, frc);
        this.numChars = this.totalLayout.getCharacterCount();
    }

    protected Object clone() {
        return new TextMeasurer(this.text, this.frc);
    }

    public void deleteChar(AttributedCharacterIterator newParagraph, int deletePos) {
        this.totalLayout = new TextLayout(newParagraph, this.frc);
        if (deletePos < 0 || deletePos > this.totalLayout.getCharacterCount()) {
            throw new NullPointerException("Invalid deletePos:" + deletePos);
        }
        this.numChars = this.totalLayout.getCharacterCount();
        this.text = newParagraph;
    }

    public void insertChar(AttributedCharacterIterator newParagraph, int insertPos) {
        this.totalLayout = new TextLayout(newParagraph, this.frc);
        if (insertPos < 0 || insertPos > this.totalLayout.getCharacterCount()) {
            throw new NullPointerException("Invalid insertPos:" + insertPos);
        }
        this.numChars = this.totalLayout.getCharacterCount();
        this.text = newParagraph;
    }

    public float getAdvanceBetween(int start, int limit) {
        Shape s = this.totalLayout.getLogicalHighlightShape(start, limit);
        return (float)s.getBounds2D().getWidth();
    }

    public TextLayout getLayout(int start, int limit) {
        if (start >= limit) {
            throw new IllegalArgumentException("Start position must be < limit.");
        }
        return new TextLayout(this.totalLayout, start, limit);
    }

    public int getLineBreakIndex(int start, float maxAdvance) {
        double guessLength;
        if (start < 0) {
            throw new IllegalArgumentException("Start parameter must be > 0.");
        }
        double remainingLength = this.getAdvanceBetween(start, this.numChars);
        int guessOffset = (int)((double)maxAdvance / remainingLength * ((double)this.numChars - (double)start));
        if ((guessOffset += start) > this.numChars) {
            guessOffset = this.numChars;
        }
        boolean makeSmaller = (guessLength = (double)this.getAdvanceBetween(start, guessOffset)) > (double)maxAdvance;
        int inc = makeSmaller ? -1 : 1;
        boolean keepGoing = true;
        do {
            if ((guessOffset += inc) <= start || guessOffset > this.numChars) {
                keepGoing = false;
                continue;
            }
            guessLength = this.getAdvanceBetween(start, guessOffset);
            if (makeSmaller && guessLength <= (double)maxAdvance) {
                keepGoing = false;
            }
            if (makeSmaller || !(guessLength >= (double)maxAdvance)) continue;
            keepGoing = false;
        } while (keepGoing);
        if (!makeSmaller) {
            --guessOffset;
        }
        if (guessOffset > this.numChars) {
            return this.numChars;
        }
        return guessOffset;
    }
}

