/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.loader;

import gnu.java.net.IndexListParser;
import gnu.java.net.loader.JarURLResource;
import gnu.java.net.loader.Resource;
import gnu.java.net.loader.URLLoader;
import gnu.java.net.loader.URLStreamHandlerCache;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JarURLLoader
extends URLLoader {
    boolean initialized;
    JarFile jarfile;
    final URL baseJarURL;
    ArrayList<URLLoader> classPath;
    Set indexSet;

    private JarURLLoader(URLClassLoader classloader, URLStreamHandlerCache cache, URLStreamHandlerFactory factory, URL baseURL, URL absoluteUrl, Set indexSet) {
        super(classloader, cache, factory, baseURL, absoluteUrl);
        URL newBaseURL = null;
        try {
            String base = String.valueOf(baseURL.toExternalForm()) + "!/";
            newBaseURL = new URL("jar", "", -1, base, cache.get(factory, "jar"));
        }
        catch (MalformedURLException malformedURLException) {}
        this.baseJarURL = newBaseURL;
        this.classPath = null;
        this.indexSet = indexSet;
    }

    public JarURLLoader(URLClassLoader classloader, URLStreamHandlerCache cache, URLStreamHandlerFactory factory, URL baseURL, URL absoluteUrl) {
        this(classloader, cache, factory, baseURL, absoluteUrl, null);
        this.initialize();
    }

    private void initialize() {
        JarFile jarfile = null;
        try {
            jarfile = ((JarURLConnection)this.baseJarURL.openConnection()).getJarFile();
            IndexListParser parser = new IndexListParser(jarfile, this.baseJarURL, this.baseURL);
            LinkedHashMap<URL, Set<String>> indexMap = parser.getHeaders();
            if (indexMap != null) {
                this.classPath = new ArrayList();
                for (Map.Entry entry : indexMap.entrySet()) {
                    URL subURL = (URL)entry.getKey();
                    Set prefixes = (Set)entry.getValue();
                    if (subURL.equals(this.baseURL)) {
                        this.indexSet = prefixes;
                        continue;
                    }
                    JarURLLoader subLoader = new JarURLLoader(this.classloader, this.cache, this.factory, subURL, subURL, prefixes);
                    this.classPath.add(subLoader);
                }
            } else {
                String classPathString;
                Attributes attributes;
                Manifest manifest = jarfile.getManifest();
                if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (classPathString = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                    this.classPath = new ArrayList();
                    StringTokenizer st = new StringTokenizer(classPathString, " ");
                    while (st.hasMoreElements()) {
                        String e = st.nextToken();
                        try {
                            URL subURL = new URL(this.baseURL, e);
                            if (subURL.equals(this.baseURL)) continue;
                            JarURLLoader subLoader = new JarURLLoader(this.classloader, this.cache, this.factory, subURL, subURL);
                            this.classPath.add(subLoader);
                            ArrayList<URLLoader> extra = subLoader.getClassPath();
                            if (extra == null) continue;
                            this.classPath.addAll(extra);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                }
            }
        }
        catch (IOException iOException) {}
        this.jarfile = jarfile;
        this.initialized = true;
    }

    @Override
    public Resource getResource(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (this.indexSet != null) {
            String basename = name;
            int offset = basename.lastIndexOf(47);
            if (offset != -1) {
                basename = basename.substring(0, offset);
            }
            if (!this.indexSet.contains(basename)) {
                return null;
            }
        }
        if (!this.initialized) {
            this.initialize();
        }
        if (this.jarfile == null) {
            return null;
        }
        JarEntry je = this.jarfile.getJarEntry(name);
        if (je != null) {
            return new JarURLResource(this, name, je);
        }
        return null;
    }

    @Override
    public Manifest getManifest() {
        try {
            return this.jarfile == null ? null : this.jarfile.getManifest();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public ArrayList<URLLoader> getClassPath() {
        return this.classPath;
    }
}

