/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkWindowPeer;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.peer.FramePeer;
import java.awt.peer.MenuBarPeer;

public class GtkFramePeer
extends GtkWindowPeer
implements FramePeer {
    private int menuBarHeight;
    private MenuBarPeer menuBar;

    native int getMenuBarHeight(MenuBarPeer var1);

    native void setMenuBarWidthUnlocked(MenuBarPeer var1, int var2);

    native void setMenuBarWidth(MenuBarPeer var1, int var2);

    native void setMenuBarPeer(MenuBarPeer var1);

    native void removeMenuBarPeer();

    native void gtkFixedSetVisible(boolean var1);

    private native void maximize();

    private native void unmaximize();

    private native void iconify();

    private native void deiconify();

    int getMenuBarHeight() {
        return this.menuBar == null ? 0 : this.getMenuBarHeight(this.menuBar);
    }

    public void setMenuBar(MenuBar bar) {
        if (bar == null && this.menuBar != null) {
            this.gtkFixedSetVisible(false);
            this.menuBar = null;
            this.removeMenuBarPeer();
            this.insets.top -= this.menuBarHeight;
            this.menuBarHeight = 0;
            if (this.awtComponent.isValid()) {
                this.awtComponent.validate();
            }
            this.gtkFixedSetVisible(true);
        } else if (bar != null && this.menuBar == null) {
            this.gtkFixedSetVisible(false);
            this.menuBar = (MenuBarPeer)bar.getPeer();
            this.setMenuBarPeer(this.menuBar);
            int menuBarWidth = this.awtComponent.getWidth() - this.insets.left - this.insets.right;
            if (menuBarWidth > 0) {
                this.setMenuBarWidth(this.menuBar, menuBarWidth);
            }
            this.menuBarHeight = this.getMenuBarHeight();
            this.insets.top += this.menuBarHeight;
            if (this.awtComponent.isValid()) {
                this.awtComponent.validate();
            }
            this.gtkFixedSetVisible(true);
        } else if (bar != null && this.menuBar != null) {
            this.gtkFixedSetVisible(false);
            this.removeMenuBarPeer();
            int oldHeight = this.menuBarHeight;
            int menuBarWidth = this.awtComponent.getWidth() - this.insets.left - this.insets.right;
            this.menuBar = (MenuBarPeer)bar.getPeer();
            this.setMenuBarPeer(this.menuBar);
            if (menuBarWidth > 0) {
                this.setMenuBarWidth(this.menuBar, menuBarWidth);
            }
            this.menuBarHeight = this.getMenuBarHeight();
            if (oldHeight != this.menuBarHeight) {
                this.insets.top += this.menuBarHeight - oldHeight;
                this.awtComponent.validate();
            }
            this.gtkFixedSetVisible(true);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        int menuBarWidth = width - this.insets.left - this.insets.right;
        if (this.menuBar != null && menuBarWidth > 0) {
            this.setMenuBarWidth(this.menuBar, menuBarWidth);
        }
        super.setBounds(x, y, width, height + this.menuBarHeight);
    }

    public void setResizable(boolean resizable) {
        this.setSize(this.awtComponent.getWidth() - this.insets.left - this.insets.right, this.awtComponent.getHeight() - this.insets.top - this.insets.bottom + this.menuBarHeight);
        this.gtkWindowSetResizable(resizable);
    }

    protected void postInsetsChangedEvent(int top, int left, int bottom, int right) {
        this.insets.top = top + this.menuBarHeight;
        this.insets.left = left;
        this.insets.bottom = bottom;
        this.insets.right = right;
    }

    public GtkFramePeer(Frame frame) {
        super(frame);
    }

    void create() {
        this.create(0, !((Frame)this.awtComponent).isUndecorated());
        Frame frame = (Frame)this.awtComponent;
        this.setMenuBar(frame.getMenuBar());
        this.setTitle(frame.getTitle());
        this.gtkWindowSetResizable(frame.isResizable());
        this.setIconImage(frame.getIconImage());
    }

    native void nativeSetIconImage(GtkImage var1);

    public void setIconImage(Image image) {
        if (image != null) {
            GtkImage gtkImage = image instanceof GtkImage ? (GtkImage)image : new GtkImage(image.getSource());
            if (gtkImage.isLoaded && !gtkImage.errorLoading) {
                this.nativeSetIconImage(gtkImage);
            }
        }
    }

    protected void postConfigureEvent(int x, int y, int width, int height) {
        if (this.menuBar != null && width > 0) {
            this.setMenuBarWidthUnlocked(this.menuBar, width);
        }
        int frame_height = height - this.menuBarHeight;
        int frame_y = y + this.menuBarHeight;
        super.postConfigureEvent(x, frame_y, width, frame_height);
    }

    public int getState() {
        return this.windowState;
    }

    public void setState(int state) {
        switch (state) {
            case 0: {
                if ((this.windowState & 1) != 0) {
                    this.deiconify();
                }
                if ((this.windowState & 6) == 0) break;
                this.unmaximize();
                break;
            }
            case 1: {
                this.iconify();
                break;
            }
            case 6: {
                this.maximize();
            }
        }
    }

    public void setMaximizedBounds(Rectangle r) {
    }

    public void setBoundsPrivate(int x, int y, int width, int height) {
    }

    public boolean requestWindowFocus() {
        return false;
    }

    public Rectangle getBoundsPrivate() {
        throw new InternalError("Not yet implemented");
    }
}

