<?php
/*
* SITESEO
* https://siteseo.io
* (c) SiteSEO Team
*/

namespace SiteSEOPro;

if(!defined('ABSPATH')){
	die('Hacking Attempt !');
}

class RssSitemap{

	static function settings(){
		global $siteseo;
		
		if(!empty($siteseo->pro['enable_rss_sitemap']) && !empty($siteseo->pro['toogle_state_rss_sitemap'])){
			self::sitemap_init();
		}
		
	}
	
	static function sitemap_init(){
		add_filter('query_vars', function($vars){
			$vars[] = 'sitemap-stylesheet';
			return $vars;
		});
	}
	
	static function add_rewrite_rules(){
		add_rewrite_rule('^sitemap\.rss$', 'index.php?sitemap-stylesheet=rss', 'top');
		add_rewrite_rule('^sitemap-rss\.xsl$', 'index.php?sitemap-stylesheet=rss&sitemap-xsl=1', 'top');
		flush_rewrite_rules();
	}
	
	static function handle_sitemap_requests(){
		global $siteseo;
				
		if(get_query_var('sitemap-stylesheet') === 'rss'){
			
			if(isset($_GET['sitemap-stylesheet']) && $_GET['sitemap-stylesheet'] === 'rss'){
				self::sitemap_rss_xsl();
				exit;
			}
			
			self::generate_rss_sitemap();
			exit;
		}
		
	}

	static function generate_rss_sitemap(){
		global $siteseo;
		
		header('Content-Type: text/xml; charset=UTF-8');
		
		$xsl_url = home_url('/?sitemap-stylesheet=rss');
    
		echo'<?xml version="1.0" encoding="UTF-8"?>
<?xml-stylesheet type="text/xsl" href="'.esc_url($xsl_url).'"?>
<rss version="2.0" xmlns:atom="http://www.w3.org/2005/Atom">';

		
		$numberposts = !empty($siteseo->pro['rss_sitemap_limt']) ? $siteseo->pro['rss_sitemap_limt'] : 50;
		$post_types = !empty($siteseo->pro['rss_sitemap_posts']) ? $siteseo->pro['rss_sitemap_posts'] : [];
		
		$posts = get_posts([
			'post_type' => $post_types,
			'post_status' => 'publish',
			'numberposts' => $numberposts,
			'order' => 'DESC',
			'orderby' => 'date',
			'has_password' => false,
			'no_found_rows' => true,
			'lang' => 'all',
			'meta_query' => [
				[
					'key' => '_siteseo_robots_index',
					'compare' => 'NOT EXISTS'
				]
			]
		]);
		
		echo'<channel>
		<title>'.esc_html(get_bloginfo('name')).' RSS Sitemap</title>
		<link>'.esc_url(home_url()).'</link>
		<description>'.esc_html(get_bloginfo('description')).'</description>
		<language>'.esc_html(get_bloginfo('language')).'</language>
		<atom:link href="'.esc_url(home_url('/sitemap.rss')).'" rel="self" type="application/rss+xml" />';

		foreach($posts as $post){
			echo'<item>
				<title>'.esc_html(get_the_title($post)).'</title>
				<link>'.esc_url(get_permalink($post)).'</link>
				<pubDate>'.esc_html(get_the_modified_date('c', $post->ID)).'</pubDate>
				<guid isPermaLink="true">'.esc_url(get_permalink($post)).'</guid>
				<description><![CDATA['.esc_html(wp_strip_all_tags(get_the_excerpt($post))).']]></description>
			</item>';
		}
		
		echo'</channel>
		</rss>';
		exit;
	}

    static function sitemap_rss_xsl(){
        $title = __('RSS Sitemap', 'siteseo-pro');
        $generated_by = __('Generated by SiteSEO', 'siteseo-pro');
        $sitemap_count_txt = __('This RSS Sitemap contains', 'siteseo-pro');
        $last_modified_txt = __('Last Modified', 'siteseo-pro');
        
        header('Content-Type: application/xml; charset=UTF-8');

        echo'<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
    xmlns:html="http://www.w3.org/TR/REC-html40"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
    <xsl:template match="/">
        <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <title>'.esc_xml($title).'</title>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                <style>
                    * {
                        box-sizing: border-box;
                    }
                    body{
                        font-family: "Roboto", sans-serif;
                        background-color: #f0f2f5;
                        margin: 0;
                        padding: 0;
                        overflow-x: hidden;
                    }
                    header{
                        background: linear-gradient(135deg, #022448, #034f84);
                        padding: 20px;
                        color: #ffffff;
                        text-align: center;
                        width: 100%;
                        margin-bottom:15px;
                    }
                    header h1{
                        font-size: 32px;
                        margin: 0;
                    }
                    header p{
                        margin: 5px 0 0;
                        font-size: 16px;
                        text-decoration: underline;
                    }
                    .siteseo-sitemap-container{
                        width: 60%;
                        padding: 20px;
                        background-color: #ffffff;
                        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
                        border-radius: 8px;
                        margin: 0 auto;
                        overflow: auto;
                    }
                    .siteseo-sitemap-container a{
                        color:#007bff;
                        text-decoration: none;
                    }
                    table{
                        width: 100%;
                        border-collapse: collapse;
                    }
                    table thead tr{
                        background-color: #034f84;
                        color: #ffffff;
                    }
                    table th, table td{
                        padding: 10px;
                        text-align: left;
                        border: 1px solid #ddd;
                    }
                    table tbody tr:nth-child(even){
                        background-color: #f9f9f9;
                    }
                </style>
            </head>
            <body>
                <header>
                    <h1>'.esc_xml($title).'</h1>
                    <span>'.esc_xml($generated_by).'</span>
                    <div class="siteseo-description" style="text-align:center;">'.esc_xml($sitemap_count_txt).' <xsl:value-of select="count(rss/channel/item)"/> URLs</div>
                </header>
                <div class="siteseo-sitemap-container">
                    <table>
                        <thead>
                            <tr>
                                <th>URL</th>
                                <th>'.esc_xml($last_modified_txt).'</th>
                            </tr>
                        </thead>
                        <tbody>
                            <xsl:for-each select="rss/channel/item">
                                <tr>
                                    <td><a href="{link}"><xsl:value-of select="link"/></a></td>
                                    <td><xsl:value-of select="pubDate"/></td>
                                </tr>
                            </xsl:for-each>
                        </tbody>
                    </table>
                </div>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>';
    }
}