/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.ls.WriterOutputStream;
import gnu.xml.transform.SAXSerializer;
import gnu.xml.transform.StreamSerializer;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TransformerFactoryImpl;
import gnu.xml.transform.TransformerOutputProperties;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

class TransformerImpl
extends Transformer {
    final TransformerFactoryImpl factory;
    final Stylesheet stylesheet;
    URIResolver uriResolver;
    ErrorListener errorListener;
    Properties outputProperties;
    static final String INDENT_WHITESPACE = "  ";

    TransformerImpl(TransformerFactoryImpl factory, Stylesheet stylesheet, Properties outputProperties) throws TransformerConfigurationException {
        this.factory = factory;
        this.uriResolver = factory.userResolver;
        this.errorListener = factory.userListener;
        this.stylesheet = stylesheet;
        this.outputProperties = outputProperties;
        if (stylesheet != null) {
            stylesheet.bindings.push(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void transform(Source xmlSource, Result outputTarget) throws TransformerException {
        var4_3 = this.factory.resolver;
        synchronized (var4_3) {
            this.factory.resolver.setUserResolver(this.uriResolver);
            this.factory.resolver.setUserListener(this.errorListener);
            source = this.factory.resolver.resolveDOM(xmlSource, null, null);
        }
        context = source.getNode();
        v1 = doc = context instanceof Document != false ? (Document)context : context.getOwnerDocument();
        if (doc instanceof DomDocument) {
            ((DomDocument)doc).setBuilding(true);
        }
        parent = null;
        nextSibling = null;
        if (outputTarget instanceof DOMResult) {
            dr = (DOMResult)outputTarget;
            parent = dr.getNode();
            nextSibling = dr.getNextSibling();
            v2 = rdoc = parent instanceof Document != false ? (Document)parent : parent.getOwnerDocument();
            if (rdoc instanceof DomDocument) {
                drdoc = (DomDocument)rdoc;
                drdoc.setBuilding(true);
                drdoc.setCheckWellformedness(false);
            }
        }
        created = false;
        if (this.stylesheet != null) {
            if (parent == null) {
                resultDoc = new DomDocument();
                resultDoc.setBuilding(true);
                resultDoc.setCheckWellformedness(false);
                parent = resultDoc;
                created = true;
            }
            context = context.cloneNode(true);
            TransformerImpl.strip(this.stylesheet, context);
            try {
                ((TransformerOutputProperties)this.outputProperties).apply();
                this.stylesheet.initTopLevelVariables(context);
                t = this.stylesheet.getTemplate(null, context, false);
                if (t == null) ** GOTO lbl71
                this.stylesheet.current = context;
                t.apply(this.stylesheet, null, context, 1, 1, parent, nextSibling);
            }
            catch (TransformerException e) {
                if (doc instanceof DomDocument) {
                    ((DomDocument)doc).setBuilding(false);
                }
                throw e;
            }
        } else {
            clone = context.cloneNode(true);
            if (context.getNodeType() != 9) {
                if (parent == null) {
                    rd = new DomDocument();
                    rd.setBuilding(true);
                    rd.setCheckWellformedness(false);
                    resultDoc = rd;
                    parent = resultDoc;
                    created = true;
                } else {
                    resultDoc = parent instanceof Document != false ? (Document)parent : parent.getOwnerDocument();
                }
                sourceDoc = context.getOwnerDocument();
                if (sourceDoc != resultDoc) {
                    clone = resultDoc.adoptNode(clone);
                }
                if (nextSibling != null) {
                    parent.insertBefore(clone, nextSibling);
                } else {
                    parent.appendChild(clone);
                }
            } else {
                parent = clone;
                created = true;
            }
        }
lbl71:
        // 5 sources

        outputMethod = "html".equals(method = this.outputProperties.getProperty("method")) != false ? 1 : ("text".equals(method) != false ? 2 : 0);
        encoding = this.outputProperties.getProperty("encoding");
        publicId = this.outputProperties.getProperty("doctype-public");
        systemId = this.outputProperties.getProperty("doctype-system");
        version = this.outputProperties.getProperty("version");
        omitXmlDeclaration = "yes".equals(this.outputProperties.getProperty("omit-xml-declaration"));
        standalone = "yes".equals(this.outputProperties.getProperty("standalone"));
        mediaType = this.outputProperties.getProperty("media-type");
        cdataSectionElements = this.outputProperties.getProperty("cdata-section-elements");
        indent = "yes".equals(this.outputProperties.getProperty("indent"));
        if (created && parent instanceof DomDocument) {
            resultDoc = (DomDocument)parent;
            root = resultDoc.getDocumentElement();
            if ((publicId != null || systemId != null) && root != null) {
                doctype = new DomDoctype((DomDocument)resultDoc, root.getNodeName(), publicId, systemId);
                resultDoc.insertBefore(doctype, root);
            }
            resultDoc.setBuilding(false);
            resultDoc.setCheckWellformedness(true);
        } else if (publicId != null || systemId != null) {
            switch (parent.getNodeType()) {
                case 9: 
                case 11: {
                    resultDoc = parent instanceof Document != false ? (Document)parent : parent.getOwnerDocument();
                    impl = resultDoc.getImplementation();
                    root = resultDoc.getDocumentElement();
                    if (root == null) break;
                    doctype = impl.createDocumentType(root.getNodeName(), publicId, systemId);
                    resultDoc.insertBefore(doctype, root);
                }
            }
        }
        if (version != null) {
            parent.setUserData("version", version, this.stylesheet);
        }
        if (omitXmlDeclaration) {
            parent.setUserData("omit-xml-declaration", "yes", this.stylesheet);
        }
        if (standalone) {
            parent.setUserData("standalone", "yes", this.stylesheet);
        }
        if (mediaType != null) {
            parent.setUserData("media-type", mediaType, this.stylesheet);
        }
        if (cdataSectionElements != null) {
            list = new LinkedList<T>();
            st = new StringTokenizer(cdataSectionElements);
            while (st.hasMoreTokens()) {
                localName = name = st.nextToken();
                uri = null;
                prefix = null;
                ci = name.indexOf(58);
                if (ci != -1) {
                    prefix = name.substring(0, ci);
                    localName = name.substring(ci + 1);
                    uri = this.stylesheet.output.lookupNamespaceURI(prefix);
                }
                list.add(new QName(uri, localName, prefix));
            }
            if (!list.isEmpty()) {
                resultDoc = parent instanceof Document != false ? (Document)parent : parent.getOwnerDocument();
                this.convertCdataSectionElements(resultDoc, parent, list);
            }
        }
        if (indent) {
            if (created && parent instanceof DomDocument) {
                domDoc = (DomDocument)parent;
                domDoc.setBuilding(true);
                domDoc.setCheckWellformedness(false);
            }
            parent.normalize();
            if (this.stylesheet != null) {
                TransformerImpl.strip(this.stylesheet, parent);
            }
            resultDoc = parent instanceof Document != false ? (Document)parent : parent.getOwnerDocument();
            this.reindent(resultDoc, parent, 0);
            if (created && parent instanceof DomDocument) {
                domDoc = (DomDocument)parent;
                domDoc.setBuilding(false);
                domDoc.setCheckWellformedness(true);
            }
        }
        if (outputTarget instanceof DOMResult) {
            if (created) {
                dr = (DOMResult)outputTarget;
                dr.setNode(parent);
                dr.setNextSibling(null);
            }
        } else if (outputTarget instanceof StreamResult) {
            sr = (StreamResult)outputTarget;
            ex = null;
            try {
                this.writeStreamResult(parent, (StreamResult)sr, outputMethod, encoding);
            }
            catch (UnsupportedEncodingException v3) {
                try {
                    this.writeStreamResult(parent, (StreamResult)sr, outputMethod, "UTF-8");
                }
                catch (IOException e2) {
                    ex = e2;
                }
            }
            catch (IOException e) {
                ex = e;
            }
            if (ex != null) {
                if (this.errorListener != null) {
                    this.errorListener.error(new TransformerException(ex));
                } else {
                    ex.printStackTrace(System.err);
                }
            }
        } else if (outputTarget instanceof SAXResult) {
            sr = (SAXResult)outputTarget;
            try {
                ch = sr.getHandler();
                lh = sr.getLexicalHandler();
                if (lh == null && ch instanceof LexicalHandler) {
                    lh = (LexicalHandler)ch;
                }
                serializer = new SAXSerializer();
                serializer.serialize(parent, ch, lh);
            }
            catch (SAXException e) {
                if (this.errorListener != null) {
                    this.errorListener.error(new TransformerException(e));
                }
                e.printStackTrace(System.err);
            }
        }
    }

    static boolean strip(Stylesheet stylesheet, Node node2) throws TransformerConfigurationException {
        short nt = node2.getNodeType();
        if (nt == 5) {
            Node parent = node2.getParentNode();
            Node nextSibling = node2.getNextSibling();
            Node child = node2.getFirstChild();
            while (child != null) {
                Node next = child.getNextSibling();
                node2.removeChild(child);
                if (nextSibling != null) {
                    parent.insertBefore(child, nextSibling);
                } else {
                    parent.appendChild(child);
                }
                child = next;
            }
            return true;
        }
        if (nt == 3 || nt == 4) {
            String text = node2.getNodeValue();
            String[] tokens = TransformerImpl.tokenizeWhitespace(text);
            if (tokens.length > 1) {
                node2.setNodeValue(tokens[0]);
                Node parent = node2.getParentNode();
                Node nextSibling = node2.getNextSibling();
                Document doc = node2.getOwnerDocument();
                int i = 1;
                while (i < tokens.length) {
                    Text newChild;
                    Text text2 = newChild = nt == 4 ? doc.createCDATASection(tokens[i]) : doc.createTextNode(tokens[i]);
                    if (nextSibling != null) {
                        parent.insertBefore(newChild, nextSibling);
                    } else {
                        parent.appendChild(newChild);
                    }
                    ++i;
                }
            }
            return !stylesheet.isPreserved((Text)node2, true);
        }
        Node child = node2.getFirstChild();
        while (child != null) {
            boolean remove = TransformerImpl.strip(stylesheet, child);
            Node next = child.getNextSibling();
            if (remove) {
                node2.removeChild(child);
            }
            child = next;
        }
        return false;
    }

    private static String[] tokenizeWhitespace(String text) {
        boolean whitespace;
        char c;
        int len = text.length();
        int start = 0;
        int end = len - 1;
        int i = 0;
        while (i < len) {
            c = text.charAt(i);
            boolean bl = whitespace = c == ' ' || c == '\n' || c == '\t' || c == '\r';
            if (!whitespace) break;
            ++start;
            ++i;
        }
        if (start == end) {
            return new String[]{text};
        }
        i = end;
        while (i > start) {
            c = text.charAt(i);
            boolean bl = whitespace = c == ' ' || c == '\n' || c == '\t' || c == '\r';
            if (!whitespace) break;
            --end;
            --i;
        }
        if (start == 0 && end == len - 1) {
            return new String[]{text};
        }
        String[] ret = start > 0 && end < len - 1 ? new String[3] : new String[2];
        int i2 = 0;
        if (start > 0) {
            ret[i2++] = text.substring(0, start);
        }
        ret[i2++] = text.substring(start, end + 1);
        if (end < len - 1) {
            ret[i2++] = text.substring(end + 1);
        }
        return ret;
    }

    void writeStreamResult(Node node2, StreamResult sr, int outputMethod, String encoding) throws IOException {
        OutputStream out = null;
        boolean created = false;
        try {
            Writer writer;
            out = sr.getOutputStream();
            if (out == null && (writer = sr.getWriter()) != null) {
                out = new WriterOutputStream(writer);
            }
            if (out == null) {
                URL url;
                String systemId = sr.getSystemId();
                try {
                    url = new URL(systemId);
                    URLConnection connection = url.openConnection();
                    connection.setDoInput(false);
                    connection.setDoOutput(true);
                    out = connection.getOutputStream();
                }
                catch (MalformedURLException malformedURLException) {
                    out = new FileOutputStream(systemId);
                }
                catch (UnknownServiceException unknownServiceException) {
                    url = new URL(systemId);
                    out = new FileOutputStream(url.getPath());
                }
                created = true;
            }
            out = new BufferedOutputStream(out);
            StreamSerializer serializer = new StreamSerializer(outputMethod, encoding, null);
            if (this.stylesheet != null) {
                Collection<String> celem = this.stylesheet.outputCdataSectionElements;
                serializer.setCdataSectionElements(celem);
            }
            serializer.serialize(node2, out);
            out.flush();
        }
        finally {
            try {
                if (out != null && created) {
                    out.close();
                }
            }
            catch (IOException e) {
                if (this.errorListener != null) {
                    try {
                        this.errorListener.error(new TransformerException(e));
                    }
                    catch (TransformerException e2) {
                        e2.printStackTrace(System.err);
                    }
                }
                e.printStackTrace(System.err);
            }
        }
    }

    void copyChildren(Document dstDoc, Node src, Node dst) {
        Node srcChild = src.getFirstChild();
        while (srcChild != null) {
            Node dstChild = dstDoc.adoptNode(srcChild);
            dst.appendChild(dstChild);
            srcChild = srcChild.getNextSibling();
        }
    }

    public void setParameter(String name, Object value) {
        if (this.stylesheet != null) {
            this.stylesheet.bindings.set(new QName(null, name), value, 1);
        }
    }

    public Object getParameter(String name) {
        if (this.stylesheet != null) {
            return this.stylesheet.bindings.get(new QName(null, name), null, 1, 1);
        }
        return null;
    }

    public void clearParameters() {
        if (this.stylesheet != null) {
            this.stylesheet.bindings.pop(1);
            this.stylesheet.bindings.push(1);
        }
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setOutputProperties(Properties oformat) throws IllegalArgumentException {
        if (oformat == null) {
            this.outputProperties.clear();
        } else {
            this.outputProperties.putAll(oformat);
        }
    }

    public Properties getOutputProperties() {
        return (Properties)this.outputProperties.clone();
    }

    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        this.outputProperties.put(name, value);
    }

    public String getOutputProperty(String name) throws IllegalArgumentException {
        return this.outputProperties.getProperty(name);
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    void reindent(Document doc, Node node2, int offset) {
        if (node2.hasChildNodes()) {
            boolean markupContent = false;
            boolean textContent = false;
            LinkedList children = new LinkedList();
            Node ctx2 = node2.getFirstChild();
            while (ctx2 != null) {
                switch (ctx2.getNodeType()) {
                    case 1: 
                    case 7: 
                    case 10: {
                        markupContent = true;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: {
                        textContent = true;
                    }
                }
                children.add(ctx2);
                ctx2 = ctx2.getNextSibling();
            }
            if (markupContent) {
                short nodeType = node2.getNodeType();
                if (nodeType == 9) {
                    for (Node ctx2 : children) {
                        this.reindent(doc, ctx2, offset);
                    }
                } else {
                    CPStringBuilder buf = new CPStringBuilder();
                    buf.append('\n');
                    int i = 0;
                    while (i < offset + 1) {
                        buf.append(INDENT_WHITESPACE);
                        ++i;
                    }
                    String ws = buf.toString();
                    for (Node ctx2 : children) {
                        node2.insertBefore(doc.createTextNode(ws), ctx2);
                        this.reindent(doc, ctx2, offset + 1);
                    }
                    buf = new CPStringBuilder();
                    buf.append('\n');
                    int i2 = 0;
                    while (i2 < offset) {
                        buf.append(INDENT_WHITESPACE);
                        ++i2;
                    }
                    ws = buf.toString();
                    node2.appendChild(doc.createTextNode(ws));
                }
            }
        }
    }

    void convertCdataSectionElements(Document doc, Node node2, List list2) {
        if (node2.getNodeType() == 1) {
            boolean match = false;
            for (QName qname : list2) {
                if (!this.match(qname, node2)) continue;
                match = true;
                break;
            }
            if (match) {
                Node ctx = node2.getFirstChild();
                while (ctx != null) {
                    if (ctx.getNodeType() == 3) {
                        CDATASection cdata = doc.createCDATASection(ctx.getNodeValue());
                        node2.replaceChild(cdata, ctx);
                        ctx = cdata;
                    }
                    ctx = ctx.getNextSibling();
                }
            }
        }
        Node ctx = node2.getFirstChild();
        while (ctx != null) {
            if (ctx.hasChildNodes()) {
                this.convertCdataSectionElements(doc, ctx, list2);
            }
            ctx = ctx.getNextSibling();
        }
    }

    boolean match(QName qname, Node node2) {
        String uri2;
        String ln1 = qname.getLocalPart();
        String ln2 = node2.getLocalName();
        if (ln2 == null) {
            return ln1.equals(node2.getNodeName());
        }
        String uri1 = qname.getNamespaceURI();
        return uri1.equals(uri2 = node2.getNamespaceURI()) && ln1.equals(ln2);
    }
}

