/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.dnd.peer.gtk;

import gnu.java.awt.dnd.peer.gtk.GtkDropTargetContextPeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;

public class GtkDragSourceContextPeer
extends GtkGenericPeer
implements DragSourceContextPeer {
    private ComponentPeer peer;
    private Cursor cursor;
    private DragSourceContext context;
    public static Component target;

    native void nativeStartDrag(Image var1, int var2, int var3, int var4, String var5);

    native void connectSignals(ComponentPeer var1);

    native void create(ComponentPeer var1);

    native void nativeSetCursor(int var1);

    native void setTarget(GtkDropTargetContextPeer var1);

    public GtkDragSourceContextPeer(DragGestureEvent e) {
        super(e.getComponent());
        Component comp = e.getComponent();
        this.peer = this.getComponentPeer(comp);
        this.create(this.peer);
        this.connectSignals(this.peer);
        this.cursor = comp.getCursor();
        if (target != null) {
            this.setTarget(new GtkDropTargetContextPeer(target));
        }
    }

    ComponentPeer getComponentPeer(Component c) {
        if (c == null) {
            return null;
        }
        Component curr = c;
        while (curr.getPeer() instanceof LightweightPeer) {
            curr = curr.getParent();
        }
        if (curr != null) {
            return curr.getPeer();
        }
        return null;
    }

    public void startDrag(DragSourceContext context, Cursor c, Image i, Point p) throws InvalidDnDOperationException {
        this.context = context;
        if (p == null) {
            p = new Point();
        }
        this.setCursor(c);
        this.nativeStartDrag(i, p.x, p.y, context.getTrigger().getDragAction(), "text/plain");
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor c) throws InvalidDnDOperationException {
        if (c != null) {
            this.nativeSetCursor(c.getType());
            this.cursor = c;
        }
    }

    public void transferablesFlavorsChanged() {
    }

    public void dragEnter(int action, int modifiers) {
        this.context.dragEnter(new DragSourceDragEvent(this.context, action, action & this.context.getSourceActions(), modifiers));
    }

    public void dragExit(int action, int x, int y) {
        this.context.dragExit(new DragSourceEvent(this.context, x, y));
    }

    public void dragDropEnd(int action, boolean success, int x, int y) {
        this.context.dragDropEnd(new DragSourceDropEvent(this.context, action, success, x, y));
    }

    public void dragMouseMoved(int action, int modifiers) {
        this.context.dragMouseMoved(new DragSourceDragEvent(this.context, action, action & this.context.getSourceActions(), modifiers));
    }

    public void dragOver(int action, int modifiers) {
        this.context.dragOver(new DragSourceDragEvent(this.context, action, action & this.context.getSourceActions(), modifiers));
    }

    public void dragActionChanged(int newAction, int modifiers) {
        this.context.dropActionChanged(new DragSourceDragEvent(this.context, newAction, newAction & this.context.getSourceActions(), modifiers));
    }
}

