/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509CRLSelector
implements CRLSelector,
Cloneable {
    private static final String CRL_NUMBER_ID = "2.5.29.20";
    private List issuerNames;
    private BigInteger maxCrlNumber;
    private BigInteger minCrlNumber;
    private Date date;
    private X509Certificate cert;

    public void addIssuerName(byte[] name) throws IOException {
        X500Principal p = null;
        try {
            p = new X500Principal(name);
        }
        catch (IllegalArgumentException iae) {
            IOException ioe = new IOException("malformed name");
            ioe.initCause(iae);
            throw ioe;
        }
        if (this.issuerNames == null) {
            this.issuerNames = new LinkedList();
        }
        this.issuerNames.add(p);
    }

    public void addIssuerName(String name) throws IOException {
        X500Principal p = null;
        try {
            p = new X500Principal(name);
        }
        catch (IllegalArgumentException iae) {
            IOException ioe = new IOException("malformed name: " + name);
            ioe.initCause(iae);
            throw ioe;
        }
        if (this.issuerNames == null) {
            this.issuerNames = new LinkedList();
        }
        this.issuerNames.add(p);
    }

    public void setIssuerNames(Collection<?> names) throws IOException {
        if (names == null) {
            this.issuerNames = null;
            return;
        }
        ArrayList<Object> l = new ArrayList<Object>(names.size());
        for (Object o : names) {
            if (o instanceof X500Principal) {
                l.add(o);
                continue;
            }
            if (o instanceof String) {
                try {
                    l.add(new X500Principal((String)o));
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    IOException ioe = new IOException("malformed name: " + o);
                    ioe.initCause(iae);
                    throw ioe;
                }
            }
            if (o instanceof byte[]) {
                try {
                    l.add(new X500Principal((byte[])o));
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    IOException ioe = new IOException("malformed name");
                    ioe.initCause(iae);
                    throw ioe;
                }
            }
            if (o instanceof InputStream) {
                try {
                    l.add(new X500Principal((InputStream)o));
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    IOException ioe = new IOException("malformed name");
                    ioe.initCause(iae);
                    throw ioe;
                }
            }
            throw new IOException("not a valid name: " + (o != null ? o.getClass().getName() : "null"));
        }
        this.issuerNames = l;
    }

    public Collection<Object> getIssuerNames() {
        if (this.issuerNames != null) {
            return Collections.unmodifiableList(this.issuerNames);
        }
        return null;
    }

    public BigInteger getMaxCRL() {
        return this.maxCrlNumber;
    }

    public BigInteger getMinCRL() {
        return this.minCrlNumber;
    }

    public void setMaxCRLNumber(BigInteger maxCrlNumber) {
        this.maxCrlNumber = maxCrlNumber;
    }

    public void setMinCRLNumber(BigInteger minCrlNumber) {
        this.minCrlNumber = minCrlNumber;
    }

    public Date getDateAndTime() {
        return this.date != null ? (Date)this.date.clone() : null;
    }

    public void setDateAndTime(Date date) {
        this.date = date != null ? (Date)date.clone() : null;
    }

    public X509Certificate getCertificateChecking() {
        return this.cert;
    }

    public void setCertificateChecking(X509Certificate cert) {
        this.cert = cert;
    }

    public String toString() {
        CPStringBuilder str = new CPStringBuilder(X509CRLSelector.class.getName());
        String nl = SystemProperties.getProperty("line.separator");
        String eol = ";" + nl;
        str.append(" {").append(nl);
        if (this.issuerNames != null) {
            str.append("  issuer names = ").append(this.issuerNames).append(eol);
        }
        if (this.maxCrlNumber != null) {
            str.append("  max CRL = ").append(this.maxCrlNumber).append(eol);
        }
        if (this.minCrlNumber != null) {
            str.append("  min CRL = ").append(this.minCrlNumber).append(eol);
        }
        if (this.date != null) {
            str.append("  date = ").append(this.date).append(eol);
        }
        if (this.cert != null) {
            str.append("  certificate = ").append(this.cert).append(eol);
        }
        str.append("}").append(nl);
        return str.toString();
    }

    @Override
    public boolean match(CRL _crl) {
        DERValue val;
        byte[] b;
        if (!(_crl instanceof X509CRL)) {
            return false;
        }
        X509CRL crl = (X509CRL)_crl;
        if (this.issuerNames != null && !this.issuerNames.contains(crl.getIssuerX500Principal())) {
            return false;
        }
        BigInteger crlNumber = null;
        if (this.maxCrlNumber != null) {
            block15: {
                b = crl.getExtensionValue(CRL_NUMBER_ID);
                if (b == null) {
                    return false;
                }
                try {
                    val = DERReader.read(b);
                    if (val.getValue() instanceof BigInteger) break block15;
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            crlNumber = (BigInteger)val.getValue();
            if (this.maxCrlNumber.compareTo(crlNumber) < 0) {
                return false;
            }
        }
        if (this.minCrlNumber != null) {
            if (crlNumber == null) {
                block16: {
                    b = crl.getExtensionValue(CRL_NUMBER_ID);
                    if (b == null) {
                        return false;
                    }
                    try {
                        val = DERReader.read(b);
                        if (val.getValue() instanceof BigInteger) break block16;
                        return false;
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
                crlNumber = (BigInteger)val.getValue();
            }
            if (this.minCrlNumber.compareTo(crlNumber) > 0) {
                return false;
            }
        }
        return this.date == null || this.date.compareTo(crl.getThisUpdate()) >= 0 && this.date.compareTo(crl.getNextUpdate()) <= 0;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException shouldNotHappen) {
            throw new Error(shouldNotHappen);
        }
    }
}

