/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.action.GetSecurityPropertyAction;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.ByteArray;
import gnu.javax.net.ssl.provider.CipherAlgorithm;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.DelegatedTask;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.InputSecurityParameters;
import gnu.javax.net.ssl.provider.MacAlgorithm;
import gnu.javax.net.ssl.provider.OutputSecurityParameters;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.SSLRandom;
import gnu.javax.net.ssl.provider.SessionImpl;
import gnu.javax.net.ssl.provider.SignatureAlgorithm;
import gnu.javax.net.ssl.provider.TLSRandom;
import gnu.javax.net.ssl.provider.Util;
import gnu.javax.security.auth.callback.CertificateCallback;
import gnu.javax.security.auth.callback.DefaultCallbackHandler;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;

public abstract class AbstractHandshake {
    protected static final SystemLogger logger = SystemLogger.SYSTEM;
    protected static final byte[] SERVER_FINISHED = new byte[]{115, 101, 114, 118, 101, 114, 32, 102, 105, 110, 105, 115, 104, 101, 100};
    protected static final byte[] CLIENT_FINISHED = new byte[]{99, 108, 105, 101, 110, 116, 32, 102, 105, 110, 105, 115, 104, 101, 100};
    private static final byte[] KEY_EXPANSION = new byte[]{107, 101, 121, 32, 101, 120, 112, 97, 110, 115, 105, 111, 110};
    private static final byte[] MASTER_SECRET = new byte[]{109, 97, 115, 116, 101, 114, 32, 115, 101, 99, 114, 101, 116};
    private static final byte[] CLIENT_WRITE_KEY = new byte[]{99, 108, 105, 101, 110, 116, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    private static final byte[] SERVER_WRITE_KEY = new byte[]{115, 101, 114, 118, 101, 114, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    private static final byte[] IV_BLOCK = new byte[]{73, 86, 32, 98, 108, 111, 99, 107};
    private static final byte[] SENDER_CLIENT = new byte[]{67, 76, 78, 84};
    private static final byte[] SENDER_SERVER = new byte[]{83, 82, 86, 82};
    protected static final byte[] PAD1 = new byte[48];
    protected static final byte[] PAD2 = new byte[48];
    protected ByteBuffer handshakeBuffer;
    protected int handshakeOffset;
    protected MessageDigest sha;
    protected MessageDigest md5;
    protected final SSLEngineImpl engine;
    protected KeyAgreement keyAgreement;
    protected byte[] preMasterSecret;
    protected InputSecurityParameters inParams;
    protected OutputSecurityParameters outParams;
    protected LinkedList<DelegatedTask> tasks;
    protected Random serverRandom;
    protected Random clientRandom;
    protected CompressionMethod compression;

    static {
        Arrays.fill(PAD1, (byte)54);
        Arrays.fill(PAD2, (byte)92);
    }

    protected AbstractHandshake(SSLEngineImpl engine) throws NoSuchAlgorithmException {
        this.engine = engine;
        this.sha = MessageDigest.getInstance("SHA-1");
        this.md5 = MessageDigest.getInstance("MD5");
        this.tasks = new LinkedList();
    }

    /*
     * Unable to fully structure code
     */
    public final SSLEngineResult.HandshakeStatus handleInput(ByteBuffer fragment) throws SSLException {
        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        status = this.status();
        if (status != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            return status;
        }
        if (this.pollHandshake(fragment)) ** GOTO lbl15
        return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
lbl-1000:
        // 1 sources

        {
            pos = this.handshakeOffset;
            status = this.implHandleInput();
            len = this.handshakeOffset - pos;
            if (len == 0 || !this.doHash()) continue;
            AbstractHandshake.logger.logv(Component.SSL_HANDSHAKE, "hashing output\n{0}", new Object[]{Util.hexDump((ByteBuffer)this.handshakeBuffer.duplicate().position(pos).limit(pos + len), " >> ")});
            this.sha.update((ByteBuffer)this.handshakeBuffer.duplicate().position(pos).limit(pos + len));
            this.md5.update((ByteBuffer)this.handshakeBuffer.duplicate().position(pos).limit(pos + len));
lbl15:
            // 3 sources

            ** while (this.hasMessage() && status != SSLEngineResult.HandshakeStatus.NEED_WRAP)
        }
lbl16:
        // 1 sources

        return status;
    }

    protected abstract SSLEngineResult.HandshakeStatus implHandleInput() throws SSLException;

    public final SSLEngineResult.HandshakeStatus handleOutput(ByteBuffer fragment) throws SSLException {
        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        int orig = fragment.position();
        SSLEngineResult.HandshakeStatus status = this.implHandleOutput(fragment);
        if (this.doHash()) {
            logger.logv(Component.SSL_HANDSHAKE, "hashing output:\n{0}", Util.hexDump((ByteBuffer)fragment.duplicate().flip().position(orig), " >> "));
            this.sha.update((ByteBuffer)fragment.duplicate().flip().position(orig));
            this.md5.update((ByteBuffer)fragment.duplicate().flip().position(orig));
        }
        return status;
    }

    protected abstract SSLEngineResult.HandshakeStatus implHandleOutput(ByteBuffer var1) throws SSLException;

    final InputSecurityParameters getInputParams() throws SSLException {
        this.checkKeyExchange();
        return this.inParams;
    }

    final OutputSecurityParameters getOutputParams() throws SSLException {
        this.checkKeyExchange();
        return this.outParams;
    }

    final Runnable getTask() {
        if (this.tasks.isEmpty()) {
            return null;
        }
        return this.tasks.removeFirst();
    }

    abstract SSLEngineResult.HandshakeStatus status();

    abstract void checkKeyExchange() throws SSLException;

    abstract void handleV2Hello(ByteBuffer var1) throws SSLException;

    protected boolean pollHandshake(ByteBuffer fragment) {
        if (this.handshakeBuffer == null || this.handshakeBuffer.remaining() < fragment.remaining()) {
            int len = this.handshakeBuffer == null ? 0 : this.handshakeBuffer.position() - this.handshakeOffset;
            this.reallocateBuffer(len += fragment.remaining());
        }
        logger.logv(Component.SSL_HANDSHAKE, "inserting {0} into {1}", fragment, this.handshakeBuffer);
        this.handshakeBuffer.put(fragment);
        return this.hasMessage();
    }

    protected boolean doHash() {
        return true;
    }

    protected boolean hasMessage() {
        if (this.handshakeBuffer == null) {
            return false;
        }
        ByteBuffer tmp = this.handshakeBuffer.duplicate();
        tmp.flip();
        tmp.position(this.handshakeOffset);
        logger.logv(Component.SSL_HANDSHAKE, "current buffer: {0}; test buffer {1}", this.handshakeBuffer, tmp);
        if (tmp.remaining() < 4) {
            return false;
        }
        Handshake handshake = new Handshake(tmp.slice());
        logger.logv(Component.SSL_HANDSHAKE, "handshake len:{0} remaining:{1}", handshake.length(), tmp.remaining());
        return handshake.length() <= tmp.remaining() - 4;
    }

    private void reallocateBuffer(int totalLen) {
        int len;
        int n = len = this.handshakeBuffer == null ? -1 : this.handshakeBuffer.capacity() - (this.handshakeBuffer.limit() - this.handshakeOffset);
        if (len >= totalLen) {
            if (this.handshakeOffset > 0) {
                this.handshakeBuffer.flip().position(this.handshakeOffset);
                this.handshakeBuffer.compact();
                this.handshakeOffset = 0;
            }
            return;
        }
        len = 1024;
        while (len < totalLen) {
            len <<= 1;
        }
        ByteBuffer newBuf = ByteBuffer.allocate(len);
        if (this.handshakeBuffer != null) {
            this.handshakeBuffer.flip();
            this.handshakeBuffer.position(this.handshakeOffset);
            newBuf.put(this.handshakeBuffer);
        }
        this.handshakeBuffer = newBuf;
        this.handshakeOffset = 0;
    }

    protected byte[] genV3CertificateVerify(MessageDigest md5, MessageDigest sha, SessionImpl session) {
        byte[] tmp;
        byte[] md5value = null;
        if (session.suite.signatureAlgorithm() == SignatureAlgorithm.RSA) {
            md5.update(session.privateData.masterSecret);
            md5.update(PAD1, 0, 48);
            tmp = md5.digest();
            md5.reset();
            md5.update(session.privateData.masterSecret);
            md5.update(PAD2, 0, 48);
            md5.update(tmp);
            md5value = md5.digest();
        }
        sha.update(session.privateData.masterSecret);
        sha.update(PAD1, 0, 40);
        tmp = sha.digest();
        sha.reset();
        sha.update(session.privateData.masterSecret);
        sha.update(PAD2, 0, 40);
        sha.update(tmp);
        byte[] shavalue = sha.digest();
        if (md5value != null) {
            return Util.concat(md5value, shavalue);
        }
        return shavalue;
    }

    protected byte[][] generateKeys(Random clientRandom, Random serverRandom, SessionImpl session) {
        HashMap<String, byte[]> attr;
        byte[] seed;
        int maclen = 20;
        if (session.suite.macAlgorithm() == MacAlgorithm.MD5) {
            maclen = 16;
        }
        int ivlen = 0;
        if (session.suite.cipherAlgorithm() == CipherAlgorithm.DES || session.suite.cipherAlgorithm() == CipherAlgorithm.DESede) {
            ivlen = 8;
        }
        if (session.suite.cipherAlgorithm() == CipherAlgorithm.AES) {
            ivlen = 16;
        }
        int keylen = session.suite.keyLength();
        byte[][] keys = new byte[][]{new byte[maclen], new byte[maclen], new byte[keylen], new byte[keylen], new byte[ivlen], new byte[ivlen]};
        IRandom prf = null;
        if (session.version == ProtocolVersion.SSL_3) {
            seed = new byte[clientRandom.length() + serverRandom.length()];
            serverRandom.buffer().get(seed, 0, serverRandom.length());
            clientRandom.buffer().get(seed, serverRandom.length(), clientRandom.length());
            prf = new SSLRandom();
            attr = new HashMap<String, byte[]>(2);
            attr.put("jessie.sslprng.secret", session.privateData.masterSecret);
            attr.put("jessie.sslprng.seed", seed);
            prf.init(attr);
        } else {
            seed = new byte[KEY_EXPANSION.length + clientRandom.length() + serverRandom.length()];
            System.arraycopy(KEY_EXPANSION, 0, seed, 0, KEY_EXPANSION.length);
            serverRandom.buffer().get(seed, KEY_EXPANSION.length, serverRandom.length());
            clientRandom.buffer().get(seed, KEY_EXPANSION.length + serverRandom.length(), clientRandom.length());
            prf = new TLSRandom();
            attr = new HashMap(2);
            attr.put("jessie.tls.prng.secret", session.privateData.masterSecret);
            attr.put("jessie.tls.prng.seed", seed);
            prf.init(attr);
        }
        try {
            prf.nextBytes(keys[0], 0, keys[0].length);
            prf.nextBytes(keys[1], 0, keys[1].length);
            prf.nextBytes(keys[2], 0, keys[2].length);
            prf.nextBytes(keys[3], 0, keys[3].length);
            if (session.suite.isExportable()) {
                if (session.version == ProtocolVersion.SSL_3) {
                    MessageDigest md5 = MessageDigest.getInstance("MD5");
                    md5.update(clientRandom.buffer());
                    md5.update(serverRandom.buffer());
                    byte[] d = md5.digest();
                    System.arraycopy(d, 0, keys[4], 0, keys[4].length);
                    md5.reset();
                    md5.update(serverRandom.buffer());
                    md5.update(clientRandom.buffer());
                    d = md5.digest();
                    System.arraycopy(d, 0, keys[5], 0, keys[5].length);
                    md5.reset();
                    md5.update(keys[2]);
                    md5.update(clientRandom.buffer());
                    md5.update(serverRandom.buffer());
                    keys[2] = Util.trim(md5.digest(), 8);
                    md5.reset();
                    md5.update(keys[3]);
                    md5.update(serverRandom.buffer());
                    md5.update(clientRandom.buffer());
                    keys[3] = Util.trim(md5.digest(), 8);
                } else {
                    TLSRandom prf2 = new TLSRandom();
                    attr = new HashMap(2);
                    attr.put("jessie.tls.prng.secret", keys[2]);
                    byte[] seed2 = new byte[CLIENT_WRITE_KEY.length + clientRandom.length() + serverRandom.length()];
                    System.arraycopy(CLIENT_WRITE_KEY, 0, seed2, 0, CLIENT_WRITE_KEY.length);
                    clientRandom.buffer().get(seed2, CLIENT_WRITE_KEY.length, clientRandom.length());
                    serverRandom.buffer().get(seed2, CLIENT_WRITE_KEY.length + clientRandom.length(), serverRandom.length());
                    attr.put("jessie.tls.prng.seed", seed2);
                    prf2.init(attr);
                    keys[2] = new byte[8];
                    prf2.nextBytes(keys[2], 0, keys[2].length);
                    attr.put("jessie.tls.prng.secret", keys[3]);
                    seed2 = new byte[SERVER_WRITE_KEY.length + serverRandom.length() + clientRandom.length()];
                    System.arraycopy(SERVER_WRITE_KEY, 0, seed2, 0, SERVER_WRITE_KEY.length);
                    serverRandom.buffer().get(seed2, SERVER_WRITE_KEY.length, serverRandom.length());
                    clientRandom.buffer().get(seed2, SERVER_WRITE_KEY.length + serverRandom.length(), clientRandom.length());
                    attr.put("jessie.tls.prng.seed", seed2);
                    prf2.init(attr);
                    keys[3] = new byte[8];
                    prf2.nextBytes(keys[3], 0, keys[3].length);
                    attr.put("jessie.tls.prng.secret", new byte[0]);
                    seed2 = new byte[IV_BLOCK.length + clientRandom.length() + serverRandom.length()];
                    System.arraycopy(IV_BLOCK, 0, seed2, 0, IV_BLOCK.length);
                    clientRandom.buffer().get(seed2, IV_BLOCK.length, clientRandom.length());
                    serverRandom.buffer().get(seed2, IV_BLOCK.length + clientRandom.length(), serverRandom.length());
                    attr.put("jessie.tls.prng.seed", seed2);
                    prf2.init(attr);
                    prf2.nextBytes(keys[4], 0, keys[4].length);
                    prf2.nextBytes(keys[5], 0, keys[5].length);
                }
            } else {
                prf.nextBytes(keys[4], 0, keys[4].length);
                prf.nextBytes(keys[5], 0, keys[5].length);
            }
        }
        catch (LimitReachedException lre) {
            throw new Error(lre);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new Error(nsae);
        }
        logger.logv(Component.SSL_KEY_EXCHANGE, "keys generated;\n  [0]: {0}\n  [1]: {1}\n  [2]: {2}\n  [3]: {3}\n  [4]: {4}\n  [5]: {5}", Util.toHexString(keys[0], ':'), Util.toHexString(keys[1], ':'), Util.toHexString(keys[2], ':'), Util.toHexString(keys[3], ':'), Util.toHexString(keys[4], ':'), Util.toHexString(keys[5], ':'));
        return keys;
    }

    protected ByteBuffer generateFinished(MessageDigest md5, MessageDigest sha, boolean isClient, SessionImpl session) {
        ByteBuffer finishedBuffer = null;
        if (session.version.compareTo(ProtocolVersion.TLS_1) >= 0) {
            finishedBuffer = ByteBuffer.allocate(12);
            TLSRandom prf = new TLSRandom();
            byte[] md5val = md5.digest();
            byte[] shaval = sha.digest();
            logger.logv(Component.SSL_HANDSHAKE, "finished md5:{0} sha:{1}", Util.toHexString(md5val, ':'), Util.toHexString(shaval, ':'));
            byte[] seed = new byte[CLIENT_FINISHED.length + md5val.length + shaval.length];
            if (isClient) {
                System.arraycopy(CLIENT_FINISHED, 0, seed, 0, CLIENT_FINISHED.length);
            } else {
                System.arraycopy(SERVER_FINISHED, 0, seed, 0, SERVER_FINISHED.length);
            }
            System.arraycopy(md5val, 0, seed, CLIENT_FINISHED.length, md5val.length);
            System.arraycopy(shaval, 0, seed, CLIENT_FINISHED.length + md5val.length, shaval.length);
            HashMap<String, byte[]> params = new HashMap<String, byte[]>(2);
            params.put("jessie.tls.prng.secret", session.privateData.masterSecret);
            params.put("jessie.tls.prng.seed", seed);
            prf.init(params);
            byte[] buf = new byte[12];
            prf.nextBytes(buf, 0, buf.length);
            finishedBuffer.put(buf).position(0);
        } else {
            finishedBuffer = ByteBuffer.allocate(36);
            md5.update(isClient ? SENDER_CLIENT : SENDER_SERVER);
            md5.update(session.privateData.masterSecret);
            md5.update(PAD1);
            byte[] tmp = md5.digest();
            md5.reset();
            md5.update(session.privateData.masterSecret);
            md5.update(PAD2);
            md5.update(tmp);
            finishedBuffer.put(md5.digest());
            sha.update(isClient ? SENDER_CLIENT : SENDER_SERVER);
            sha.update(session.privateData.masterSecret);
            sha.update(PAD1, 0, 40);
            tmp = sha.digest();
            sha.reset();
            sha.update(session.privateData.masterSecret);
            sha.update(PAD2, 0, 40);
            sha.update(tmp);
            finishedBuffer.put(sha.digest()).position(0);
        }
        return finishedBuffer;
    }

    protected void initDiffieHellman(DHPrivateKey dhKey, SecureRandom random) throws SSLException {
        try {
            this.keyAgreement = KeyAgreement.getInstance("DH");
            this.keyAgreement.init((Key)dhKey, random);
        }
        catch (InvalidKeyException ike) {
            throw new SSLException(ike);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SSLException(nsae);
        }
    }

    protected void generateMasterSecret(Random clientRandom, Random serverRandom, SessionImpl session) throws SSLException {
        assert (clientRandom != null);
        assert (serverRandom != null);
        assert (session != null);
        logger.logv(Component.SSL_KEY_EXCHANGE, "preMasterSecret:\n{0}", new ByteArray(this.preMasterSecret));
        if (session.version == ProtocolVersion.SSL_3) {
            try {
                MessageDigest _md5 = MessageDigest.getInstance("MD5");
                MessageDigest _sha = MessageDigest.getInstance("SHA");
                session.privateData.masterSecret = new byte[48];
                _sha.update((byte)65);
                _sha.update(this.preMasterSecret);
                _sha.update(clientRandom.buffer());
                _sha.update(serverRandom.buffer());
                _md5.update(this.preMasterSecret);
                _md5.update(_sha.digest());
                _md5.digest(session.privateData.masterSecret, 0, 16);
                _sha.update((byte)66);
                _sha.update((byte)66);
                _sha.update(this.preMasterSecret);
                _sha.update(clientRandom.buffer());
                _sha.update(serverRandom.buffer());
                _md5.update(this.preMasterSecret);
                _md5.update(_sha.digest());
                _md5.digest(session.privateData.masterSecret, 16, 16);
                _sha.update((byte)67);
                _sha.update((byte)67);
                _sha.update((byte)67);
                _sha.update(this.preMasterSecret);
                _sha.update(clientRandom.buffer());
                _sha.update(serverRandom.buffer());
                _md5.update(this.preMasterSecret);
                _md5.update(_sha.digest());
                _md5.digest(session.privateData.masterSecret, 32, 16);
            }
            catch (DigestException de) {
                throw new SSLException(de);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SSLException(nsae);
            }
        } else {
            byte[] seed = new byte[clientRandom.length() + serverRandom.length() + MASTER_SECRET.length];
            System.arraycopy(MASTER_SECRET, 0, seed, 0, MASTER_SECRET.length);
            clientRandom.buffer().get(seed, MASTER_SECRET.length, clientRandom.length());
            serverRandom.buffer().get(seed, MASTER_SECRET.length + clientRandom.length(), serverRandom.length());
            TLSRandom prf = new TLSRandom();
            HashMap<String, byte[]> attr = new HashMap<String, byte[]>(2);
            attr.put("jessie.tls.prng.secret", this.preMasterSecret);
            attr.put("jessie.tls.prng.seed", seed);
            prf.init(attr);
            session.privateData.masterSecret = new byte[48];
            prf.nextBytes(session.privateData.masterSecret, 0, 48);
        }
        logger.log((Level)Component.SSL_KEY_EXCHANGE, "master_secret: {0}", new ByteArray(session.privateData.masterSecret));
        int i = 0;
        while (i < this.preMasterSecret.length) {
            this.preMasterSecret[i] = 0;
            ++i;
        }
    }

    protected void setupSecurityParameters(byte[][] keys, boolean isClient, SSLEngineImpl engine, CompressionMethod compression) throws SSLException {
        assert (keys.length == 6);
        assert (engine != null);
        assert (compression != null);
        try {
            CipherSuite s = engine.session().suite;
            Cipher inCipher = s.cipher();
            Mac inMac = s.mac(engine.session().version);
            Inflater inflater = compression == CompressionMethod.ZLIB ? new Inflater() : null;
            inCipher.init(2, (Key)new SecretKeySpec(keys[isClient ? 3 : 2], s.cipherAlgorithm().toString()), new IvParameterSpec(keys[isClient ? 5 : 4]));
            inMac.init(new SecretKeySpec(keys[isClient ? 1 : 0], inMac.getAlgorithm()));
            this.inParams = new InputSecurityParameters(inCipher, inMac, inflater, engine.session(), s);
            Cipher outCipher = s.cipher();
            Mac outMac = s.mac(engine.session().version);
            Deflater deflater = compression == CompressionMethod.ZLIB ? new Deflater() : null;
            outCipher.init(1, (Key)new SecretKeySpec(keys[isClient ? 2 : 3], s.cipherAlgorithm().toString()), new IvParameterSpec(keys[isClient ? 4 : 5]));
            outMac.init(new SecretKeySpec(keys[isClient ? 0 : 1], outMac.getAlgorithm()));
            this.outParams = new OutputSecurityParameters(outCipher, outMac, deflater, engine.session(), s);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new SSLException(iape);
        }
        catch (InvalidKeyException ike) {
            throw new SSLException(ike);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SSLException(nsae);
        }
        catch (NoSuchPaddingException nspe) {
            throw new SSLException(nspe);
        }
    }

    protected void generatePSKSecret(String identity, byte[] otherkey, boolean isClient) throws SSLException {
        Key key = null;
        try {
            key = this.engine.contextImpl.pskManager.getKey(identity);
        }
        catch (KeyManagementException keyManagementException) {}
        if (key != null) {
            byte[] keyb = key.getEncoded();
            if (otherkey == null) {
                otherkey = new byte[keyb.length];
            }
            this.preMasterSecret = new byte[otherkey.length + keyb.length + 4];
            this.preMasterSecret[0] = (byte)(otherkey.length >>> 8);
            this.preMasterSecret[1] = (byte)otherkey.length;
            System.arraycopy(otherkey, 0, this.preMasterSecret, 2, otherkey.length);
            this.preMasterSecret[otherkey.length + 2] = (byte)(keyb.length >>> 8);
            this.preMasterSecret[otherkey.length + 3] = (byte)keyb.length;
            System.arraycopy(keyb, 0, this.preMasterSecret, otherkey.length + 4, keyb.length);
        } else {
            this.preMasterSecret = new byte[8];
            this.preMasterSecret[1] = 2;
            this.preMasterSecret[5] = 2;
            this.preMasterSecret[6] = (byte)this.engine.session().random().nextInt();
            this.preMasterSecret[7] = (byte)this.engine.session().random().nextInt();
        }
        logger.logv(Component.SSL_KEY_EXCHANGE, "PSK identity {0} key {1}", identity, key);
        this.generateMasterSecret(this.clientRandom, this.serverRandom, this.engine.session());
        byte[][] keys = this.generateKeys(this.clientRandom, this.serverRandom, this.engine.session());
        this.setupSecurityParameters(keys, isClient, this.engine, this.compression);
    }

    protected class CertVerifier
    extends DelegatedTask {
        private final boolean clientSide;
        private final X509Certificate[] chain;
        private boolean verified;

        protected CertVerifier(boolean clientSide, X509Certificate[] chain) {
            this.clientSide = clientSide;
            this.chain = chain;
        }

        boolean verified() {
            return this.verified;
        }

        protected void implRun() {
            X509TrustManager tm = AbstractHandshake.this.engine.contextImpl.trustManager;
            if (this.clientSide) {
                try {
                    tm.checkServerTrusted(this.chain, null);
                    this.verified = true;
                }
                catch (CertificateException ce) {
                    logger.log((Level)Component.SSL_DELEGATED_TASK, "cert verify", ce);
                    CallbackHandler verify = new DefaultCallbackHandler();
                    GetSecurityPropertyAction gspa = new GetSecurityPropertyAction("jessie.certificate.handler");
                    String clazz = AccessController.doPrivileged(gspa);
                    try {
                        ClassLoader cl = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                            @Override
                            public ClassLoader run() throws Exception {
                                return ClassLoader.getSystemClassLoader();
                            }
                        });
                        verify = (CallbackHandler)cl.loadClass(clazz).newInstance();
                    }
                    catch (Exception x) {
                        logger.log((Level)Component.SSL_DELEGATED_TASK, "callback handler loading", x);
                    }
                    CertificateCallback confirm = new CertificateCallback(this.chain[0], "The server's certificate could not be verified. There is no proof that this server is who it claims to be, or that their certificate is valid. Do you wish to continue connecting? ");
                    try {
                        verify.handle(new Callback[]{confirm});
                        this.verified = confirm.getSelectedIndex() == 0;
                    }
                    catch (Exception x) {
                        logger.log((Level)Component.SSL_DELEGATED_TASK, "callback handler exception", x);
                        this.verified = false;
                    }
                }
            } else {
                try {
                    tm.checkClientTrusted(this.chain, null);
                }
                catch (CertificateException certificateException) {
                    this.verified = false;
                }
            }
            if (this.verified) {
                AbstractHandshake.this.engine.session().setPeerVerified(true);
            }
        }
    }

    protected class DHE_PSKGen
    extends DelegatedTask {
        private final DHPublicKey dhKey;
        private final SecretKey psKey;
        private final boolean isClient;

        protected DHE_PSKGen(DHPublicKey dhKey, SecretKey psKey, boolean isClient) {
            this.dhKey = dhKey;
            this.psKey = psKey;
            this.isClient = isClient;
        }

        protected void implRun() throws Throwable {
            AbstractHandshake.this.keyAgreement.doPhase(this.dhKey, true);
            byte[] dhSecret = AbstractHandshake.this.keyAgreement.generateSecret();
            byte[] psSecret = null;
            if (this.psKey != null) {
                psSecret = this.psKey.getEncoded();
            } else {
                psSecret = new byte[8];
                AbstractHandshake.this.engine.session().random().nextBytes(psSecret);
            }
            AbstractHandshake.this.preMasterSecret = new byte[dhSecret.length + psSecret.length + 4];
            AbstractHandshake.this.preMasterSecret[0] = (byte)(dhSecret.length >>> 8);
            AbstractHandshake.this.preMasterSecret[1] = (byte)dhSecret.length;
            System.arraycopy(dhSecret, 0, AbstractHandshake.this.preMasterSecret, 2, dhSecret.length);
            AbstractHandshake.this.preMasterSecret[dhSecret.length + 2] = (byte)(psSecret.length >>> 8);
            AbstractHandshake.this.preMasterSecret[dhSecret.length + 3] = (byte)psSecret.length;
            System.arraycopy(psSecret, 0, AbstractHandshake.this.preMasterSecret, dhSecret.length + 4, psSecret.length);
            AbstractHandshake.this.generateMasterSecret(AbstractHandshake.this.clientRandom, AbstractHandshake.this.serverRandom, AbstractHandshake.this.engine.session());
            byte[][] keys = AbstractHandshake.this.generateKeys(AbstractHandshake.this.clientRandom, AbstractHandshake.this.serverRandom, AbstractHandshake.this.engine.session());
            AbstractHandshake.this.setupSecurityParameters(keys, this.isClient, AbstractHandshake.this.engine, AbstractHandshake.this.compression);
        }
    }

    protected class DHPhase
    extends DelegatedTask {
        private final DHPublicKey key;
        private final boolean full;

        protected DHPhase(DHPublicKey key) {
            this(key, true);
        }

        protected DHPhase(DHPublicKey key, boolean full) {
            this.key = key;
            this.full = full;
        }

        protected void implRun() throws InvalidKeyException, SSLException {
            AbstractHandshake.this.keyAgreement.doPhase(this.key, true);
            AbstractHandshake.this.preMasterSecret = AbstractHandshake.this.keyAgreement.generateSecret();
            if (this.full) {
                AbstractHandshake.this.generateMasterSecret(AbstractHandshake.this.clientRandom, AbstractHandshake.this.serverRandom, AbstractHandshake.this.engine.session());
                byte[][] keys = AbstractHandshake.this.generateKeys(AbstractHandshake.this.clientRandom, AbstractHandshake.this.serverRandom, AbstractHandshake.this.engine.session());
                AbstractHandshake.this.setupSecurityParameters(keys, AbstractHandshake.this.engine.getUseClientMode(), AbstractHandshake.this.engine, AbstractHandshake.this.compression);
            }
        }
    }
}

