/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.java.lang.CPStringBuilder;
import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.WrongPaddingException;
import java.util.Map;
import java.util.logging.Logger;

public abstract class BasePad
implements IPad {
    private static final Logger log = Logger.getLogger(BasePad.class.getName());
    protected String name;
    protected int blockSize;

    protected BasePad(String name) {
        this.name = name;
        this.blockSize = -1;
    }

    public String name() {
        CPStringBuilder sb = new CPStringBuilder(this.name);
        if (this.blockSize != -1) {
            sb.append('-').append(String.valueOf(8 * this.blockSize));
        }
        return sb.toString();
    }

    public void init(int bs) throws IllegalStateException {
        if (this.blockSize != -1) {
            throw new IllegalStateException();
        }
        this.blockSize = bs;
        this.setup();
    }

    public void init(Map attributes) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.blockSize = -1;
    }

    public boolean selfTest() {
        byte[] in = new byte[1024];
        int bs = 2;
        while (bs < 256) {
            if (!this.test1BlockSize(bs, in)) {
                return false;
            }
            ++bs;
        }
        return true;
    }

    protected boolean test1BlockSize(int size, byte[] buffer) {
        int limit = buffer.length;
        this.init(size);
        int i = 0;
        while (i < limit - 5 - this.blockSize) {
            byte[] padBytes = this.pad(buffer, 5, i);
            if ((i + padBytes.length) % this.blockSize != 0) {
                return false;
            }
            System.arraycopy(padBytes, 0, buffer, 5 + i, padBytes.length);
            try {
                if (padBytes.length != this.unpad(buffer, 5, i + padBytes.length)) {
                    return false;
                }
            }
            catch (WrongPaddingException x) {
                return false;
            }
            ++i;
        }
        this.reset();
        return true;
    }

    public abstract void setup();

    public abstract byte[] pad(byte[] var1, int var2, int var3);

    public abstract int unpad(byte[] var1, int var2, int var3) throws WrongPaddingException;
}

