/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.swing.JComponent;

public abstract class ComponentUI {
    public void installUI(JComponent c) {
    }

    public void uninstallUI(JComponent c) {
    }

    public void paint(Graphics g, JComponent c) {
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            Color oldColor = g.getColor();
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            g.setColor(oldColor);
        }
        this.paint(g, c);
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public boolean contains(JComponent c, int x, int y) {
        return x >= 0 && x < c.getWidth() && y >= 0 && y < c.getHeight();
    }

    public static ComponentUI createUI(JComponent c) {
        throw new Error("javax.swing.plaf.ComponentUI does not implement createUI; call createUI on a subclass.");
    }

    public int getAccessibleChildrenCount(JComponent c) {
        return c.getAccessibleContext().getAccessibleChildrenCount();
    }

    public Accessible getAccessibleChild(JComponent c, int i) {
        return c.getAccessibleContext().getAccessibleChild(i);
    }
}

