/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.EmptyBorder;

public class MatteBorder
extends EmptyBorder {
    static final long serialVersionUID = 4422248989617298224L;
    protected Color color;
    protected Icon tileIcon;

    public MatteBorder(int top, int left, int bottom, int right, Color matteColor) {
        super(top, left, bottom, right);
        if (matteColor == null) {
            throw new IllegalArgumentException();
        }
        this.color = matteColor;
    }

    public MatteBorder(Insets borderInsets, Color matteColor) {
        this(borderInsets.top, borderInsets.left, borderInsets.bottom, borderInsets.right, matteColor);
    }

    public MatteBorder(int top, int left, int bottom, int right, Icon tileIcon) {
        super(top, left, bottom, right);
        this.tileIcon = tileIcon;
    }

    public MatteBorder(Insets borderInsets, Icon tileIcon) {
        this(borderInsets.top, borderInsets.left, borderInsets.bottom, borderInsets.right, tileIcon);
    }

    public MatteBorder(Icon tileIcon) {
        this(-1, -1, -1, -1, tileIcon);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets i = this.getBorderInsets();
        this.paintEdge(c, g, x, y, width, i.top, 0, 0);
        this.paintEdge(c, g, x, y + height - i.bottom, width, i.bottom, 0, height - i.bottom);
        this.paintEdge(c, g, x, y + i.top, i.left, height - i.top, 0, i.top);
        this.paintEdge(c, g, x + width - i.right, y + i.top, i.right, height - i.bottom, width - i.right, i.top);
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, null);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.tileIcon != null && this.top < 0 && this.left < 0 && this.right < 0 && this.bottom < 0) {
            insets.left = insets.right = this.tileIcon.getIconWidth();
            insets.top = insets.bottom = this.tileIcon.getIconHeight();
            return insets;
        }
        return super.getBorderInsets(c, insets);
    }

    public Insets getBorderInsets() {
        return this.getBorderInsets(null, null);
    }

    public Color getMatteColor() {
        return this.color;
    }

    public Icon getTileIcon() {
        return this.tileIcon;
    }

    public boolean isBorderOpaque() {
        return this.color != null && this.color.getAlpha() == 255;
    }

    private void paintEdge(Component c, Graphics g, int x, int y, int width, int height, int dx, int dy) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.color != null) {
            Color oldColor = g.getColor();
            try {
                g.setColor(this.color);
                g.fillRect(x, y, width, height);
            }
            finally {
                g.setColor(oldColor);
            }
            return;
        }
        if (this.tileIcon == null) {
            return;
        }
        int iconWidth = this.tileIcon.getIconWidth();
        int iconHeight = this.tileIcon.getIconHeight();
        if (iconWidth <= 0 || iconHeight <= 0) {
            return;
        }
        dx %= iconWidth;
        dy %= iconHeight;
        Graphics clipped = g.create();
        try {
            clipped.setClip(x, y, width, height);
            int ty = y - dy;
            while (ty < y + height) {
                int tx = x - dx;
                while (tx < x + width) {
                    this.tileIcon.paintIcon(c, clipped, tx, ty);
                    tx += iconWidth;
                }
                ty += iconHeight;
            }
        }
        finally {
            clipped.dispose();
        }
    }
}

