/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class ShortMessage
extends MidiMessage {
    public static final int MIDI_TIME_CODE = 241;
    public static final int SONG_POSITION_POINTER = 242;
    public static final int SONG_SELECT = 243;
    public static final int TUNE_REQUEST = 246;
    public static final int END_OF_EXCLUSIVE = 247;
    public static final int TIMING_CLOCK = 248;
    public static final int START = 250;
    public static final int CONTINUE = 251;
    public static final int STOP = 252;
    public static final int ACTIVE_SENSING = 254;
    public static final int SYSTEM_RESET = 255;
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int POLY_PRESSURE = 160;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int CHANNEL_PRESSURE = 208;
    public static final int PITCH_BEND = 224;
    private static byte[] defaultMessage = new byte[1];

    static {
        ShortMessage.defaultMessage[0] = -4;
    }

    public ShortMessage() {
        this(defaultMessage);
    }

    protected ShortMessage(byte[] data) {
        super(data);
    }

    public void setMessage(int status, int data1, int data2) throws InvalidMidiDataException {
        this.length = this.getDataLength(status);
        ++this.length;
        if (this.data == null || this.data.length < this.length) {
            this.data = new byte[this.length];
        }
        this.data[0] = (byte)status;
        if (this.length > 1) {
            if (data1 < 0 || data1 > 127) {
                throw new InvalidMidiDataException("data1 (" + data1 + ") must be between 0 and 127.");
            }
            this.data[1] = (byte)data1;
            if (this.length > 2) {
                if (data2 < 0 || data2 > 127) {
                    throw new InvalidMidiDataException("data2 (" + data2 + ") must be between 0 and 127.");
                }
                this.data[2] = (byte)data2;
            }
        }
    }

    public void setMessage(int command, int channel, int data1, int data2) throws InvalidMidiDataException {
        this.setMessage(command + channel, data1, data2);
    }

    public void setMessage(int status) throws InvalidMidiDataException {
        int length = this.getDataLength(status);
        if (length != 0) {
            throw new InvalidMidiDataException("Status byte 0x" + Integer.toHexString(status) + " requires " + length + " bytes of data.");
        }
        this.setMessage(status, 0, 0);
    }

    protected final int getDataLength(int status) throws InvalidMidiDataException {
        int originalStatus = status;
        if ((status & 0xF0) != 240) {
            status &= 0xF0;
        }
        switch (status) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: 
            case 242: {
                return 2;
            }
            case 192: 
            case 208: 
            case 243: 
            case 245: {
                return 1;
            }
            case 246: 
            case 247: 
            case 248: 
            case 250: 
            case 251: 
            case 252: 
            case 254: 
            case 255: {
                return 0;
            }
        }
        throw new InvalidMidiDataException("Invalid status: 0x" + Integer.toHexString(originalStatus));
    }

    public int getChannel() {
        return this.data[0] & 0xF;
    }

    public int getCommand() {
        return this.data[0] & 0xF0;
    }

    public int getData1() {
        if (this.length > 1) {
            return this.data[1];
        }
        return 0;
    }

    public int getData2() {
        if (this.length > 2) {
            return this.data[2];
        }
        return 0;
    }

    public Object clone() {
        byte[] message = new byte[this.length];
        System.arraycopy(this.data, 0, message, 0, this.length);
        return new ShortMessage(message);
    }
}

