/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi.ssl;

import java.io.IOException;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class SslRMIServerSocketFactory
implements RMIServerSocketFactory {
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;
    private boolean needClientAuth;
    private static SSLServerSocketFactory socketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();

    public SslRMIServerSocketFactory() {
        this.enabledProtocols = null;
        this.enabledCipherSuites = null;
        this.needClientAuth = false;
    }

    public SslRMIServerSocketFactory(String[] enabledCipherSuites, String[] enabledProtocols, boolean needClientAuth) {
        this.enabledCipherSuites = enabledCipherSuites;
        this.enabledProtocols = enabledProtocols;
        this.needClientAuth = needClientAuth;
        try {
            if (enabledProtocols != null || enabledCipherSuites != null) {
                this.createServerSocket(0);
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException();
        }
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)socketFactory.createServerSocket(port);
        if (this.enabledCipherSuites != null) {
            socket.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            socket.setEnabledProtocols(this.enabledProtocols);
        }
        socket.setNeedClientAuth(this.needClientAuth);
        return socket;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SslRMIServerSocketFactory)) {
            return false;
        }
        SslRMIServerSocketFactory s = (SslRMIServerSocketFactory)obj;
        if (this.needClientAuth != s.needClientAuth) {
            return false;
        }
        if (!SslRMIServerSocketFactory.cmpStrArray(this.enabledCipherSuites, s.enabledCipherSuites)) {
            return false;
        }
        return SslRMIServerSocketFactory.cmpStrArray(this.enabledProtocols, s.enabledProtocols);
    }

    static boolean cmpStrArray(String[] a, String[] b) {
        if ((a == null || b == null) && a != b) {
            return false;
        }
        if (a != null) {
            if (a.length != b.length) {
                return false;
            }
            int i = 0;
            while (i < a.length) {
                if (!a[i].equals(b[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public String[] getEnabledCipherSuites() {
        if (this.enabledCipherSuites == null) {
            return null;
        }
        return (String[])this.enabledCipherSuites.clone();
    }

    public String[] getEnabledProtocols() {
        if (this.enabledProtocols == null) {
            return null;
        }
        return (String[])this.enabledProtocols.clone();
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public int hashCode() {
        int i;
        int hash = 0;
        if (this.enabledCipherSuites != null) {
            i = 0;
            while (i < this.enabledCipherSuites.length) {
                hash ^= this.enabledCipherSuites[i].hashCode();
                ++i;
            }
        }
        if (this.enabledProtocols != null) {
            i = 0;
            while (i < this.enabledProtocols.length) {
                hash ^= this.enabledProtocols[i].hashCode();
                ++i;
            }
        }
        hash = this.needClientAuth ? hash ^ 0xFFFF : hash;
        return hash;
    }
}

