/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrivialHostnameVerifier;

public abstract class HttpsURLConnection
extends HttpURLConnection {
    private static HostnameVerifier defaultVerifier;
    private static SSLSocketFactory defaultFactory;
    protected HostnameVerifier hostnameVerifier;
    private SSLSocketFactory factory;

    protected HttpsURLConnection(URL url) {
        super(url);
    }

    public static synchronized HostnameVerifier getDefaultHostnameVerifier() {
        if (defaultVerifier == null) {
            defaultVerifier = new TrivialHostnameVerifier();
        }
        return defaultVerifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultHostnameVerifier(HostnameVerifier newDefault) {
        if (newDefault == null) {
            throw new IllegalArgumentException("default verifier cannot be null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSLPermission("setHostnameVerifier"));
        }
        Class<HttpsURLConnection> clazz = HttpsURLConnection.class;
        synchronized (HttpsURLConnection.class) {
            defaultVerifier = newDefault;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized SSLSocketFactory getDefaultSSLSocketFactory() {
        if (defaultFactory == null) {
            try {
                defaultFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return defaultFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultSSLSocketFactory(SSLSocketFactory newDefault) {
        if (newDefault == null) {
            throw new IllegalArgumentException("default factory cannot be null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        Class<HttpsURLConnection> clazz = HttpsURLConnection.class;
        synchronized (HttpsURLConnection.class) {
            defaultFactory = newDefault;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.hostnameVerifier == null) {
            this.hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        }
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("verifier cannot be null");
        }
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        if (this.factory == null) {
            this.factory = HttpsURLConnection.getDefaultSSLSocketFactory();
        }
        return this.factory;
    }

    public void setSSLSocketFactory(SSLSocketFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        this.factory = factory;
    }

    public Principal getLocalPrincipal() {
        Certificate[] c = this.getLocalCertificates();
        if (c != null && c.length > 0 && c[0] instanceof X509Certificate) {
            return ((X509Certificate)c[0]).getSubjectX500Principal();
        }
        return null;
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        Certificate[] c = this.getServerCertificates();
        if (c != null && c.length > 0 && c[0] instanceof X509Certificate) {
            return ((X509Certificate)c[0]).getSubjectX500Principal();
        }
        return null;
    }

    public abstract String getCipherSuite();

    public abstract Certificate[] getLocalCertificates();

    public abstract Certificate[] getServerCertificates() throws SSLPeerUnverifiedException;
}

