/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleType<T>
extends OpenType<T> {
    public static final SimpleType<BigDecimal> BIGDECIMAL;
    public static final SimpleType<BigInteger> BIGINTEGER;
    public static final SimpleType<Boolean> BOOLEAN;
    public static final SimpleType<Byte> BYTE;
    public static final SimpleType<Character> CHARACTER;
    public static final SimpleType<Date> DATE;
    public static final SimpleType<Double> DOUBLE;
    public static final SimpleType<Float> FLOAT;
    public static final SimpleType<Integer> INTEGER;
    public static final SimpleType<Long> LONG;
    public static final SimpleType<ObjectName> OBJECTNAME;
    public static final SimpleType<Short> SHORT;
    public static final SimpleType<String> STRING;
    public static final SimpleType<Void> VOID;
    private static final long serialVersionUID = 2215577471957694503L;
    private transient Integer hashCode;
    private transient String string;

    static {
        try {
            BIGDECIMAL = new SimpleType("java.math.BigDecimal");
            BIGINTEGER = new SimpleType("java.math.BigInteger");
            BOOLEAN = new SimpleType("java.lang.Boolean");
            BYTE = new SimpleType("java.lang.Byte");
            CHARACTER = new SimpleType("java.lang.Character");
            DATE = new SimpleType("java.util.Date");
            DOUBLE = new SimpleType("java.lang.Double");
            FLOAT = new SimpleType("java.lang.Float");
            INTEGER = new SimpleType("java.lang.Integer");
            LONG = new SimpleType("java.lang.Long");
            OBJECTNAME = new SimpleType("javax.management.ObjectName");
            SHORT = new SimpleType("java.lang.Short");
            STRING = new SimpleType("java.lang.String");
            VOID = new SimpleType("java.lang.Void");
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("A invalid class name was passed to the SimpleType constructor.", e);
        }
    }

    private SimpleType(String name) throws OpenDataException {
        super(name, name, name);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleType)) {
            return false;
        }
        SimpleType sType = (SimpleType)obj;
        return sType.getClassName().equals(this.getClassName());
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.getClassName().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().getName().equals(this.getClassName());
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.equals(BIGDECIMAL)) {
            return BIGDECIMAL;
        }
        if (this.equals(BIGINTEGER)) {
            return BIGINTEGER;
        }
        if (this.equals(BOOLEAN)) {
            return BOOLEAN;
        }
        if (this.equals(BYTE)) {
            return BYTE;
        }
        if (this.equals(CHARACTER)) {
            return CHARACTER;
        }
        if (this.equals(DATE)) {
            return DATE;
        }
        if (this.equals(DOUBLE)) {
            return DOUBLE;
        }
        if (this.equals(FLOAT)) {
            return FLOAT;
        }
        if (this.equals(INTEGER)) {
            return INTEGER;
        }
        if (this.equals(LONG)) {
            return LONG;
        }
        if (this.equals(OBJECTNAME)) {
            return OBJECTNAME;
        }
        if (this.equals(SHORT)) {
            return SHORT;
        }
        if (this.equals(STRING)) {
            return STRING;
        }
        if (this.equals(VOID)) {
            return VOID;
        }
        throw new InvalidObjectException("Invalid simple type instance deserialized.");
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = String.valueOf(this.getClass().getName()) + "[name=" + this.getClassName() + "]";
        }
        return this.string;
    }
}

