/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.CipherSpi;
import javax.crypto.ShortBufferException;

final class NullCipherImpl
extends CipherSpi {
    NullCipherImpl() {
    }

    protected void engineSetMode(String mode) {
    }

    protected void engineSetPadding(String padding) {
    }

    protected int engineGetBlockSize() {
        return 1;
    }

    protected int engineGetOutputSize(int inputLen) {
        return inputLen;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int mode, Key key, SecureRandom random) {
    }

    protected void engineInit(int mode, Key key, AlgorithmParameterSpec spec, SecureRandom random) {
    }

    protected void engineInit(int mode, Key key, AlgorithmParameters params, SecureRandom random) {
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (input == null) {
            return new byte[0];
        }
        if (inputOffset < 0 || inputLen < 0 || inputOffset + inputLen > input.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] output = new byte[inputLen];
        System.arraycopy(input, inputOffset, output, 0, inputLen);
        return output;
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (input == null) {
            return 0;
        }
        if (inputOffset < 0 || inputLen < 0 || inputOffset + inputLen > input.length || outputOffset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (output.length - outputOffset < inputLen) {
            throw new ShortBufferException();
        }
        System.arraycopy(input, inputOffset, output, outputOffset, inputLen);
        return inputLen;
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) {
        return this.engineUpdate(input, inputOffset, inputLen);
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
    }
}

