/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.lang.CPStringBuilder;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    private Arrays() {
    }

    public static int binarySearch(byte[] a, byte key) {
        if (a.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(a, 0, a.length - 1, key);
    }

    public static int binarySearch(byte[] a, int low, int hi, byte key) {
        if (low > hi) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (low < 0 || hi > a.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >>> 1;
            byte d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(char[] a, char key) {
        if (a.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(a, 0, a.length - 1, key);
    }

    public static int binarySearch(char[] a, int low, int hi, char key) {
        if (low > hi) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (low < 0 || hi > a.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >>> 1;
            char d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(short[] a, short key) {
        if (a.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(a, 0, a.length - 1, key);
    }

    public static int binarySearch(short[] a, int low, int hi, short key) {
        if (low > hi) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (low < 0 || hi > a.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >>> 1;
            short d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(int[] a, int key) {
        if (a.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(a, 0, a.length - 1, key);
    }

    public static int binarySearch(int[] a, int low, int hi, int key) {
        if (low > hi) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (low < 0 || hi > a.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >>> 1;
            int d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(long[] a, long key) {
        if (a.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(a, 0, a.length - 1, key);
    }

    public static int binarySearch(long[] a, int low, int hi, long key) {
        if (low > hi) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (low < 0 || hi > a.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >>> 1;
            long d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(float[] a, float key) {
        if (a.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(a, 0, a.length - 1, key);
    }

    public static int binarySearch(float[] a, int low, int hi, float key) {
        if (low > hi) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (low < 0 || hi > a.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >>> 1;
            int r = Float.compare(a[mid], key);
            if (r == 0) {
                return mid;
            }
            if (r > 0) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(double[] a, double key) {
        if (a.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(a, 0, a.length - 1, key);
    }

    public static int binarySearch(double[] a, int low, int hi, double key) {
        if (low > hi) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (low < 0 || hi > a.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >>> 1;
            int r = Double.compare(a[mid], key);
            if (r == 0) {
                return mid;
            }
            if (r > 0) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(Object[] a, Object key) {
        if (a.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(a, key, null);
    }

    public static int binarySearch(Object[] a, int low, int hi, Object key) {
        return Arrays.binarySearch(a, low, hi, key, null);
    }

    public static <T> int binarySearch(T[] a, T key, Comparator<? super T> c) {
        if (a.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(a, 0, a.length - 1, key, c);
    }

    public static <T> int binarySearch(T[] a, int low, int hi, T key, Comparator<? super T> c) {
        if (low > hi) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (low < 0 || hi > a.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >>> 1;
            int d = Collections.compare(a[mid], key, c);
            if (d == 0) {
                return mid;
            }
            if (d > 0) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static boolean equals(boolean[] a1, boolean[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(char[] a1, char[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(short[] a1, short[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(int[] a1, int[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(long[] a1, long[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(float[] a1, float[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (Float.compare(a1[i], a2[i]) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(double[] a1, double[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (Double.compare(a1[i], a2[i]) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(Object[] a1, Object[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (AbstractCollection.equals(a1[i], a2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void fill(boolean[] a, boolean val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(boolean[] a, int fromIndex, int toIndex, boolean val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(byte[] a, byte val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(byte[] a, int fromIndex, int toIndex, byte val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(char[] a, char val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(char[] a, int fromIndex, int toIndex, char val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(short[] a, short val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(short[] a, int fromIndex, int toIndex, short val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(int[] a, int val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(int[] a, int fromIndex, int toIndex, int val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(long[] a, long val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(long[] a, int fromIndex, int toIndex, long val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(float[] a, float val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(float[] a, int fromIndex, int toIndex, float val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(double[] a, double val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(double[] a, int fromIndex, int toIndex, double val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(Object[] a, Object val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(Object[] a, int fromIndex, int toIndex, Object val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void sort(byte[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(byte[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, byte[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static void swap(int i, int j, byte[] a) {
        byte c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, byte[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static void qsort(byte[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = from + count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = array[b] - array[from]) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = array[c] - array[from]) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(char[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(char[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, char[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static void swap(int i, int j, char[] a) {
        char c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, char[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static void qsort(char[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = from + count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = array[b] - array[from]) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = array[c] - array[from]) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(short[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, short[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static void swap(int i, int j, short[] a) {
        short c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, short[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static void qsort(short[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = from + count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = array[b] - array[from]) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = array[c] - array[from]) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(int[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, int[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static void swap(int i, int j, int[] a) {
        int c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, int[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static int compare(int a, int b) {
        return a < b ? -1 : (a == b ? 0 : 1);
    }

    private static void qsort(int[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = from + count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = Arrays.compare(array[b], array[from])) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Arrays.compare(array[c], array[from])) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(long[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(long[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, long[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static void swap(int i, int j, long[] a) {
        long c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, long[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static int compare(long a, long b) {
        return a < b ? -1 : (a == b ? 0 : 1);
    }

    private static void qsort(long[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = from + count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = Arrays.compare(array[b], array[from])) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Arrays.compare(array[c], array[from])) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(float[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(float[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, float[] d) {
        return Float.compare(d[a], d[b]) < 0 ? (Float.compare(d[b], d[c]) < 0 ? b : (Float.compare(d[a], d[c]) < 0 ? c : a)) : (Float.compare(d[b], d[c]) > 0 ? b : (Float.compare(d[a], d[c]) > 0 ? c : a));
    }

    private static void swap(int i, int j, float[] a) {
        float c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, float[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static void qsort(float[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && Float.compare(array[j - 1], array[j]) > 0) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = from + count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = Float.compare(array[b], array[from])) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Float.compare(array[c], array[from])) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(double[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static int med3(int a, int b, int c, double[] d) {
        return Double.compare(d[a], d[b]) < 0 ? (Double.compare(d[b], d[c]) < 0 ? b : (Double.compare(d[a], d[c]) < 0 ? c : a)) : (Double.compare(d[b], d[c]) > 0 ? b : (Double.compare(d[a], d[c]) > 0 ? c : a));
    }

    private static void swap(int i, int j, double[] a) {
        double c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void vecswap(int i, int j, int n, double[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static void qsort(double[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && Double.compare(array[j - 1], array[j]) > 0) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = from + count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = Double.compare(array[b], array[from])) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Double.compare(array[c], array[from])) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(Object[] a) {
        Arrays.sort(a, 0, a.length, null);
    }

    public static <T> void sort(T[] a, Comparator<? super T> c) {
        Arrays.sort(a, 0, a.length, c);
    }

    public static void sort(Object[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex, null);
    }

    public static <T> void sort(T[] a, int fromIndex, int toIndex, Comparator<? super T> c) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex " + fromIndex + " > toIndex " + toIndex);
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int chunk = fromIndex;
        while (chunk < toIndex) {
            int end = Math.min(chunk + 6, toIndex);
            int i = chunk + 1;
            while (i < end) {
                if (Collections.compare(a[i - 1], a[i], c) > 0) {
                    int j = i;
                    T elem = a[j];
                    do {
                        a[j] = a[j - 1];
                    } while (--j > chunk && Collections.compare(a[j - 1], elem, c) > 0);
                    a[j] = elem;
                }
                ++i;
            }
            chunk += 6;
        }
        int len = toIndex - fromIndex;
        if (len <= 6) {
            return;
        }
        Object[] src = a;
        Object[] dest = new Object[len];
        T[] t = null;
        int srcDestDiff = -fromIndex;
        int size = 6;
        while (size < len) {
            int start = fromIndex;
            while (start < toIndex) {
                int mid = start + size;
                int end = Math.min(toIndex, mid + size);
                if (mid >= end || Collections.compare(src[mid - 1], src[mid], c) <= 0) {
                    System.arraycopy(src, start, dest, start + srcDestDiff, end - start);
                } else if (Collections.compare(src[start], src[end - 1], c) > 0) {
                    System.arraycopy(src, start, dest, end - size + srcDestDiff, size);
                    System.arraycopy(src, mid, dest, start + srcDestDiff, end - mid);
                } else {
                    int p1 = start;
                    int p2 = mid;
                    int i = start + srcDestDiff;
                    while (p1 < mid && p2 < end) {
                        dest[i++] = src[Collections.compare(src[p1], src[p2], c) <= 0 ? p1++ : p2++];
                    }
                    if (p1 < mid) {
                        System.arraycopy(src, p1, dest, i, mid - p1);
                    } else {
                        System.arraycopy(src, p2, dest, i, end - p2);
                    }
                }
                start += size << 1;
            }
            t = src;
            src = dest;
            dest = t;
            fromIndex += srcDestDiff;
            toIndex += srcDestDiff;
            srcDestDiff = -srcDestDiff;
            size <<= 1;
        }
        if (src != a) {
            System.arraycopy(src, 0, a, srcDestDiff, toIndex);
        }
    }

    public static <T> List<T> asList(T ... a) {
        return new ArrayList<T>(a);
    }

    public static int hashCode(long[] v) {
        if (v == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < v.length) {
            int elt = (int)(v[i] ^ v[i] >>> 32);
            result = 31 * result + elt;
            ++i;
        }
        return result;
    }

    public static int hashCode(int[] v) {
        if (v == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < v.length) {
            result = 31 * result + v[i];
            ++i;
        }
        return result;
    }

    public static int hashCode(short[] v) {
        if (v == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < v.length) {
            result = 31 * result + v[i];
            ++i;
        }
        return result;
    }

    public static int hashCode(char[] v) {
        if (v == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < v.length) {
            result = 31 * result + v[i];
            ++i;
        }
        return result;
    }

    public static int hashCode(byte[] v) {
        if (v == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < v.length) {
            result = 31 * result + v[i];
            ++i;
        }
        return result;
    }

    public static int hashCode(boolean[] v) {
        if (v == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < v.length) {
            result = 31 * result + (v[i] ? 1231 : 1237);
            ++i;
        }
        return result;
    }

    public static int hashCode(float[] v) {
        if (v == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < v.length) {
            result = 31 * result + Float.floatToIntBits(v[i]);
            ++i;
        }
        return result;
    }

    public static int hashCode(double[] v) {
        if (v == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < v.length) {
            long l = Double.doubleToLongBits(v[i]);
            int elt = (int)(l ^ l >>> 32);
            result = 31 * result + elt;
            ++i;
        }
        return result;
    }

    public static int hashCode(Object[] v) {
        if (v == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < v.length) {
            int elt = v[i] == null ? 0 : v[i].hashCode();
            result = 31 * result + elt;
            ++i;
        }
        return result;
    }

    public static int deepHashCode(Object[] v) {
        if (v == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < v.length) {
            int elt = v[i] == null ? 0 : (v[i] instanceof boolean[] ? Arrays.hashCode((boolean[])v[i]) : (v[i] instanceof byte[] ? Arrays.hashCode((byte[])v[i]) : (v[i] instanceof char[] ? Arrays.hashCode((char[])v[i]) : (v[i] instanceof short[] ? Arrays.hashCode((short[])v[i]) : (v[i] instanceof int[] ? Arrays.hashCode((int[])v[i]) : (v[i] instanceof long[] ? Arrays.hashCode((long[])v[i]) : (v[i] instanceof float[] ? Arrays.hashCode((float[])v[i]) : (v[i] instanceof double[] ? Arrays.hashCode((double[])v[i]) : (v[i] instanceof Object[] ? Arrays.hashCode((Object[])v[i]) : v[i].hashCode())))))))));
            result = 31 * result + elt;
            ++i;
        }
        return result;
    }

    public static boolean deepEquals(Object[] v1, Object[] v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null || v1.length != v2.length) {
            return false;
        }
        int i = 0;
        while (i < v1.length) {
            Object e1 = v1[i];
            Object e2 = v2[i];
            if (e1 != e2) {
                if (e1 == null || e2 == null) {
                    return false;
                }
                boolean check = e1 instanceof boolean[] && e2 instanceof boolean[] ? Arrays.equals((boolean[])e1, (boolean[])e2) : (e1 instanceof byte[] && e2 instanceof byte[] ? Arrays.equals((byte[])e1, (byte[])e2) : (e1 instanceof char[] && e2 instanceof char[] ? Arrays.equals((char[])e1, (char[])e2) : (e1 instanceof short[] && e2 instanceof short[] ? Arrays.equals((short[])e1, (short[])e2) : (e1 instanceof int[] && e2 instanceof int[] ? Arrays.equals((int[])e1, (int[])e2) : (e1 instanceof long[] && e2 instanceof long[] ? Arrays.equals((long[])e1, (long[])e2) : (e1 instanceof float[] && e2 instanceof float[] ? Arrays.equals((float[])e1, (float[])e2) : (e1 instanceof double[] && e2 instanceof double[] ? Arrays.equals((double[])e1, (double[])e2) : (e1 instanceof Object[] && e2 instanceof Object[] ? Arrays.equals((Object[])e1, (Object[])e2) : e1.equals(e2)))))))));
                if (!check) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static String toString(boolean[] v) {
        if (v == null) {
            return "null";
        }
        CPStringBuilder b = new CPStringBuilder("[");
        int i = 0;
        while (i < v.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(v[i]);
            ++i;
        }
        b.append("]");
        return b.toString();
    }

    public static String toString(byte[] v) {
        if (v == null) {
            return "null";
        }
        CPStringBuilder b = new CPStringBuilder("[");
        int i = 0;
        while (i < v.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(v[i]);
            ++i;
        }
        b.append("]");
        return b.toString();
    }

    public static String toString(char[] v) {
        if (v == null) {
            return "null";
        }
        CPStringBuilder b = new CPStringBuilder("[");
        int i = 0;
        while (i < v.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(v[i]);
            ++i;
        }
        b.append("]");
        return b.toString();
    }

    public static String toString(short[] v) {
        if (v == null) {
            return "null";
        }
        CPStringBuilder b = new CPStringBuilder("[");
        int i = 0;
        while (i < v.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(v[i]);
            ++i;
        }
        b.append("]");
        return b.toString();
    }

    public static String toString(int[] v) {
        if (v == null) {
            return "null";
        }
        CPStringBuilder b = new CPStringBuilder("[");
        int i = 0;
        while (i < v.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(v[i]);
            ++i;
        }
        b.append("]");
        return b.toString();
    }

    public static String toString(long[] v) {
        if (v == null) {
            return "null";
        }
        CPStringBuilder b = new CPStringBuilder("[");
        int i = 0;
        while (i < v.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(v[i]);
            ++i;
        }
        b.append("]");
        return b.toString();
    }

    public static String toString(float[] v) {
        if (v == null) {
            return "null";
        }
        CPStringBuilder b = new CPStringBuilder("[");
        int i = 0;
        while (i < v.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(v[i]);
            ++i;
        }
        b.append("]");
        return b.toString();
    }

    public static String toString(double[] v) {
        if (v == null) {
            return "null";
        }
        CPStringBuilder b = new CPStringBuilder("[");
        int i = 0;
        while (i < v.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(v[i]);
            ++i;
        }
        b.append("]");
        return b.toString();
    }

    public static String toString(Object[] v) {
        if (v == null) {
            return "null";
        }
        CPStringBuilder b = new CPStringBuilder("[");
        int i = 0;
        while (i < v.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(v[i]);
            ++i;
        }
        b.append("]");
        return b.toString();
    }

    private static void deepToString(Object[] v, CPStringBuilder b, HashSet seen) {
        b.append("[");
        int i = 0;
        while (i < v.length) {
            Object elt;
            if (i > 0) {
                b.append(", ");
            }
            if ((elt = v[i]) == null) {
                b.append("null");
            } else if (elt instanceof boolean[]) {
                b.append(Arrays.toString((boolean[])elt));
            } else if (elt instanceof byte[]) {
                b.append(Arrays.toString((byte[])elt));
            } else if (elt instanceof char[]) {
                b.append(Arrays.toString((char[])elt));
            } else if (elt instanceof short[]) {
                b.append(Arrays.toString((short[])elt));
            } else if (elt instanceof int[]) {
                b.append(Arrays.toString((int[])elt));
            } else if (elt instanceof long[]) {
                b.append(Arrays.toString((long[])elt));
            } else if (elt instanceof float[]) {
                b.append(Arrays.toString((float[])elt));
            } else if (elt instanceof double[]) {
                b.append(Arrays.toString((double[])elt));
            } else if (elt instanceof Object[]) {
                Object[] os = (Object[])elt;
                if (seen.contains(os)) {
                    b.append("[...]");
                } else {
                    seen.add(os);
                    Arrays.deepToString(os, b, seen);
                }
            } else {
                b.append(elt);
            }
            ++i;
        }
        b.append("]");
    }

    public static String deepToString(Object[] v) {
        if (v == null) {
            return "null";
        }
        HashSet seen = new HashSet();
        CPStringBuilder b = new CPStringBuilder();
        Arrays.deepToString(v, b, seen);
        return b.toString();
    }

    public static boolean[] copyOf(boolean[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static boolean[] copyOfRange(boolean[] original, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        boolean[] newArray = new boolean[to - from];
        if (to > original.length) {
            System.arraycopy(original, from, newArray, 0, original.length - from);
            Arrays.fill(newArray, original.length, newArray.length, false);
        } else {
            System.arraycopy(original, from, newArray, 0, to - from);
        }
        return newArray;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        byte[] newArray = new byte[to - from];
        if (to > original.length) {
            System.arraycopy(original, from, newArray, 0, original.length - from);
            Arrays.fill(newArray, original.length, newArray.length, (byte)0);
        } else {
            System.arraycopy(original, from, newArray, 0, to - from);
        }
        return newArray;
    }

    public static char[] copyOf(char[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static char[] copyOfRange(char[] original, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        char[] newArray = new char[to - from];
        if (to > original.length) {
            System.arraycopy(original, from, newArray, 0, original.length - from);
            Arrays.fill(newArray, original.length, newArray.length, '\u0000');
        } else {
            System.arraycopy(original, from, newArray, 0, to - from);
        }
        return newArray;
    }

    public static double[] copyOf(double[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static double[] copyOfRange(double[] original, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        double[] newArray = new double[to - from];
        if (to > original.length) {
            System.arraycopy(original, from, newArray, 0, original.length - from);
            Arrays.fill(newArray, original.length, newArray.length, 0.0);
        } else {
            System.arraycopy(original, from, newArray, 0, to - from);
        }
        return newArray;
    }

    public static float[] copyOf(float[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static float[] copyOfRange(float[] original, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        float[] newArray = new float[to - from];
        if (to > original.length) {
            System.arraycopy(original, from, newArray, 0, original.length - from);
            Arrays.fill(newArray, original.length, newArray.length, 0.0f);
        } else {
            System.arraycopy(original, from, newArray, 0, to - from);
        }
        return newArray;
    }

    public static int[] copyOf(int[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static int[] copyOfRange(int[] original, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        int[] newArray = new int[to - from];
        if (to > original.length) {
            System.arraycopy(original, from, newArray, 0, original.length - from);
            Arrays.fill(newArray, original.length, newArray.length, 0);
        } else {
            System.arraycopy(original, from, newArray, 0, to - from);
        }
        return newArray;
    }

    public static long[] copyOf(long[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static long[] copyOfRange(long[] original, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        long[] newArray = new long[to - from];
        if (to > original.length) {
            System.arraycopy(original, from, newArray, 0, original.length - from);
            Arrays.fill(newArray, original.length, newArray.length, 0L);
        } else {
            System.arraycopy(original, from, newArray, 0, to - from);
        }
        return newArray;
    }

    public static short[] copyOf(short[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static short[] copyOfRange(short[] original, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        short[] newArray = new short[to - from];
        if (to > original.length) {
            System.arraycopy(original, from, newArray, 0, original.length - from);
            Arrays.fill(newArray, original.length, newArray.length, (short)0);
        } else {
            System.arraycopy(original, from, newArray, 0, to - from);
        }
        return newArray;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(original, 0, newLength);
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        Class<?> elemType = original.getClass().getComponentType();
        Object[] newArray = (Object[])Array.newInstance(elemType, to - from);
        if (to > original.length) {
            System.arraycopy(original, from, newArray, 0, original.length - from);
            Arrays.fill(newArray, original.length, newArray.length, null);
        } else {
            System.arraycopy(original, from, newArray, 0, to - from);
        }
        return newArray;
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        if (newLength < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(original, 0, newLength, newType);
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        if (from > to) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        Object[] newArray = (Object[])Array.newInstance(newType.getComponentType(), to - from);
        if (to > original.length) {
            System.arraycopy(original, from, newArray, 0, original.length - from);
            Arrays.fill(newArray, original.length, newArray.length, null);
        } else {
            System.arraycopy(original, from, newArray, 0, to - from);
        }
        return newArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = -2764017481108945198L;
        private final E[] a;

        ArrayList(E[] a) {
            if (a == null) {
                throw new NullPointerException();
            }
            this.a = a;
        }

        @Override
        public E get(int index) {
            return this.a[index];
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public E set(int index, E element) {
            E old = this.a[index];
            this.a[index] = element;
            return old;
        }

        @Override
        public boolean contains(Object o) {
            return this.lastIndexOf(o) >= 0;
        }

        @Override
        public int indexOf(Object o) {
            int size = this.a.length;
            int i = 0;
            while (i < size) {
                if (ArrayList.equals(o, this.a[i])) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            int i = this.a.length;
            while (--i >= 0) {
                if (!ArrayList.equals(o, this.a[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int size = this.a.length;
            if (array.length < size) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            } else if (array.length > size) {
                array[size] = null;
            }
            System.arraycopy(this.a, 0, array, 0, size);
            return array;
        }
    }
}

