/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Collator;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollationKey
implements Comparable<CollationKey> {
    private Collator collator;
    private String originalText;
    private byte[] key;

    CollationKey(Collator collator, String originalText, byte[] key) {
        this.collator = collator;
        this.originalText = originalText;
        this.key = key;
    }

    @Override
    public int compareTo(CollationKey ck) {
        int max = Math.min(this.key.length, ck.key.length);
        int i = 0;
        while (i < max) {
            if (this.key[i] != ck.key[i]) {
                return this.key[i] - ck.key[i];
            }
            ++i;
        }
        return this.key.length - ck.key.length;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CollationKey)) {
            return false;
        }
        CollationKey ck = (CollationKey)obj;
        if (ck.collator != this.collator) {
            return false;
        }
        if (!ck.getSourceString().equals(this.getSourceString())) {
            return false;
        }
        return Arrays.equals(ck.toByteArray(), this.toByteArray());
    }

    public String getSourceString() {
        return this.originalText;
    }

    public int hashCode() {
        long h = this.originalText.hashCode();
        int i = this.key.length - 1;
        while (i >= 0) {
            h ^= (long)(this.key[i] * (i + 1));
            --i;
        }
        return (int)(h >> 32 ^ h);
    }

    public byte[] toByteArray() {
        return this.key;
    }
}

