/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.Serializable;
import java.math.RoundingMode;

public final class MathContext
implements Serializable {
    public static final MathContext UNLIMITED = new MathContext(0, RoundingMode.HALF_UP);
    public static final MathContext DECIMAL32 = new MathContext(7, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL64 = new MathContext(16, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL128 = new MathContext(34, RoundingMode.HALF_EVEN);
    private static final long serialVersionUID = 5579720004786848255L;
    private int precision;
    private RoundingMode roundMode;

    public MathContext(int setPrecision) {
        this(setPrecision, RoundingMode.HALF_UP);
    }

    public MathContext(int setPrecision, RoundingMode setRoundingMode) {
        if (setPrecision < 0) {
            throw new IllegalArgumentException("Precision cannot be less than zero.");
        }
        this.precision = setPrecision;
        this.roundMode = setRoundingMode;
    }

    public MathContext(String val) {
        try {
            int roundingModeIndex = val.indexOf("roundingMode", 10);
            this.precision = Integer.parseInt(val.substring(10, roundingModeIndex - 1));
            this.roundMode = RoundingMode.valueOf(val.substring(roundingModeIndex + 13));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("String not in correct format");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("String not in correct format");
        }
        if (this.precision < 0) {
            throw new IllegalArgumentException("Precision cannot be less than 0.");
        }
    }

    public boolean equals(Object x) {
        if (!(x instanceof MathContext)) {
            return false;
        }
        MathContext mc = (MathContext)x;
        return mc.precision == this.precision && mc.roundMode.equals((Object)this.roundMode);
    }

    public int getPrecision() {
        return this.precision;
    }

    public RoundingMode getRoundingMode() {
        return this.roundMode;
    }

    public String toString() {
        return "precision=" + this.precision + " roundingMode=" + (Object)((Object)this.roundMode);
    }

    public int hashCode() {
        return this.precision ^ this.roundMode.hashCode();
    }
}

