/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    private static final int DEFAULT_BUFFER_SIZE = 1;
    private char[] buf;
    private int pos;

    public PushbackReader(Reader in) {
        this(in, 1);
    }

    public PushbackReader(Reader in, int bufsize) {
        super(in);
        if (bufsize < 0) {
            throw new IllegalArgumentException("buffer size must be positive");
        }
        this.buf = new char[bufsize];
        this.pos = bufsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.buf = null;
            super.close();
        }
    }

    public void mark(int read_limit) throws IOException {
        throw new IOException("mark not supported in this class");
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported in this class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (this.buf == null) {
                    throw new IOException("stream closed");
                }
                if (this.buf.length - this.pos <= 0 && !super.ready()) break block5;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long num_chars) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (num_chars > 0L) break block5;
                return 0L;
            }
            if ((long)(this.buf.length - this.pos) >= num_chars) {
                this.pos = (int)((long)this.pos + num_chars);
                return num_chars;
            }
            int chars_discarded = this.buf.length - this.pos;
            this.pos = this.buf.length;
            long chars_skipped = this.in.skip(num_chars - (long)chars_discarded);
            return (long)chars_discarded + chars_skipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("stream closed");
            }
            if (this.pos == this.buf.length) {
                return super.read();
            }
            ++this.pos;
            return this.buf[this.pos - 1] & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(char[] buffer, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("stream closed");
            }
            if (offset < 0 || length < 0 || offset + length > buffer.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int numBytes = Math.min(this.buf.length - this.pos, length);
            if (numBytes > 0) {
                System.arraycopy(this.buf, this.pos, buffer, offset, numBytes);
                this.pos += numBytes;
                return numBytes;
            }
            return super.read(buffer, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(int b) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("stream closed");
            }
            if (this.pos == 0) {
                throw new IOException("Pushback buffer is full");
            }
            --this.pos;
            this.buf[this.pos] = (char)(b & 0xFFFF);
        }
    }

    public synchronized void unread(char[] buf) throws IOException {
        this.unread(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unread(char[] buffer, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("stream closed");
            }
            if (this.pos < length) {
                throw new IOException("Pushback buffer is full");
            }
            System.arraycopy(buffer, offset, this.buf, this.pos - length, length);
            this.pos -= length;
        }
    }
}

