/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private Writer out;
    char[] buffer;
    int count;

    public BufferedWriter(Writer out) {
        this(out, 8192);
    }

    public BufferedWriter(Writer out, int size) {
        super(out.lock);
        this.out = out;
        this.buffer = new char[size];
        this.count = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.localFlush();
            this.out.close();
            this.buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer == null) {
                throw new IOException("Stream closed");
            }
            this.localFlush();
            this.out.flush();
        }
    }

    public void newLine() throws IOException {
        this.write(System.getProperty("line.separator"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer == null) {
                throw new IOException("Stream closed");
            }
            this.buffer[this.count++] = (char)oneChar;
            if (this.count == this.buffer.length) {
                this.localFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int offset, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer == null) {
                throw new IOException("Stream closed");
            }
            if (this.count + len > this.buffer.length) {
                this.localFlush();
                this.out.write(buf, offset, len);
            } else {
                System.arraycopy(buf, offset, this.buffer, this.count, len);
                this.count += len;
                if (this.count == this.buffer.length) {
                    this.localFlush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int offset, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer == null) {
                throw new IOException("Stream closed");
            }
            if (this.count + len > this.buffer.length) {
                this.localFlush();
                this.out.write(str, offset, len);
            } else {
                str.getChars(offset, offset + len, this.buffer, this.count);
                this.count += len;
                if (this.count == this.buffer.length) {
                    this.localFlush();
                }
            }
        }
    }

    private void localFlush() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buffer, 0, this.count);
            this.count = 0;
        }
    }
}

