/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupTable;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class LookupOp
implements BufferedImageOp,
RasterOp {
    private LookupTable lut;
    private RenderingHints hints;

    public LookupOp(LookupTable lookup, RenderingHints hints) {
        this.lut = lookup;
        this.hints = hints;
    }

    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (src.getColorModel() instanceof IndexColorModel) {
            throw new IllegalArgumentException("LookupOp.filter: IndexColorModel not allowed");
        }
        if (this.lut.getNumComponents() != 1 && this.lut.getNumComponents() != src.getColorModel().getNumComponents() && this.lut.getNumComponents() != src.getColorModel().getNumColorComponents()) {
            throw new IllegalArgumentException("LookupOp.filter: Incompatible lookup table and source image");
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        } else if (src.getHeight() != dst.getHeight() || src.getWidth() != dst.getWidth()) {
            throw new IllegalArgumentException("Source and destination images are different sizes.");
        }
        BufferedImage tgt = dst.getColorModel().equals(src.getColorModel()) ? dst : this.createCompatibleDestImage(src, src.getColorModel());
        WritableRaster sr = src.getRaster();
        WritableRaster dr = tgt.getRaster();
        if (src.getColorModel().hasAlpha() && (this.lut.getNumComponents() == 1 || this.lut.getNumComponents() == src.getColorModel().getNumColorComponents())) {
            int[] dbuf = new int[src.getColorModel().getNumComponents()];
            int tmpBands = src.getColorModel().getNumColorComponents();
            int[] tmp = new int[tmpBands];
            int y = src.getMinY();
            while (y < src.getHeight() + src.getMinY()) {
                int x = src.getMinX();
                while (x < src.getWidth() + src.getMinX()) {
                    sr.getPixel(x, y, dbuf);
                    System.arraycopy(dbuf, 0, tmp, 0, tmpBands);
                    dr.setPixel(x, y, this.lut.lookupPixel(tmp, dbuf));
                    ++x;
                }
                ++y;
            }
        } else {
            int[] dbuf = new int[src.getColorModel().getNumComponents()];
            int y = src.getMinY();
            while (y < src.getHeight() + src.getMinY()) {
                int x = src.getMinX();
                while (x < src.getWidth() + src.getMinX()) {
                    dr.setPixel(x, y, this.lut.lookupPixel(sr.getPixel(x, y, dbuf), dbuf));
                    ++x;
                }
                ++y;
            }
        }
        if (tgt != dst) {
            new ColorConvertOp(this.hints).filter(tgt, dst);
        }
        return dst;
    }

    public final Rectangle2D getBounds2D(BufferedImage src) {
        return src.getRaster().getBounds();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        if (dstCM != null) {
            return new BufferedImage(dstCM, src.getRaster().createCompatibleWritableRaster(), src.isAlphaPremultiplied(), null);
        }
        int imgType = src.getType();
        if (imgType == 11) {
            imgType = 10;
        }
        return new BufferedImage(src.getWidth(), src.getHeight(), imgType);
    }

    public final Point2D getPoint2D(Point2D src, Point2D dst) {
        if (dst == null) {
            return (Point2D)src.clone();
        }
        dst.setLocation(src);
        return dst;
    }

    public final LookupTable getTable() {
        return this.lut;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final WritableRaster filter(Raster src, WritableRaster dest) {
        if (dest == null) {
            dest = this.createCompatibleDestRaster(src);
        } else if (src.getNumBands() != dest.getNumBands()) {
            throw new IllegalArgumentException("Source and destination rasters are incompatible.");
        }
        if (this.lut.getNumComponents() != 1 && this.lut.getNumComponents() != src.getNumBands()) {
            throw new IllegalArgumentException("Lookup table is incompatible with this raster.");
        }
        int[] tmp = new int[src.getNumBands()];
        int y = src.getMinY();
        while (y < src.getHeight() + src.getMinY()) {
            int x = src.getMinX();
            while (x < src.getWidth() + src.getMinX()) {
                dest.setPixel(x, y, this.lut.lookupPixel(src.getPixel(x, y, tmp), tmp));
                ++x;
            }
            ++y;
        }
        return dest;
    }

    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }
}

