/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser.models;

import gnu.java.lang.CPStringBuilder;
import gnu.javax.swing.text.html.parser.models.node;
import java.io.Serializable;

public class list
extends node
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static boolean CLEAR;
    public final node[] nodes;

    public list(char binary_operator, char unary_operator, node[] a_nodes) {
        super(binary_operator, unary_operator, a_nodes);
        this.nodes = a_nodes;
    }

    public list(node[] a_nodes) throws Error {
        this(',', '\u0000', a_nodes);
        char operation = this.nodes[0].binary;
        int i = 0;
        while (i < this.nodes.length) {
            if (CLEAR && this.nodes[i].binary != operation) {
                throw new Error("List members can only be connected by the same operation, use grouping");
            }
            if (i > 0) {
                this.nodes[i].previous = this.nodes[i - 1];
            }
            ++i;
        }
    }

    public boolean isClosed() {
        if (super.isClosed()) {
            return true;
        }
        int i = 0;
        while (i < this.nodes.length) {
            if (!this.nodes[i].isClosed()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object findFreeNode() {
        int j = 0;
        while (j < this.nodes.length) {
            Object fn;
            if (!this.nodes[j].isClosed() && (fn = this.nodes[j].findFreeNode()) != null) {
                return fn;
            }
            ++j;
        }
        return null;
    }

    public boolean matches(Object[] tokens) {
        this.reset();
        boolean matched = false;
        int i = 0;
        while (i < tokens.length) {
            matched = false;
            Object x = tokens[i];
            int j = 0;
            while (j < this.nodes.length) {
                boolean m;
                if (!this.nodes[j].isClosed() && (m = this.nodes[j].performMatch(x))) {
                    matched = true;
                    break;
                }
                ++j;
            }
            if (!matched) {
                return false;
            }
            ++i;
        }
        boolean valid = true;
        int i2 = 0;
        while (i2 < this.nodes.length) {
            if (!this.nodes[i2].valid()) {
                valid = false;
            }
            ++i2;
        }
        return valid;
    }

    public boolean mustClose() {
        return false;
    }

    public boolean performMatch(Object token) {
        boolean ok = false;
        int i = 0;
        while (i < this.nodes.length) {
            ok = this.nodes[i].performMatch(token);
            if (ok) break;
            ++i;
        }
        if (ok) {
            this.matches();
        }
        return ok;
    }

    public void reset() {
        super.reset();
        int i = 0;
        while (i < this.nodes.length) {
            this.nodes[i].reset();
            ++i;
        }
    }

    public Object show(Object x) {
        boolean matched = false;
        int j = 0;
        while (j < this.nodes.length) {
            if (!this.nodes[j].isClosed()) {
                boolean m = this.nodes[j].performMatch(x);
                if (m) {
                    matched = true;
                    break;
                }
                if (this.binary == ',' && this.nodes[j].unary != '?' && this.nodes[j].unary != '*') break;
            }
            ++j;
        }
        if (!matched) {
            Object freeNode = this.findFreeNode();
            if (freeNode == null) {
                return Boolean.FALSE;
            }
            return freeNode;
        }
        int i = 0;
        while (i < this.nodes.length) {
            if (!this.nodes[i].validPreliminary()) {
                return Boolean.FALSE;
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    public String toString() {
        CPStringBuilder b = new CPStringBuilder();
        b.append(" ( ");
        int i = 0;
        while (i < this.nodes.length) {
            if (i > 0) {
                b.append(" " + this.nodes[i].binary + " ");
            }
            b.append(this.nodes[i]);
            ++i;
        }
        b.append(" )");
        if (this.unary != '\u0000') {
            b.append(this.unary);
        } else {
            b.append(' ');
        }
        return b.toString();
    }

    public boolean valid() {
        int i = 0;
        while (i < this.nodes.length) {
            if (!this.nodes[i].valid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean validPreliminary() {
        if (this.silenceAllowed()) {
            boolean everVisited = false;
            int i = 0;
            while (i < this.nodes.length) {
                if (this.nodes[i].visits > 0) {
                    everVisited = true;
                    break;
                }
                ++i;
            }
            if (!everVisited) {
                return true;
            }
        }
        int i = 0;
        while (i < this.nodes.length) {
            if (!this.nodes[i].validPreliminary()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void close() {
        super.close();
        int i = 0;
        while (i < this.nodes.length) {
            this.nodes[i].close();
            ++i;
        }
    }

    protected boolean compare(Object a_token) {
        return this.performMatch(a_token);
    }
}

