/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.sampled.gstreamer.io;

import gnu.java.lang.CPStringBuilder;
import gnu.javax.sound.sampled.gstreamer.io.GstAudioFileReaderNativePeer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class GstAudioFileReader
extends AudioFileReader {
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        CPStringBuilder name = new CPStringBuilder(file.getName());
        String _name = name.substring(name.lastIndexOf(".") + 1);
        return this.getAudioFileFormat(new BufferedInputStream(new FileInputStream(file)), _name);
    }

    public AudioFileFormat getAudioFileFormat(InputStream is) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(is, null);
    }

    private AudioFileFormat getAudioFileFormat(InputStream is, String extension) throws UnsupportedAudioFileException {
        AudioFormat format = null;
        try {
            format = GstAudioFileReaderNativePeer.getAudioFormat(is);
        }
        catch (Exception exception) {
            UnsupportedAudioFileException ex = new UnsupportedAudioFileException("Unsupported encoding.");
            ex.initCause(ex.getCause());
            throw ex;
        }
        if (format == null) {
            throw new UnsupportedAudioFileException("Unsupported encoding.");
        }
        String name = format.getProperty("decoder").toString();
        if (extension == null) {
            extension = format.getProperty("ext").toString();
        }
        AudioFileFormat.Type type = new AudioFileFormat.Type(name, extension);
        return new AudioFileFormat(type, format, -1);
    }

    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(new BufferedInputStream(url.openStream()));
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream stream = new FileInputStream(file);
        long length = file.length();
        AudioFormat format = null;
        try {
            format = GstAudioFileReaderNativePeer.getAudioFormat(file);
        }
        catch (Exception exception) {
            UnsupportedAudioFileException ex = new UnsupportedAudioFileException("Unsupported encoding.");
            ex.initCause(ex.getCause());
            throw ex;
        }
        if (format == null) {
            throw new UnsupportedAudioFileException("Unsupported encoding.");
        }
        return new AudioInputStream(stream, format, length);
    }

    public AudioInputStream getAudioInputStream(InputStream is) throws UnsupportedAudioFileException, IOException {
        AudioFormat format = null;
        try {
            format = GstAudioFileReaderNativePeer.getAudioFormat(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (format == null) {
            throw new UnsupportedAudioFileException("Unsupported encoding.");
        }
        return new AudioInputStream(is, format, -1L);
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(new BufferedInputStream(url.openStream()));
    }
}

