/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.SSLContextImpl;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.SSLSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;

public class SSLSocketFactoryImpl
extends SSLSocketFactory {
    private final SSLContextImpl contextImpl;

    public SSLSocketFactoryImpl(SSLContextImpl contextImpl) {
        this.contextImpl = contextImpl;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return new SSLSocketImpl(this.contextImpl, host, port, socket, autoClose);
    }

    public String[] getDefaultCipherSuites() {
        return SSLEngineImpl.defaultSuites();
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public SSLSocketImpl createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.createSocket(host, port, null, 0);
    }

    public SSLSocketImpl createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        SSLSocketImpl socket = new SSLSocketImpl(this.contextImpl, host, port);
        InetSocketAddress endpoint = new InetSocketAddress(host, port);
        socket.bind(new InetSocketAddress(localHost, localPort));
        socket.connect(endpoint);
        return socket;
    }

    public SSLSocketImpl createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(host, port, null, 0);
    }

    public SSLSocketImpl createSocket(InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocketImpl socket = new SSLSocketImpl(this.contextImpl, host.getCanonicalHostName(), port);
        socket.bind(new InetSocketAddress(localHost, localPort));
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }

    public Socket createSocket() throws IOException {
        return new SSLSocketImpl(this.contextImpl, null, -1, new Socket(), true);
    }
}

