/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.management;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.management.JMX;
import javax.management.MBeanServerInvocationHandler;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Translator {
    public static final Object[] fromJava(Object[] jtypes, Method method) throws Throwable {
        Type[] gtypes = method.getGenericParameterTypes();
        Object[] otypes = new Object[jtypes.length];
        int a = 0;
        while (a < jtypes.length) {
            otypes[a] = Translator.fromJava(jtypes[a], gtypes[a]);
            ++a;
        }
        return otypes;
    }

    public static final Object fromJava(Object jtype, Type type) throws Throwable {
        if (jtype == null) {
            return null;
        }
        Class<? extends Object> jclass = jtype.getClass();
        if (OpenType.ALLOWED_CLASSNAMES_LIST.contains(jclass.getName())) {
            return jtype;
        }
        if (jclass.isArray()) {
            Class<?> ctype = jclass.getComponentType();
            if (ctype.isPrimitive()) {
                return jtype;
            }
            if (OpenType.ALLOWED_CLASSNAMES_LIST.contains(ctype.getName())) {
                return jtype;
            }
            Object[] elems = (Object[])jtype;
            Object[] celems = new Object[elems.length];
            int a = 0;
            while (a < elems.length) {
                celems[a] = Translator.fromJava(elems[a], elems[a].getClass());
                ++a;
            }
            return Translator.makeArraySpecific(celems);
        }
        String tName = Translator.getTypeName(type);
        if (jtype instanceof List || jtype instanceof Set || jtype instanceof SortedSet) {
            if (jtype instanceof SortedSet) {
                ParameterizedType ptype = (ParameterizedType)type;
                Class elemClass = (Class)ptype.getActualTypeArguments()[0];
                if (!Comparable.class.isAssignableFrom(elemClass)) {
                    throw new IllegalArgumentException(jtype + " has a " + "non-comparable element " + "type, " + elemClass);
                }
                if (((SortedSet)jtype).comparator() != null) {
                    throw new IllegalArgumentException(jtype + " does not " + "use natural ordering.");
                }
            }
            Collection elems = (Collection)jtype;
            int numElems = elems.size();
            Object[] celems = new Object[numElems];
            Iterator i = elems.iterator();
            int a = 0;
            while (a < numElems) {
                Object elem = i.next();
                celems[a] = Translator.fromJava(elem, elem.getClass());
                ++a;
            }
            return Translator.makeArraySpecific(celems);
        }
        if (jtype instanceof Enum) {
            return ((Enum)jtype).name();
        }
        if (jtype instanceof Map || jtype instanceof SortedMap) {
            int lparam = tName.indexOf("<");
            int comma = tName.indexOf(",", lparam);
            int rparam = tName.indexOf(">", comma);
            String key = tName.substring(lparam + 1, comma).trim();
            String value = tName.substring(comma + 1, rparam).trim();
            String typeName = null;
            if (jtype instanceof Map) {
                typeName = "java.util.Map" + tName.substring(lparam);
            } else {
                Class<?> keyClass = Class.forName(key);
                if (!Comparable.class.isAssignableFrom(keyClass)) {
                    throw new IllegalArgumentException(jtype + " has a " + "non-comparable element " + "type, " + keyClass);
                }
                if (((SortedMap)jtype).comparator() != null) {
                    throw new IllegalArgumentException(jtype + " does not " + "use natural ordering.");
                }
                typeName = "java.util.SortedMap" + tName.substring(lparam);
            }
            OpenType<?> k = Translator.translate(key).getOpenType();
            OpenType<?> v = Translator.translate(value).getOpenType();
            CompositeType rowType = new CompositeType(typeName, typeName, new String[]{"key", "value"}, new String[]{"Map key", "Map value"}, new OpenType[]{k, v});
            TabularType tabType = new TabularType(typeName, typeName, rowType, new String[]{"key"});
            TabularDataSupport data = new TabularDataSupport(tabType);
            for (Map.Entry entry : ((Map)jtype).entrySet()) {
                try {
                    data.put(new CompositeDataSupport(rowType, new String[]{"key", "value"}, new Object[]{entry.getKey(), entry.getValue()}));
                }
                catch (OpenDataException e) {
                    throw (InternalError)new InternalError("A problem occurred converting the map to a composite data structure.").initCause(e);
                }
            }
            return data;
        }
        if (JMX.isMXBeanInterface(jclass)) {
            try {
                MBeanServerInvocationHandler ih = (MBeanServerInvocationHandler)Proxy.getInvocationHandler(jtype);
                return ih.getObjectName();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("For a MXBean to be translated to an open type, it must be a proxy.", e);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("For a MXBean to be translated to an open type, it must have a MBeanServerInvocationHandler.", e);
            }
        }
        throw new IllegalArgumentException("The type, " + jtype + ", is not convertible.");
    }

    public static final Object toJava(Object otype, Method method) throws Throwable {
        int n;
        int n2;
        Object[] objectArray;
        Class<?> returnType = method.getReturnType();
        if (returnType.isEnum()) {
            String ename = (String)otype;
            Enum[] constants = (Enum[])returnType.getEnumConstants();
            objectArray = constants;
            n2 = constants.length;
            n = 0;
            while (n < n2) {
                Object c = objectArray[n];
                if (((Enum)c).name().equals(ename)) {
                    return c;
                }
                ++n;
            }
        }
        if (List.class.isAssignableFrom(returnType)) {
            Object[] elems = (Object[])otype;
            ArrayList<Object> l = new ArrayList<Object>(elems.length);
            objectArray = elems;
            n2 = elems.length;
            n = 0;
            while (n < n2) {
                Object elem = objectArray[n];
                l.add(elem);
                ++n;
            }
            return l;
        }
        if (Map.class.isAssignableFrom(returnType)) {
            TabularData data = (TabularData)otype;
            HashMap<Object, Object> m = new HashMap<Object, Object>(data.size());
            for (Object val : data.values()) {
                CompositeData vals = (CompositeData)val;
                m.put(vals.get("key"), vals.get("value"));
            }
            return m;
        }
        try {
            Method m = returnType.getMethod("from", CompositeData.class);
            return m.invoke(null, (CompositeData)otype);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return otype;
        }
    }

    private static final Object[] makeArraySpecific(Object[] arr) {
        Object[] rcelems = (Object[])Array.newInstance(arr[0].getClass(), arr.length);
        System.arraycopy(arr, 0, rcelems, 0, arr.length);
        return rcelems;
    }

    public static final OpenMBeanParameterInfo translate(String type) throws OpenDataException {
        Class<?> c;
        if (type.equals("boolean") || type.equals(Boolean.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.BOOLEAN, null, new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        }
        if (type.equals("byte") || type.equals(Byte.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.BYTE, null, Byte.valueOf((byte)-128), Byte.valueOf((byte)127));
        }
        if (type.equals("char") || type.equals(Character.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.CHARACTER, null, Character.valueOf('\u0000'), Character.valueOf('\uffff'));
        }
        if (type.equals("double") || type.equals(Double.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.DOUBLE, null, Double.valueOf(Double.MIN_VALUE), Double.valueOf(Double.MAX_VALUE));
        }
        if (type.equals("float") || type.equals(Float.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.FLOAT, null, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
        }
        if (type.equals("int") || type.equals(Integer.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.INTEGER, null, Integer.valueOf(Integer.MIN_VALUE), Integer.valueOf(Integer.MAX_VALUE));
        }
        if (type.equals("long") || type.equals(Long.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.LONG, null, Long.valueOf(Long.MIN_VALUE), Long.valueOf(Long.MAX_VALUE));
        }
        if (type.equals("short") || type.equals(Short.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.SHORT, null, Short.valueOf((short)Short.MIN_VALUE), Short.valueOf((short)Short.MAX_VALUE));
        }
        if (type.equals(String.class.getName())) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.STRING);
        }
        if (type.equals("void")) {
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.VOID);
        }
        if (type.startsWith("java.util.Map")) {
            int lparam = type.indexOf("<");
            int comma = type.indexOf(",", lparam);
            int rparam = type.indexOf(">", comma);
            String key = type.substring(lparam + 1, comma).trim();
            OpenType<?> k = Translator.translate(key).getOpenType();
            OpenType<?> v = Translator.translate(type.substring(comma + 1, rparam).trim()).getOpenType();
            CompositeType ctype = new CompositeType(Map.class.getName(), Map.class.getName(), new String[]{"key", "value"}, new String[]{"Map key", "Map value"}, new OpenType[]{k, v});
            TabularType ttype = new TabularType(key, key, ctype, new String[]{"key"});
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", ttype);
        }
        if (type.startsWith("java.util.List")) {
            int lparam = type.indexOf("<");
            int rparam = type.indexOf(">");
            OpenType<?> e = Translator.translate(type.substring(lparam + 1, rparam).trim()).getOpenType();
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", new ArrayType(1, e));
        }
        try {
            c = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw (InternalError)new InternalError("The class for a type used in a management bean could not be loaded.").initCause(e);
        }
        if (c.isEnum()) {
            ?[] values = c.getEnumConstants();
            String[] names = new String[values.length];
            int a = 0;
            while (a < values.length) {
                names[a] = values[a].toString();
                ++a;
            }
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", SimpleType.STRING, null, names);
        }
        if (c.isArray()) {
            int depth = 0;
            while (c.getName().charAt(depth) == '[') {
                ++depth;
            }
            OpenType<?> ot = Translator.getTypeFromClass(c.getComponentType());
            return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", new ArrayType(depth, ot));
        }
        Method[] methods = c.getDeclaredMethods();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList types = new ArrayList();
        int a = 0;
        while (a < methods.length) {
            String name = methods[a].getName();
            if (Modifier.isPublic(methods[a].getModifiers())) {
                if (name.startsWith("get")) {
                    names.add(name.substring(3));
                    types.add(Translator.getTypeFromClass(methods[a].getReturnType()));
                } else if (name.startsWith("is")) {
                    names.add(name.substring(2));
                    types.add(Translator.getTypeFromClass(methods[a].getReturnType()));
                }
            }
            ++a;
        }
        if (names.isEmpty()) {
            throw new OpenDataException("The type used does not have an open type translation.");
        }
        String[] fields = names.toArray(new String[names.size()]);
        CompositeType ctype = new CompositeType(c.getName(), c.getName(), fields, fields, types.toArray(new OpenType[types.size()]));
        return new OpenMBeanParameterInfoSupport("TransParam", "Translated parameter", ctype);
    }

    private static final OpenType<?> getTypeFromClass(Class<?> c) throws OpenDataException {
        return Translator.translate(c.getName()).getOpenType();
    }

    private static final String getTypeName(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isArray()) {
                StringBuilder b = new StringBuilder(c.getComponentType().getName());
                String normName = c.getName();
                int a = 0;
                while (a < normName.length()) {
                    if (normName.charAt(a) != '[') break;
                    b.append("[]");
                    ++a;
                }
                return b.toString();
            }
            return c.getName();
        }
        return type.toString();
    }
}

