/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.BacktrackStack;
import gnu.java.util.regex.CharIndexed;
import java.io.Serializable;

public final class REMatch
implements Serializable,
Cloneable {
    private String matchedText;
    private CharIndexed matchedCharIndexed;
    int eflags;
    int offset;
    int anchor;
    int index;
    int[] start;
    int[] start1;
    int[] end;
    boolean empty;
    BacktrackStack backtrackStack;

    public Object clone() {
        try {
            REMatch copy = (REMatch)super.clone();
            copy.start = (int[])this.start.clone();
            copy.start1 = (int[])this.start1.clone();
            copy.end = (int[])this.end.clone();
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    void assignFrom(REMatch other) {
        this.start = other.start;
        this.start1 = other.start1;
        this.end = other.end;
        this.index = other.index;
        this.backtrackStack = other.backtrackStack;
    }

    REMatch(int subs, int anchor, int eflags) {
        this.start = new int[subs + 1];
        this.start1 = new int[subs + 1];
        this.end = new int[subs + 1];
        this.anchor = anchor;
        this.eflags = eflags;
        this.clear(anchor);
    }

    void finish(CharIndexed text) {
        this.start[0] = 0;
        CPStringBuilder sb = new CPStringBuilder();
        int i = 0;
        while (i < this.end[0]) {
            sb.append(text.charAt(i));
            ++i;
        }
        this.matchedText = sb.toString();
        this.matchedCharIndexed = text;
        i = 0;
        while (i < this.start.length) {
            if (this.start[i] == -1 ^ this.end[i] == -1) {
                this.start[i] = -1;
                this.end[i] = -1;
            }
            ++i;
        }
        this.backtrackStack = null;
    }

    void clear(int index) {
        this.offset = index;
        this.index = 0;
        int i = 0;
        while (i < this.start.length) {
            this.end[i] = -1;
            this.start1[i] = -1;
            this.start[i] = -1;
            ++i;
        }
        this.backtrackStack = null;
    }

    public String toString() {
        return this.matchedText;
    }

    public int getStartIndex() {
        return this.offset + this.start[0];
    }

    public int getEndIndex() {
        return this.offset + this.end[0];
    }

    public String toString(int sub) {
        if (sub >= this.start.length || sub < 0) {
            throw new IndexOutOfBoundsException("No group " + sub);
        }
        if (this.start[sub] == -1) {
            return null;
        }
        if (this.start[sub] >= 0 && this.end[sub] <= this.matchedText.length()) {
            return this.matchedText.substring(this.start[sub], this.end[sub]);
        }
        CPStringBuilder sb = new CPStringBuilder();
        int s = this.start[sub];
        int e = this.end[sub];
        if (s < 0) {
            ++s;
        }
        if (e < 0) {
            ++e;
        }
        int i = this.start[0] + s;
        while (i < this.start[0] + e) {
            sb.append(this.matchedCharIndexed.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public int getSubStartIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.start[sub];
        return x == -1 ? x : (x >= 0 ? this.offset + x : this.offset + x + 1);
    }

    public int getStartIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.start[sub];
        return x == -1 ? x : (x >= 0 ? this.offset + x : this.offset + x + 1);
    }

    public int getSubEndIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.end[sub];
        return x == -1 ? x : (x >= 0 ? this.offset + x : this.offset + x + 1);
    }

    public int getEndIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.end[sub];
        return x == -1 ? x : (x >= 0 ? this.offset + x : this.offset + x + 1);
    }

    public String substituteInto(String input) {
        CPStringBuilder output = new CPStringBuilder();
        int pos = 0;
        while (pos < input.length() - 1) {
            if (input.charAt(pos) == '$' && Character.isDigit(input.charAt(pos + 1))) {
                int val = Character.digit(input.charAt(++pos), 10);
                int pos1 = pos + 1;
                while (pos1 < input.length() && Character.isDigit(input.charAt(pos1))) {
                    int val1 = val * 10 + Character.digit(input.charAt(pos1), 10);
                    if (val1 >= this.start.length) break;
                    ++pos1;
                    val = val1;
                }
                pos = pos1 - 1;
                if (val < this.start.length) {
                    output.append(this.toString(val));
                }
            } else {
                output.append(input.charAt(pos));
            }
            ++pos;
        }
        if (pos < input.length()) {
            output.append(input.charAt(pos));
        }
        return output.toString();
    }
}

