/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.dgc.LeaseRenewingTask;
import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.RMIObjectInputStream;
import gnu.java.rmi.server.RMIObjectOutputStream;
import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastConnectionManager;
import gnu.java.rmi.server.UnicastRemoteCall;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.dgc.Lease;
import java.rmi.server.ObjID;
import java.rmi.server.Operation;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.UID;

public class UnicastRef
implements RemoteRef,
ProtocolConstants {
    private static final long serialVersionUID = 1L;
    public ObjID objid;
    UnicastConnectionManager manager;
    static long dgcSequence;
    static final ObjID dgcId;
    ObjID[] this_id;
    static int DIRTY;
    static final long dgcInterfaceHash = -669196253586618813L;

    static {
        dgcId = new ObjID(2);
        DIRTY = 1;
    }

    public UnicastRef() {
    }

    public UnicastRef(ObjID objid, String host, int port, RMIClientSocketFactory csf) {
        this(objid);
        this.manager = UnicastConnectionManager.getInstance(host, port, csf);
    }

    public UnicastRef(ObjID objid) {
        this.objid = objid;
    }

    public Object invoke(Remote obj, Method method, Object[] params, long opnum) throws Exception {
        Object svrobj = this.manager.serverobj;
        if (svrobj != null && method.getDeclaringClass().isInstance(svrobj)) {
            Object ret = null;
            try {
                ret = method.invoke(svrobj, params);
            }
            catch (InvocationTargetException e) {
                throw (Exception)e.getTargetException();
            }
            return ret;
        }
        return this.invokeCommon(obj, method, params, -1, opnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lease notifyDGC(Lease lease) throws Exception {
        Object returnval;
        int returncode;
        UnicastConnection conn;
        long seq;
        ObjID objID = dgcId;
        synchronized (objID) {
            seq = dgcSequence++;
        }
        if (this.this_id == null) {
            this.this_id = new ObjID[]{this.objid};
        }
        try {
            conn = this.manager.getConnection();
        }
        catch (IOException e1) {
            throw new RemoteException("connection failed to host: " + this.manager.serverName, e1);
        }
        try {
            DataOutputStream dout = conn.getDataOutputStream();
            dout.writeByte(80);
            ObjectOutputStream out = conn.startObjectOutputStream();
            dgcId.write(out);
            out.writeInt(DIRTY);
            out.writeLong(-669196253586618813L);
            RMIObjectOutputStream rout = (RMIObjectOutputStream)out;
            rout.writeValue(this.this_id, this.this_id.getClass());
            rout.writeLong(seq);
            rout.writeValue(lease, lease.getClass());
            out.flush();
        }
        catch (IOException e2) {
            throw new RemoteException("DGC call failed: ", e2);
        }
        try {
            DataInputStream din = conn.getDataInputStream();
            returncode = din.readUnsignedByte();
            if (returncode != 81) {
                conn.disconnect();
                throw new RemoteException("DGC Call not acked:" + returncode);
            }
            ObjectInputStream in = conn.startObjectInputStream();
            returncode = in.readUnsignedByte();
            UID.read(in);
            returnval = returncode == 2 ? in.readObject() : ((RMIObjectInputStream)in).readValue(Lease.class);
        }
        catch (IOException e3) {
            throw new RemoteException("DGC call return failed: ", e3);
        }
        this.manager.discardConnection(conn);
        if (returncode != 1 && returnval != null) {
            if (returncode == 2) {
                throw (Exception)returnval;
            }
            throw new RemoteException("DGC unexpected returncode: " + returncode);
        }
        return (Lease)returnval;
    }

    protected Object invokeCommon(Remote obj, Method method, Object[] params, int opnum, long hash) throws Exception {
        try {
            UnicastConnection conn = this.manager.getConnection();
            return this.invokeCommon(conn, obj, method, params, opnum, hash);
        }
        catch (IOException e1) {
            throw new RemoteException("connection failed to host: " + this.manager.serverName, e1);
        }
    }

    protected Object invokeCommon(UnicastConnection conn, Remote obj, Method method, Object[] params, int opnum, long hash) throws Exception {
        Object returnval;
        int returncode;
        try {
            DataOutputStream dout = conn.getDataOutputStream();
            dout.writeByte(80);
            ObjectOutputStream out = conn.startObjectOutputStream();
            this.objid.write(out);
            out.writeInt(opnum);
            out.writeLong(hash);
            Class<?>[] clss = method.getParameterTypes();
            int i = 0;
            while (i < clss.length) {
                ((RMIObjectOutputStream)out).writeValue(params[i], clss[i]);
                ++i;
            }
            out.flush();
        }
        catch (IOException e2) {
            throw new RemoteException("call failed: ", e2);
        }
        try {
            DataInputStream din = conn.getDataInputStream();
            returncode = din.readUnsignedByte();
            if (returncode != 81) {
                conn.disconnect();
                throw new RemoteException("Call not acked:" + returncode);
            }
            ObjectInputStream in = conn.startObjectInputStream();
            returncode = in.readUnsignedByte();
            UID.read(in);
            Class<?> cls = method.getReturnType();
            returnval = returncode == 2 ? in.readObject() : (cls == Void.TYPE ? null : ((RMIObjectInputStream)in).readValue(cls));
        }
        catch (IOException e3) {
            throw new RemoteException("call return failed: ", e3);
        }
        this.manager.discardConnection(conn);
        if (returncode != 1 && returnval != null) {
            if (returncode == 2) {
                throw (Exception)returnval;
            }
            throw new RemoteException("unexpected returncode: " + returncode);
        }
        return returnval;
    }

    public RemoteCall newCall(RemoteObject obj, Operation[] op, int opnum, long hash) throws RemoteException {
        UnicastConnection conn;
        try {
            conn = this.manager.getConnection();
        }
        catch (IOException e1) {
            throw new ConnectException("connection failed to host: " + this.manager.serverName, e1);
        }
        return new UnicastRemoteCall(conn, this.objid, opnum, hash);
    }

    public void invoke(RemoteCall call) throws Exception {
        UnicastRemoteCall cfr_ignored_0 = (UnicastRemoteCall)call;
        call.executeCall();
    }

    public void done(RemoteCall call) throws RemoteException {
        UnicastRemoteCall c = (UnicastRemoteCall)call;
        try {
            c.done();
        }
        catch (IOException iOException) {}
        UnicastConnection conn = c.getConnection();
        this.manager.discardConnection(conn);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.manager == null) {
            throw new IOException("no connection");
        }
        this.manager.write(out);
        this.objid.write(out);
        out.writeByte(0);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.manager = UnicastConnectionManager.read(in);
        this.objid = ObjID.read(in);
        byte ack = in.readByte();
        if (ack != 1 && ack != 0) {
            throw new IOException("no ack found");
        }
        if (this.manager.serverobj == null) {
            LeaseRenewingTask.scheduleLeases(this);
        }
    }

    public boolean remoteEquals(RemoteRef ref) {
        throw new Error("Not implemented");
    }

    public int remoteHashCode() {
        throw new Error("Not implemented");
    }

    public String getRefClass(ObjectOutput out) {
        return "UnicastRef";
    }

    public String remoteToString() {
        if (this.manager != null) {
            return this.manager.toString();
        }
        return "null manager";
    }

    public void dump(UnicastConnection conn) {
        try {
            DataInputStream din = conn.getDataInputStream();
            while (true) {
                int b = din.readUnsignedByte();
                System.out.print(Integer.toHexString(b));
                if (b >= 32 && b < 128) {
                    System.out.print(": " + (char)b);
                }
                System.out.println();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof UnicastRef) {
            UnicastRef r = (UnicastRef)other;
            return r.manager.equals(this.manager) && r.objid.equals(this.objid);
        }
        return false;
    }

    public int hashCode() {
        return this.manager.hashCode() ^ this.objid.hashCode();
    }
}

