/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;

public final class InputStreamChannel
implements ReadableByteChannel {
    private boolean closed = false;
    private InputStream in;

    public InputStreamChannel(InputStream in) {
        this.in = in;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.in.close();
            this.closed = true;
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public int read(ByteBuffer dst) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        byte[] buffer = new byte[dst.remaining()];
        int readBytes = this.in.read(buffer);
        if (readBytes > 0) {
            dst.put(buffer, 0, readBytes);
        }
        return readBytes;
    }
}

