/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.font.opentype.NameDecoder;
import gnu.java.awt.peer.ClasspathFontPeer;
import gnu.java.awt.peer.gtk.FreetypeGlyphVector;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import gnu.java.lang.CPStringBuilder;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.nio.ByteBuffer;
import java.text.CharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GdkFontPeer
extends ClasspathFontPeer {
    static final FontRenderContext DEFAULT_CTX = new FontRenderContext(null, false, false);
    HashMap<String, TextLayout> textLayoutCache = new GtkToolkit.LRUCache<String, TextLayout>(500);
    private final int native_state = GtkGenericPeer.getUniqueInteger();
    private HashMap<Integer, GlyphMetrics> metricsCache;
    private static final int FONT_METRICS_ASCENT = 0;
    private static final int FONT_METRICS_MAX_ASCENT = 1;
    private static final int FONT_METRICS_DESCENT = 2;
    private static final int FONT_METRICS_MAX_DESCENT = 3;
    private static final int FONT_METRICS_MAX_ADVANCE = 4;
    private static final int FONT_METRICS_HEIGHT = 5;
    private static final int FONT_METRICS_UNDERLINE_OFFSET = 6;
    private static final int FONT_METRICS_UNDERLINE_THICKNESS = 7;
    float ascent;
    float descent;
    float maxAscent;
    float maxDescent;
    float maxAdvance;
    float height;
    float underlineOffset;
    float underlineThickness;
    GdkFontMetrics metrics;
    private ByteBuffer nameTable = null;
    private Pointer nativeFont;

    static {
        System.loadLibrary("gtkpeer");
        GdkFontPeer.initStaticState();
    }

    static native void initStaticState();

    private native void initState();

    private native void dispose();

    private native void setFont(String var1, int var2, int var3);

    synchronized native void getFontMetrics(double[] var1);

    synchronized native void getTextMetrics(String var1, double[] var2);

    native void releasePeerGraphicsResource();

    protected void finalize() {
        this.releasePeerGraphicsResource();
        this.dispose();
    }

    private String buildString(CharacterIterator iter) {
        CPStringBuilder sb = new CPStringBuilder();
        char c = iter.first();
        while (c != '\uffff') {
            sb.append(c);
            c = iter.next();
        }
        return sb.toString();
    }

    private String buildString(CharacterIterator iter, int begin, int limit) {
        CPStringBuilder sb = new CPStringBuilder();
        int i = 0;
        char c = iter.first();
        while (c != '\uffff') {
            if (begin <= i) {
                sb.append(c);
            }
            if (limit <= i) break;
            c = iter.next();
            ++i;
        }
        return sb.toString();
    }

    private String buildString(char[] chars, int begin, int limit) {
        return new String(chars, begin, limit - begin);
    }

    public GdkFontPeer(String name, int style) {
        this(name, style, 12);
    }

    public GdkFontPeer(String name, int style, int size) {
        super(name, style, size);
        this.initState();
        this.setFont(this.familyName, this.style, (int)this.size);
        this.metricsCache = new HashMap();
        this.setupMetrics();
    }

    public GdkFontPeer(String name, Map attributes) {
        super(name, attributes);
        this.initState();
        this.setFont(this.familyName, this.style, (int)this.size);
        this.metricsCache = new HashMap();
        this.setupMetrics();
    }

    static Font initFont(Font font) {
        if (font == null) {
            return new Font("Dialog", 0, 12);
        }
        if (font.getPeer() instanceof GdkFontPeer) {
            return font;
        }
        ClasspathToolkit toolkit = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        return toolkit.getFont(font.getName(), font.getAttributes());
    }

    private void setupMetrics() {
        double[] hires = new double[8];
        this.getFontMetrics(hires);
        this.ascent = (float)hires[0];
        this.maxAscent = (float)hires[1];
        this.descent = (float)hires[2];
        this.maxDescent = (float)hires[3];
        this.maxAdvance = (float)hires[4];
        this.height = (float)hires[5];
        this.underlineOffset = (float)hires[6];
        this.underlineThickness = (float)hires[7];
    }

    public String getSubFamilyName(Font font, Locale locale) {
        String name;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((name = this.getName(2, locale)) == null && "Regular".equals(name = this.getName(2, Locale.ENGLISH))) {
            name = null;
        }
        return name;
    }

    private native byte[] getTrueTypeTable(byte var1, byte var2, byte var3, byte var4);

    public String getPostScriptName(Font font) {
        String name = this.getName(6, null);
        if (name == null) {
            return this.familyName;
        }
        return name;
    }

    private String getName(int name, Locale locale) {
        if (this.nameTable == null) {
            byte[] data = this.getTrueTypeTable((byte)110, (byte)97, (byte)109, (byte)101);
            if (data == null) {
                return null;
            }
            this.nameTable = ByteBuffer.wrap(data);
        }
        return NameDecoder.getName(this.nameTable, name, locale);
    }

    public boolean canDisplay(Font font, int c) {
        return true;
    }

    public int canDisplayUpTo(Font font, CharacterIterator i, int start, int limit) {
        return -1;
    }

    public GlyphVector createGlyphVector(Font font, FontRenderContext ctx, CharacterIterator i) {
        return new FreetypeGlyphVector(font, this.buildString(i), ctx);
    }

    public GlyphVector createGlyphVector(Font font, FontRenderContext ctx, int[] glyphCodes) {
        return new FreetypeGlyphVector(font, glyphCodes, ctx);
    }

    public byte getBaselineFor(Font font, char c) {
        return 0;
    }

    public LineMetrics getLineMetrics(Font font, CharacterIterator ci, int begin, int limit, FontRenderContext rc) {
        return new GdkFontLineMetrics(this, limit - begin);
    }

    public Rectangle2D getMaxCharBounds(Font font, FontRenderContext rc) {
        throw new UnsupportedOperationException();
    }

    public int getMissingGlyphCode(Font font) {
        throw new UnsupportedOperationException();
    }

    public String getGlyphName(Font font, int glyphIndex) {
        throw new UnsupportedOperationException();
    }

    public int getNumGlyphs(Font font) {
        byte[] data = this.getTrueTypeTable((byte)109, (byte)97, (byte)120, (byte)112);
        if (data == null) {
            return -1;
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        return buf.getShort(4);
    }

    public boolean hasUniformLineMetrics(Font font) {
        return true;
    }

    public GlyphVector layoutGlyphVector(Font font, FontRenderContext frc, char[] chars, int start, int limit, int flags) {
        return new FreetypeGlyphVector(font, chars, start, limit - start, frc, flags);
    }

    public LineMetrics getLineMetrics(Font font, String str, FontRenderContext frc) {
        return new GdkFontLineMetrics(this, str.length());
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.metrics == null) {
            this.metrics = new GdkFontMetrics(font);
        }
        return this.metrics;
    }

    GlyphMetrics getGlyphMetrics(int glyphCode) {
        return this.metricsCache.get(new Integer(glyphCode));
    }

    void putGlyphMetrics(int glyphCode, GlyphMetrics metrics) {
        this.metricsCache.put(new Integer(glyphCode), metrics);
    }

    private class GdkFontLineMetrics
    extends LineMetrics {
        private int nchars;

        public GdkFontLineMetrics(GdkFontPeer fp, int n) {
            this.nchars = n;
        }

        public float getAscent() {
            return GdkFontPeer.this.ascent;
        }

        public int getBaselineIndex() {
            return 0;
        }

        public float[] getBaselineOffsets() {
            return new float[3];
        }

        public float getDescent() {
            return GdkFontPeer.this.descent;
        }

        public float getHeight() {
            return GdkFontPeer.this.height;
        }

        public float getLeading() {
            return GdkFontPeer.this.height - (GdkFontPeer.this.ascent + GdkFontPeer.this.descent);
        }

        public int getNumChars() {
            return this.nchars;
        }

        public float getStrikethroughOffset() {
            return GdkFontPeer.this.ascent / 2.0f;
        }

        public float getStrikethroughThickness() {
            return 1.0f;
        }

        public float getUnderlineOffset() {
            return GdkFontPeer.this.underlineOffset;
        }

        public float getUnderlineThickness() {
            return GdkFontPeer.this.underlineThickness;
        }
    }

    private class GdkFontMetrics
    extends FontMetrics {
        public GdkFontMetrics(Font font) {
            super(GdkFontPeer.initFont(font));
        }

        public int stringWidth(String str) {
            TextLayout tl = GdkFontPeer.this.textLayoutCache.get(str);
            if (tl == null) {
                tl = new TextLayout(str, this.font, DEFAULT_CTX);
                GdkFontPeer.this.textLayoutCache.put(str, tl);
            }
            return (int)tl.getAdvance();
        }

        public int charWidth(char ch) {
            return this.stringWidth(new String(new char[]{ch}));
        }

        public int charsWidth(char[] data, int off, int len) {
            return this.stringWidth(new String(data, off, len));
        }

        public int getHeight() {
            return (int)GdkFontPeer.this.height;
        }

        public int getLeading() {
            return (int)(GdkFontPeer.this.height - (GdkFontPeer.this.ascent + GdkFontPeer.this.descent));
        }

        public int getAscent() {
            return (int)GdkFontPeer.this.ascent;
        }

        public int getMaxAscent() {
            return (int)GdkFontPeer.this.ascent;
        }

        public int getDescent() {
            return (int)GdkFontPeer.this.descent;
        }

        public int getMaxDescent() {
            return (int)GdkFontPeer.this.maxDescent;
        }

        public int getMaxAdvance() {
            return (int)GdkFontPeer.this.maxAdvance;
        }
    }
}

