/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.image;

import gnu.java.awt.image.AsyncImage;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class ImageConverter
implements ImageConsumer {
    public static final String IMAGE_TRANSPARENCY_PROPERTY = "gnu.awt.image.transparency";
    public static final String IMAGE_PROPERTIES_PROPERTY = "gnu.awt.image.properties";
    private AsyncImage image = new AsyncImage();
    private BufferedImage bImage;
    private Hashtable imageProperties;
    private int width = 0;
    private int height = 0;
    private ColorModel colorModel;
    private ColorModel targetColorModel;

    public void setDimensions(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setProperties(Hashtable props) {
    }

    public void setColorModel(ColorModel model) {
        this.colorModel = model;
    }

    public void setHints(int flags) {
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        model = this.setupColorModel(model);
        if (this.bImage == null) {
            this.createImage();
        }
        Integer t = (Integer)this.imageProperties.get(IMAGE_TRANSPARENCY_PROPERTY);
        int transparency = t;
        transparency = this.targetColorModel.equals(model) ? this.transferPixels(x, y, w, h, model, pixels, offset, scansize, transparency) : (model instanceof IndexColorModel && this.targetColorModel.equals(ColorModel.getRGBdefault()) ? this.convertIndexColorModelToSRGB(x, y, w, h, (IndexColorModel)model, pixels, offset, scansize, transparency) : this.convertPixels(x, y, w, h, model, pixels, offset, scansize, transparency));
        this.imageProperties.put(IMAGE_TRANSPARENCY_PROPERTY, transparency);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        model = this.setupColorModel(model);
        if (this.bImage == null) {
            this.createImage();
        }
        Integer t = (Integer)this.imageProperties.get(IMAGE_TRANSPARENCY_PROPERTY);
        int transparency = t;
        transparency = this.targetColorModel.equals(model) ? this.transferPixels(x, y, w, h, model, pixels, offset, scansize, transparency) : (model instanceof IndexColorModel && this.targetColorModel.equals(ColorModel.getRGBdefault()) ? this.convertIndexColorModelToSRGB(x, y, w, h, (IndexColorModel)model, pixels, offset, scansize, transparency) : this.convertPixels(x, y, w, h, model, pixels, offset, scansize, transparency));
        this.imageProperties.put(IMAGE_TRANSPARENCY_PROPERTY, transparency);
    }

    private ColorModel setupColorModel(ColorModel model) {
        if (model == null) {
            model = this.colorModel;
        }
        if (model == null) {
            model = ColorModel.getRGBdefault();
        }
        if (this.targetColorModel == null) {
            this.targetColorModel = model;
        }
        this.targetColorModel = ColorModel.getRGBdefault();
        return model;
    }

    private void createImage() {
        if (this.imageProperties == null) {
            this.imageProperties = new Hashtable();
        }
        this.imageProperties.put(IMAGE_TRANSPARENCY_PROPERTY, 1);
        this.imageProperties.put(IMAGE_PROPERTIES_PROPERTY, this.imageProperties);
        if (ColorModel.getRGBdefault().equals(this.targetColorModel)) {
            this.bImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.width, this.height, 3);
        } else {
            WritableRaster raster = this.targetColorModel.createCompatibleWritableRaster(this.width, this.height);
            this.bImage = new BufferedImage(this.targetColorModel, raster, false, this.imageProperties);
        }
        this.image.setRealImage(this.bImage);
    }

    private int transferPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize, int transparency) {
        this.bImage.getRaster().setDataElements(x, y, w, h, pixels);
        int yy = 0;
        while (yy < h) {
            int xx = 0;
            while (xx < w) {
                int pixel = 0xFF & pixels[yy * scansize + xx + offset];
                int alpha = model.getAlpha(pixel);
                transparency = this.updateTransparency(alpha, transparency);
                ++xx;
            }
            ++yy;
        }
        return transparency;
    }

    private int transferPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize, int transparency) {
        this.bImage.getRaster().setDataElements(x, y, w, h, pixels);
        int yy = 0;
        while (yy < h) {
            int xx = 0;
            while (xx < w) {
                int pixel = pixels[yy * scansize + xx + offset];
                int alpha = model.getAlpha(pixel);
                transparency = this.updateTransparency(alpha, transparency);
                ++xx;
            }
            ++yy;
        }
        return transparency;
    }

    private int convertPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize, int transparency) {
        Object dataEl = null;
        int yy = 0;
        while (yy < h) {
            int xx = 0;
            while (xx < w) {
                int pixel = 0xFF & pixels[yy * scansize + xx + offset];
                int rgb = model.getRGB(pixel);
                int alpha = model.getAlpha(pixel);
                transparency = this.updateTransparency(alpha, transparency);
                dataEl = this.targetColorModel.getDataElements(rgb, dataEl);
                this.bImage.getRaster().setDataElements(x + xx, y + yy, dataEl);
                ++xx;
            }
            ++yy;
        }
        return transparency;
    }

    private int convertPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize, int transparency) {
        Object dataEl = null;
        int yy = 0;
        while (yy < h) {
            int xx = 0;
            while (xx < w) {
                int pixel = pixels[yy * scansize + xx + offset];
                int rgb = model.getRGB(pixel);
                int alpha = model.getAlpha(pixel);
                transparency = this.updateTransparency(alpha, transparency);
                dataEl = this.targetColorModel.getDataElements(rgb, dataEl);
                this.bImage.getRaster().setDataElements(x + xx, y + yy, dataEl);
                ++xx;
            }
            ++yy;
        }
        return transparency;
    }

    private int convertIndexColorModelToSRGB(int x, int y, int w, int h, IndexColorModel model, byte[] pixels, int offset, int scansize, int transparency) {
        int mapSize = model.getMapSize();
        int[] colorMap = new int[mapSize];
        int i = 0;
        while (i < mapSize) {
            colorMap[i] = model.getRGB(i);
            ++i;
        }
        WritableRaster raster = this.bImage.getRaster();
        SinglePixelPackedSampleModel sampleMode = (SinglePixelPackedSampleModel)raster.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        int rasterOffset = sampleMode.getOffset(x, y) + dataBuffer.getOffset();
        int rasterScanline = sampleMode.getScanlineStride();
        int yy = 0;
        while (yy < h) {
            int xoffset = offset;
            int xx = 0;
            while (xx < w) {
                int argb = colorMap[pixels[xoffset++] & 0xFF];
                dataBuffer.setElem(rasterOffset + xx, argb);
                int alpha = argb >>> 24;
                transparency = this.updateTransparency(alpha, transparency);
                ++xx;
            }
            offset += scansize;
            rasterOffset += rasterScanline;
            ++yy;
        }
        return transparency;
    }

    private int convertIndexColorModelToSRGB(int x, int y, int w, int h, IndexColorModel model, int[] pixels, int offset, int scansize, int transparency) {
        int mapSize = model.getMapSize();
        int[] colorMap = new int[mapSize];
        int i = 0;
        while (i < mapSize) {
            colorMap[i] = model.getRGB(i);
            ++i;
        }
        WritableRaster raster = this.bImage.getRaster();
        SinglePixelPackedSampleModel sampleMode = (SinglePixelPackedSampleModel)raster.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        int rasterOffset = sampleMode.getOffset(x, y) + dataBuffer.getOffset();
        int rasterScanline = sampleMode.getScanlineStride();
        int yy = 0;
        while (yy < h) {
            int xoffset = offset;
            int xx = 0;
            while (xx < w) {
                int argb = colorMap[pixels[xoffset++]];
                dataBuffer.setElem(rasterOffset + xx, argb);
                int alpha = argb >>> 24;
                transparency = this.updateTransparency(alpha, transparency);
                ++xx;
            }
            offset += scansize;
            rasterOffset += rasterScanline;
            ++yy;
        }
        return transparency;
    }

    private int updateTransparency(int alpha, int transparency) {
        if (alpha != 255) {
            if (alpha == 0 && transparency <= 2) {
                transparency = 2;
            } else if (transparency < 3) {
                transparency = 3;
            }
        }
        return transparency;
    }

    public void imageComplete(int status) {
        this.image.notifyObservers(32, 0, 0, this.width, this.height);
    }

    public void setTargetColorModel(ColorModel model) {
        this.targetColorModel = model;
    }

    public Image getImage() {
        return this.image;
    }
}

