/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.peer.EmbeddedWindowPeer;
import gnu.java.security.action.SetAccessibleAction;
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.Field;
import java.security.AccessController;

public class EmbeddedWindow
extends Frame {
    private long handle;

    public EmbeddedWindow() {
        this.handle = 0L;
    }

    public EmbeddedWindow(long handle) {
        this.handle = handle;
    }

    public void addNotify() {
        ClasspathToolkit tk = (ClasspathToolkit)this.getToolkit();
        try {
            Field peerField = Component.class.getDeclaredField("peer");
            AccessController.doPrivileged(new SetAccessibleAction(peerField));
            peerField.set(this, tk.createEmbeddedWindow(this));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        super.addNotify();
    }

    public void setHandle(long handle) {
        if (this.handle != 0L) {
            throw new RuntimeException("EmbeddedWindow is already embedded");
        }
        this.handle = handle;
        if (this.getPeer() != null) {
            ((EmbeddedWindowPeer)this.getPeer()).embed(this.handle);
        }
    }

    public long getHandle() {
        return this.handle;
    }
}

