/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.NamingService;

import gnu.CORBA.NamingService.NameComponentComparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.InvalidName;

public class NamingMap {
    protected final TreeMap map = new TreeMap(NameComponentComparator.singleton);

    public void bind(NameComponent name, Object object) throws AlreadyBound, InvalidName {
        if (this.containsKey(name)) {
            Object x = this.get(name);
            if (x.equals(object)) {
                throw new AlreadyBound("The name is in use for another object");
            }
        } else if (this.containsValue(object)) {
            throw new AlreadyBound("The object has another name");
        }
        this.rebind(name, object);
    }

    public boolean containsKey(NameComponent key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public Set entries() {
        return this.map.entrySet();
    }

    public Object get(NameComponent name) {
        return (Object)this.map.get(name);
    }

    public void rebind(NameComponent name, Object object) throws InvalidName {
        this.remove(name);
        Iterator iter = this.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry item = (Map.Entry)iter.next();
            if (!item.getValue().equals(object)) continue;
            iter.remove();
        }
        this.map.put(name, object);
    }

    public void remove(NameComponent name) {
        this.map.remove(name);
    }

    public int size() {
        return this.map.size();
    }
}

