/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.FormSubmitEvent;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.Option;
import javax.swing.text.html.ResetableModel;
import javax.swing.text.html.ResetableToggleButtonModel;
import javax.swing.text.html.SelectComboBoxModel;
import javax.swing.text.html.SelectListModel;

public class FormView
extends ComponentView
implements ActionListener {
    public static final String SUBMIT = UIManager.getString("FormView.submitButtonText");
    public static final String RESET = UIManager.getString("FormView.resetButtonText");
    private boolean maxIsPreferred;

    public FormView(Element el) {
        super(el);
    }

    protected Component createComponent() {
        JComponent comp = null;
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        Object tag = atts.getAttribute(StyleConstants.NameAttribute);
        Object model = atts.getAttribute(StyleConstants.ModelAttribute);
        if (tag.equals(HTML.Tag.INPUT)) {
            String type = (String)atts.getAttribute(HTML.Attribute.TYPE);
            if (type.equals("button")) {
                String value = (String)atts.getAttribute(HTML.Attribute.VALUE);
                JButton b = new JButton(value);
                if (model != null) {
                    b.setModel((ButtonModel)model);
                    b.addActionListener(this);
                }
                comp = b;
                this.maxIsPreferred = true;
            } else if (type.equals("checkbox")) {
                if (model instanceof ResetableToggleButtonModel) {
                    ResetableToggleButtonModel m = (ResetableToggleButtonModel)model;
                    JCheckBox c = new JCheckBox();
                    c.setModel(m);
                    comp = c;
                    this.maxIsPreferred = true;
                }
            } else if (type.equals("image")) {
                JButton b;
                String src = (String)atts.getAttribute(HTML.Attribute.SRC);
                try {
                    URL base = ((HTMLDocument)el.getDocument()).getBase();
                    URL srcURL = new URL(base, src);
                    ImageIcon icon = new ImageIcon(srcURL);
                    b = new JButton(icon);
                }
                catch (MalformedURLException malformedURLException) {
                    b = new JButton(src);
                }
                if (model != null) {
                    b.setModel((ButtonModel)model);
                    b.addActionListener(this);
                }
                comp = b;
                this.maxIsPreferred = true;
            } else if (type.equals("password")) {
                int size = HTML.getIntegerAttributeValue(atts, HTML.Attribute.SIZE, -1);
                JPasswordField tf = new JPasswordField();
                if (size > 0) {
                    tf.setColumns(size);
                } else {
                    tf.setColumns(20);
                }
                if (model != null) {
                    tf.setDocument((Document)model);
                }
                tf.addActionListener(this);
                comp = tf;
                this.maxIsPreferred = true;
            } else if (type.equals("radio")) {
                if (model instanceof ResetableToggleButtonModel) {
                    ResetableToggleButtonModel m = (ResetableToggleButtonModel)model;
                    JRadioButton c = new JRadioButton();
                    c.setModel(m);
                    comp = c;
                    this.maxIsPreferred = true;
                }
            } else if (type.equals("reset")) {
                String value = (String)atts.getAttribute(HTML.Attribute.VALUE);
                if (value == null) {
                    value = UIManager.getString("FormView.resetButtonText");
                }
                JButton b = new JButton(value);
                if (model != null) {
                    b.setModel((ButtonModel)model);
                    b.addActionListener(this);
                }
                comp = b;
                this.maxIsPreferred = true;
            } else if (type.equals("submit")) {
                String value = (String)atts.getAttribute(HTML.Attribute.VALUE);
                if (value == null) {
                    value = UIManager.getString("FormView.submitButtonText");
                }
                JButton b = new JButton(value);
                if (model != null) {
                    b.setModel((ButtonModel)model);
                    b.addActionListener(this);
                }
                comp = b;
                this.maxIsPreferred = true;
            } else if (type.equals("text")) {
                int size = HTML.getIntegerAttributeValue(atts, HTML.Attribute.SIZE, -1);
                JTextField tf = new JTextField();
                if (size > 0) {
                    tf.setColumns(size);
                } else {
                    tf.setColumns(20);
                }
                if (model != null) {
                    tf.setDocument((Document)model);
                }
                tf.addActionListener(this);
                comp = tf;
                this.maxIsPreferred = true;
            }
        } else if (tag == HTML.Tag.TEXTAREA) {
            JTextArea textArea = new JTextArea((Document)model);
            int rows = HTML.getIntegerAttributeValue(atts, HTML.Attribute.ROWS, 1);
            textArea.setRows(rows);
            int cols = HTML.getIntegerAttributeValue(atts, HTML.Attribute.COLS, 20);
            textArea.setColumns(cols);
            this.maxIsPreferred = true;
            comp = new JScrollPane(textArea, 22, 32);
        } else if (tag == HTML.Tag.SELECT) {
            if (model instanceof SelectListModel) {
                SelectListModel slModel = (SelectListModel)model;
                JList list2 = new JList(slModel);
                int size = HTML.getIntegerAttributeValue(atts, HTML.Attribute.SIZE, 1);
                list2.setVisibleRowCount(size);
                list2.setSelectionModel(slModel.getSelectionModel());
                comp = new JScrollPane(list2);
            } else if (model instanceof SelectComboBoxModel) {
                SelectComboBoxModel scbModel = (SelectComboBoxModel)model;
                comp = new JComboBox(scbModel);
            }
            this.maxIsPreferred = true;
        }
        return comp;
    }

    public float getMaximumSpan(int axis) {
        float span = this.maxIsPreferred ? this.getPreferredSpan(axis) : super.getMaximumSpan(axis);
        return span;
    }

    public void actionPerformed(ActionEvent ev) {
        Element el = this.getElement();
        Object tag = el.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (tag.equals(HTML.Tag.INPUT)) {
            AttributeSet atts = el.getAttributes();
            String type = (String)atts.getAttribute(HTML.Attribute.TYPE);
            if (type.equals("submit")) {
                this.submitData(this.getFormData());
            } else if (type.equals("reset")) {
                this.resetForm();
            }
        }
    }

    protected void submitData(String data) {
        SubmitThread submitThread = new SubmitThread(data);
        submitThread.start();
    }

    protected void imageSubmit(String imageData) {
    }

    String getImageData(Point p) {
        String name = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.NAME);
        String data = name == null || name.equals("") ? "x=" + p.x + "&y=" + p.y : String.valueOf(name) + ".x=" + p.x + "&" + name + ".y=" + p.y;
        return data;
    }

    Element getFormElement() {
        Element form = null;
        Element el = this.getElement();
        while (el != null && form == null) {
            AttributeSet atts = el.getAttributes();
            if (atts.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.FORM) {
                form = el;
                continue;
            }
            el = el.getParentElement();
        }
        return form;
    }

    private String getFormData() {
        Element form = this.getFormElement();
        StringBuilder b = new StringBuilder();
        if (form != null) {
            Element next;
            ElementIterator i = new ElementIterator(form);
            while ((next = i.next()) != null) {
                AttributeSet atts;
                String type;
                if (!next.isLeaf() || (type = (String)(atts = next.getAttributes()).getAttribute(HTML.Attribute.TYPE)) != null && type.equals("submit") && next != this.getElement() || type != null && type.equals("image")) continue;
                this.getElementFormData(next, b);
            }
        }
        return b.toString();
    }

    private void getElementFormData(Element el, StringBuilder b) {
        AttributeSet atts = el.getAttributes();
        String name = (String)atts.getAttribute(HTML.Attribute.NAME);
        if (name != null) {
            String value = null;
            HTML.Tag tag = (HTML.Tag)atts.getAttribute(StyleConstants.NameAttribute);
            if (tag == HTML.Tag.SELECT) {
                this.getSelectData(atts, b);
            } else {
                if (tag == HTML.Tag.INPUT) {
                    value = this.getInputFormData(atts);
                } else if (tag == HTML.Tag.TEXTAREA) {
                    value = this.getTextAreaData(atts);
                }
                if (name != null && value != null) {
                    this.addData(b, name, value);
                }
            }
        }
    }

    private void getSelectData(AttributeSet atts, StringBuilder b) {
        String name = (String)atts.getAttribute(HTML.Attribute.NAME);
        if (name != null) {
            SelectComboBoxModel scb;
            Option o;
            Object m = atts.getAttribute(StyleConstants.ModelAttribute);
            if (m instanceof SelectListModel) {
                SelectListModel sl = (SelectListModel)m;
                ListSelectionModel lsm = sl.getSelectionModel();
                int i = 0;
                while (i < sl.getSize()) {
                    if (lsm.isSelectedIndex(i)) {
                        Option o2 = (Option)sl.getElementAt(i);
                        this.addData(b, name, o2.getValue());
                    }
                    ++i;
                }
            } else if (m instanceof SelectComboBoxModel && (o = (Option)(scb = (SelectComboBoxModel)m).getSelectedItem()) != null) {
                this.addData(b, name, o.getValue());
            }
        }
    }

    private String getTextAreaData(AttributeSet atts) {
        String data;
        Document doc = (Document)atts.getAttribute(StyleConstants.ModelAttribute);
        try {
            data = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            data = null;
        }
        return data;
    }

    private String getInputFormData(AttributeSet atts) {
        String type = (String)atts.getAttribute(HTML.Attribute.TYPE);
        Object model = atts.getAttribute(StyleConstants.ModelAttribute);
        String value = null;
        if (type.equals("text") || type.equals("password")) {
            Document doc = (Document)model;
            try {
                value = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException badLocationException) {
                assert (false);
            }
        } else if ((type.equals("hidden") || type.equals("submit")) && (value = (String)atts.getAttribute(HTML.Attribute.VALUE)) == null) {
            value = "";
        }
        return value;
    }

    private void addData(StringBuilder b, String name, String value) {
        if (b.length() > 0) {
            b.append('&');
        }
        String encName = URLEncoder.encode(name);
        b.append(encName);
        b.append('=');
        String encValue = URLEncoder.encode(value);
        b.append(encValue);
    }

    private void resetForm() {
        Element form = this.getFormElement();
        if (form != null) {
            Element next;
            ElementIterator iter = new ElementIterator(form);
            while ((next = iter.next()) != null) {
                AttributeSet atts;
                Object m;
                if (!next.isLeaf() || !((m = (atts = next.getAttributes()).getAttribute(StyleConstants.ModelAttribute)) instanceof ResetableModel)) continue;
                ((ResetableModel)m).reset();
            }
        }
    }

    protected class MouseEventListener
    extends MouseAdapter {
        protected MouseEventListener() {
        }

        public void mouseReleased(MouseEvent ev) {
            String data = FormView.this.getImageData(ev.getPoint());
            FormView.this.imageSubmit(data);
        }
    }

    private class SubmitThread
    extends Thread {
        private String data;

        SubmitThread(String d) {
            this.data = d;
        }

        public void run() {
            if (this.data.length() > 0) {
                final String method = this.getMethod();
                final URL actionURL = this.getActionURL();
                final String target = this.getTarget();
                final JEditorPane editor = (JEditorPane)FormView.this.getContainer();
                final HTMLDocument doc = (HTMLDocument)editor.getDocument();
                HTMLEditorKit kit = (HTMLEditorKit)editor.getEditorKit();
                if (kit.isAutoFormSubmission()) {
                    try {
                        URL url;
                        if (method != null && method.equals("post")) {
                            url = actionURL;
                            URLConnection conn = url.openConnection();
                            this.postData(conn, this.data);
                        } else {
                            url = new URL(actionURL + "?" + this.data);
                        }
                        Runnable loadDoc = new Runnable(){

                            public void run() {
                                if (doc.isFrameDocument()) {
                                    editor.fireHyperlinkUpdate(SubmitThread.this.createSubmitEvent(method, actionURL, target));
                                } else {
                                    try {
                                        editor.setPage(url);
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            }
                        };
                        SwingUtilities.invokeLater(loadDoc);
                    }
                    catch (MalformedURLException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    editor.fireHyperlinkUpdate(this.createSubmitEvent(method, actionURL, target));
                }
            }
        }

        private String getMethod() {
            AttributeSet formAtts = this.getFormAttributes();
            String method = null;
            if (formAtts != null) {
                method = (String)formAtts.getAttribute(HTML.Attribute.METHOD);
            }
            return method;
        }

        private URL getActionURL() {
            String action;
            AttributeSet formAtts = this.getFormAttributes();
            HTMLDocument doc = (HTMLDocument)FormView.this.getElement().getDocument();
            URL url = doc.getBase();
            if (formAtts != null && (action = (String)formAtts.getAttribute(HTML.Attribute.ACTION)) != null) {
                try {
                    url = new URL(url, action);
                }
                catch (MalformedURLException malformedURLException) {
                    url = null;
                }
            }
            return url;
        }

        private String getTarget() {
            AttributeSet formAtts = this.getFormAttributes();
            String target = null;
            if (formAtts != null && (target = (String)formAtts.getAttribute(HTML.Attribute.TARGET)) != null) {
                target = target.toLowerCase();
            }
            if (target == null) {
                target = "_self";
            }
            return target;
        }

        private void postData(URLConnection conn, String data) {
            conn.setDoOutput(true);
            PrintWriter out = null;
            try {
                try {
                    out = new PrintWriter(new OutputStreamWriter(conn.getOutputStream()));
                    out.print(data);
                    out.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (out != null) {
                        out.close();
                    }
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }

        private AttributeSet getFormAttributes() {
            AttributeSet atts = null;
            Element form = FormView.this.getFormElement();
            if (form != null) {
                atts = form.getAttributes();
            }
            return atts;
        }

        FormSubmitEvent createSubmitEvent(String method, URL actionURL, String target) {
            FormSubmitEvent.MethodType m = "post".equals(method) ? FormSubmitEvent.MethodType.POST : FormSubmitEvent.MethodType.GET;
            return new FormSubmitEvent(FormView.this, HyperlinkEvent.EventType.ACTIVATED, actionURL, FormView.this.getElement(), target, m, this.data);
        }
    }
}

